/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyResolver;", "", "dependency", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "virtualResolved", "", "(Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;Z)V", "resolvedRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getOrResolveLocation", "Companion", "intellij.javascript.impl"})
public final class YarnPnpDependencyResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YarnPnpDependency dependency;
    private final boolean virtualResolved;
    @Nullable
    private volatile Ref<VirtualFile> resolvedRef;
    private static final Pattern VIRTUAL_FS_PATTERN = Pattern.compile("/virtual/[^/]+/(\\d+)/[^/]+/");

    public YarnPnpDependencyResolver(@NotNull YarnPnpDependency dependency, boolean virtualResolved) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.dependency = dependency;
        this.virtualResolved = virtualResolved;
    }

    @Nullable
    public final VirtualFile getOrResolveLocation() {
        VirtualFile localResolved;
        Ref localResolvedRef = this.resolvedRef;
        if (localResolvedRef == null) {
            this.resolvedRef = localResolvedRef = new Ref((Object)YarnPnpDependencyResolver.Companion.resolveDependencyRoot(this.dependency, this.virtualResolved));
        }
        return (localResolved = (VirtualFile)localResolvedRef.get()) != null && localResolved.isValid() ? localResolved : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyResolver$Companion;", "", "()V", "VIRTUAL_FS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "resolveDependencyRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "dependency", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "virtualResolved", "", "resolveVirtual", "Ljava/io/File;", "path", "", "resolveZipArchive", "resolveZipPath", "Lcom/intellij/openapi/util/Pair;", "location", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final VirtualFile resolveDependencyRoot(YarnPnpDependency dependency, boolean virtualResolved) {
            String location = dependency.getLocation();
            Pair<File, String> zipPath = this.resolveZipPath(location, virtualResolved);
            if (zipPath != null) {
                String fullPath = ((File)zipPath.first).getAbsolutePath() + "!/" + StringUtil.trimLeading((String)((String)zipPath.second), (char)'/');
                return JarFileSystem.getInstance().findFileByPath(fullPath);
            }
            return LocalFileSystem.getInstance().findFileByPath(location);
        }

        private final Pair<File, String> resolveZipPath(String location, boolean virtualResolved) {
            String dotZip = ".zip";
            int dotZipStartIndex = StringsKt.lastIndexOf$default((CharSequence)location, (String)dotZip, (int)0, (boolean)false, (int)6, null);
            while (dotZipStartIndex > 0) {
                String string = location.substring(0, dotZipStartIndex + dotZip.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                File zipArchive = this.resolveZipArchive(string, virtualResolved);
                if (zipArchive != null) {
                    String string2 = location.substring(dotZipStartIndex + dotZip.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    return Pair.create((Object)zipArchive, (Object)string2);
                }
                dotZipStartIndex = StringsKt.lastIndexOf$default((CharSequence)location, (String)dotZip, (int)(dotZipStartIndex - 1), (boolean)false, (int)4, null);
            }
            return null;
        }

        private final File resolveZipArchive(String path2, boolean virtualResolved) {
            File file = new File(path2);
            if (file.exists()) {
                return file;
            }
            return virtualResolved ? null : this.resolveVirtual(path2);
        }

        private final File resolveVirtual(String path2) {
            Matcher matcher = VIRTUAL_FS_PATTERN.matcher(path2);
            if (matcher.find()) {
                String string = path2.substring(0, matcher.start(0));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String baseDir = string;
                int upCount = StringUtil.parseInt((String)matcher.group(1), (int)-1);
                if (upCount < 0) {
                    return null;
                }
                for (int i = 0; i < upCount; ++i) {
                    String parentDir;
                    Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getParentPath((String)baseDir), (String)"getParentPath(...)");
                    if (Intrinsics.areEqual((Object)parentDir, (Object)baseDir)) {
                        return null;
                    }
                    baseDir = parentDir;
                }
                if (((CharSequence)baseDir).length() == 0) {
                    return null;
                }
                String string2 = path2.substring(matcher.end(1));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                File file = new File(baseDir + string2);
                if (file.isFile()) {
                    return file;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

