/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.google.common.collect.ImmutableSet;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.PackageJsonDependency;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesIndexingRulesProvider;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesLibraryStat;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesStatKt;
import com.intellij.javascript.nodejs.packages.NodePackageLinkResolver;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.NodeModulesIndexableFileNamesProvider;
import com.intellij.lang.typescript.psi.TypeScriptExcludeUtil;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeModulesLibraryDirectory {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibraryDirectory.class);
    private static final Set<String> BUILD_DIR_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"dist", "build", "built"});
    private final Project myProject;
    private final VirtualFile myNodeModulesDir;
    private final String myLibraryName;
    private final AtomicInteger myLibraryCalcCount;
    private final NodeModulesIndexingRulesProvider myNodeModulesIndexingRulesProvider;
    private volatile SyntheticLibrary myLibrary;
    @Nullable
    private NodeModulesLibraryDirectory myWorkspaceRoot;
    private final List<VirtualFile> myChildWorkspaceRoots;
    private final NodeModulesDirectoryManager myDirectoryManager;
    private final List<NodeModulesLibraryDirectory> myDescendants;

    public NodeModulesLibraryDirectory(@NotNull NodeModulesDirectoryManager directoryManager, @NotNull VirtualFile nodeModulesDir, @NotNull String libraryName) {
        if (directoryManager == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(0);
        }
        if (nodeModulesDir == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(2);
        }
        this.myLibraryCalcCount = new AtomicInteger(0);
        this.myChildWorkspaceRoots = new ArrayList<VirtualFile>();
        this.myDescendants = new ArrayList<NodeModulesLibraryDirectory>();
        this.myProject = directoryManager.getProject();
        this.myDirectoryManager = directoryManager;
        this.myNodeModulesDir = nodeModulesDir;
        this.myLibraryName = libraryName;
        this.myNodeModulesIndexingRulesProvider = NodeModulesIndexingRulesProvider.getInstance(directoryManager.getProject());
    }

    @NotNull
    public VirtualFile getNodeModulesDir() {
        VirtualFile virtualFile = this.myNodeModulesDir;
        if (virtualFile == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public boolean isForApplicationSourceCode() {
        return this.myDirectoryManager.isForApplicationSourceCode(this.myNodeModulesDir);
    }

    void addDescendant(@NotNull NodeModulesLibraryDirectory descendant) {
        if (descendant == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(4);
        }
        this.myDescendants.add(descendant);
    }

    @NotNull
    public List<NodeModulesLibraryDirectory> getThisAndDescendants() {
        List list2 = ContainerUtil.concat(List.of(this), this.myDescendants);
        if (list2 == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    static VirtualFile findChild(@Nullable VirtualFile parent, @NotNull String childName, boolean directory) {
        if (childName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(6);
        }
        VirtualFile child = parent != null ? parent.findChild(childName) : null;
        return child != null && child.isValid() && child.isDirectory() == directory ? child : null;
    }

    void setWorkspaceRoot(@Nullable NodeModulesLibraryDirectory workspaceRoot) {
        this.myWorkspaceRoot = workspaceRoot;
    }

    @NotNull
    public String getLibraryName() {
        String string = this.myLibraryName;
        if (string == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void invalidateRoots() {
        this.myDirectoryManager.incNodeModulesDirChangeTracker();
        this.myLibrary = null;
        this.myLibraryCalcCount.set(0);
    }

    @NotNull
    public SyntheticLibrary getLibrary() {
        SyntheticLibrary library = this.myLibrary;
        if (library == null) {
            this.myLibrary = library = this.createLibrary();
        }
        SyntheticLibrary syntheticLibrary = library;
        if (syntheticLibrary == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(8);
        }
        return syntheticLibrary;
    }

    @NotNull
    private SyntheticLibrary createLibrary() {
        int calcCount = this.myLibraryCalcCount.incrementAndGet();
        if (calcCount > 1) {
            LOG.debug("Concurrent node_modules roots calculation: " + calcCount);
        }
        return this.doCreateLibrary();
    }

    @NotNull
    private SyntheticLibrary doCreateLibrary() {
        Set<VirtualFile> roots;
        if (!this.myNodeModulesDir.isValid()) {
            LOG.warn("Invalid " + this.myNodeModulesDir.getPath());
            SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(Collections.emptyList());
            if (syntheticLibrary == null) {
                NodeModulesLibraryDirectory.$$$reportNull$$$0(9);
            }
            return syntheticLibrary;
        }
        long startNano = System.nanoTime();
        VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(this.myNodeModulesDir);
        List<VirtualFile> typingsModules = this.getTypingsModules();
        if (packageJson != null && packageJson.isValid()) {
            PackageJsonFiles packageJsonFiles = new PackageJsonFiles(this.myProject, packageJson, this.myChildWorkspaceRoots);
            roots = this.getIndexableModuleRoots(packageJsonFiles, typingsModules);
            for (Pair<VirtualFile, PackageJsonData> pair : packageJsonFiles.myList) {
                this.myDirectoryManager.setProvidedPackageJsonRoots((VirtualFile)pair.first, (PackageJsonData)pair.second);
            }
        } else {
            roots = new HashSet<VirtualFile>();
        }
        ImmutableSet directRoots = ImmutableSet.copyOf(roots);
        Pair<Set<VirtualFile>, Set<VirtualFile>> pair = this.collectTsOnlyRoots(roots);
        ImmutableSet tsOnlyRoots = ImmutableSet.copyOf((Collection)((Collection)pair.first));
        Set additionalRootsWithSources = (Set)pair.second;
        roots.addAll((Collection<VirtualFile>)tsOnlyRoots);
        roots.addAll(additionalRootsWithSources);
        HashSet excludedRoots = new HashSet();
        roots.forEach(root -> this.collectExcludedRoots((VirtualFile)root, excludedRoots));
        return this.createLibrary(Set.copyOf(roots), (Set<VirtualFile>)directRoots, (Set<VirtualFile>)tsOnlyRoots, Set.copyOf(excludedRoots), typingsModules, startNano);
    }

    @NotNull
    private SyntheticLibrary createLibrary(@NotNull Set<VirtualFile> allSourceRootSet, @NotNull Set<VirtualFile> directRoots, @NotNull Set<VirtualFile> tsOnlyRoots, @NotNull Set<VirtualFile> excludedRoots, @NotNull List<VirtualFile> typingsModules, long startNano) {
        SyntheticLibrary library;
        if (allSourceRootSet == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(10);
        }
        if (directRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(11);
        }
        if (tsOnlyRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(12);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(13);
        }
        if (typingsModules == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(14);
        }
        Condition<VirtualFile> excludeCondition = this.getExcludeConditionForNonTsSources(allSourceRootSet, directRoots, tsOnlyRoots, typingsModules);
        List<VirtualFile> allSourceRoots = List.copyOf(allSourceRootSet);
        boolean workspaceModel = NodeModulesDirectoryManager.shouldUseWorkspaceModel();
        int includedFileCount = -1;
        if (workspaceModel) {
            Pair<SyntheticLibrary, Integer> libraryAndCount = NodeModulesLibraryDirectory.createLibraryWithoutExcludeCondition(allSourceRoots, excludedRoots, excludeCondition);
            library = (SyntheticLibrary)libraryAndCount.first;
            includedFileCount = (Integer)libraryAndCount.second;
        } else {
            library = SyntheticLibrary.newImmutableLibrary(allSourceRoots, excludedRoots, excludeCondition);
        }
        NodeModulesStatKt.updateStat(this.myDirectoryManager, new NodeModulesLibraryStat(this.myNodeModulesDir, includedFileCount, allSourceRoots.size(), workspaceModel ? library.getSourceRoots().size() : -1, excludedRoots.size(), workspaceModel ? library.getExcludedRoots().size() : -1, System.nanoTime() - startNano));
        SyntheticLibrary syntheticLibrary = library;
        if (syntheticLibrary == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(15);
        }
        return syntheticLibrary;
    }

    @NotNull
    private static Pair<SyntheticLibrary, Integer> createLibraryWithoutExcludeCondition(@NotNull List<VirtualFile> sourceRoots, @NotNull Set<VirtualFile> excludedRoots, final @NotNull Condition<VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(16);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(17);
        }
        if (excludeCondition == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(18);
        }
        final HashSet<VirtualFile> updatedExcludedRoots = new HashSet<VirtualFile>(excludedRoots);
        final ArrayList addedSourceRoots = new ArrayList();
        final HashSet emptyFolders = new HashSet();
        final AtomicInteger includedFileCount = new AtomicInteger();
        for (final VirtualFile root : sourceRoots) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (updatedExcludedRoots.contains(file)) {
                        VirtualFileVisitor.Result result2 = VirtualFileVisitor.SKIP_CHILDREN;
                        if (result2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return result2;
                    }
                    if (excludeCondition.value((Object)file)) {
                        if (!updatedExcludedRoots.add(file)) {
                            LOG.error("Already excluded: " + file.getPath() + ", root: " + root.getPath());
                        }
                        VirtualFileVisitor.Result result3 = VirtualFileVisitor.SKIP_CHILDREN;
                        if (result3 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return result3;
                    }
                    if (!file.isDirectory()) {
                        includedFileCount.incrementAndGet();
                    }
                    VirtualFileVisitor.Result result4 = VirtualFileVisitor.CONTINUE;
                    if (result4 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return result4;
                }

                public void afterChildrenVisited(@NotNull VirtualFile parent) {
                    VirtualFile[] children;
                    if (parent == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if ((children = Objects.requireNonNullElse(parent.getChildren(), VirtualFile.EMPTY_ARRAY)).length == 0) {
                        if (parent.isDirectory()) {
                            emptyFolders.add(parent);
                        }
                        return;
                    }
                    List<VirtualFile> includedChildren = Arrays.stream(children).filter(child -> !updatedExcludedRoots.contains(child) && !emptyFolders.contains(child)).toList();
                    if (includedChildren.size() * 2 < children.length) {
                        updatedExcludedRoots.add(parent);
                        for (VirtualFile child2 : children) {
                            updatedExcludedRoots.remove(child2);
                        }
                        addedSourceRoots.addAll(includedChildren);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibraryDirectory$1";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "parent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibraryDirectory$1";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "afterChildrenVisited";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2, 3 -> new IllegalStateException(string);
                    };
                }
            });
        }
        Set newSourceRoots = ContainerUtil.union(sourceRoots, addedSourceRoots);
        if (newSourceRoots.size() != sourceRoots.size() + addedSourceRoots.size()) {
            LOG.error("Unexpected duplicated roots");
        }
        Pair pair = Pair.create((Object)SyntheticLibrary.newImmutableLibrary((List)ContainerUtil.filter((Collection)newSourceRoots, v -> !updatedExcludedRoots.contains(v)), Set.copyOf(updatedExcludedRoots), null), (Object)includedFileCount.get());
        if (pair == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(19);
        }
        return pair;
    }

    private List<VirtualFile> getTypingsModules() {
        VirtualFile types2 = NodeModulesLibraryDirectory.findChild(this.myNodeModulesDir, "@types", true);
        if (types2 == null) {
            return Collections.emptyList();
        }
        return ((StreamEx)StreamEx.of((Object[])types2.getChildren()).filter(VirtualFile::isValid)).toList();
    }

    @NotNull
    private Set<VirtualFile> getIndexableModuleRoots(@NotNull PackageJsonFiles packageJsonFiles, @NotNull List<VirtualFile> typingsModules) {
        if (packageJsonFiles == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(20);
        }
        if (typingsModules == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(21);
        }
        List indexableDependencies = ContainerUtil.filter(packageJsonFiles.getAllDependencies(), this::isDependencyIndexed);
        if (typingsModules.isEmpty()) {
            return this.toRootFiles(indexableDependencies);
        }
        Set typesDependencies = StreamEx.of(typingsModules).map(module -> this.getPackageJsonDataForDependency(NodeModulesLibraryDirectory.findPackageJsonForDependency(module))).nonNull().flatMap(data -> data.getAllDependencies().stream()).toSet();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        result2.addAll(this.toRootFiles(indexableDependencies));
        result2.addAll(this.toRootFiles(typesDependencies));
        result2.addAll(StreamEx.of(typingsModules).map(dep -> this.getDependencyToIndex((VirtualFile)dep)).nonNull().toList());
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    @NotNull
    private Set<VirtualFile> toRootFiles(@NotNull Collection<String> dependencies) {
        if (dependencies == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(23);
        }
        Set set = ((StreamEx)StreamEx.of(dependencies).map(this::getRootForDependency).nonNull().filter(el -> el.isValid() && el.isDirectory())).toSet();
        if (set == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(24);
        }
        return set;
    }

    @Nullable
    private VirtualFile getRootForDependency(@NotNull String dependency) {
        VirtualFile rootForDependency;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(25);
        }
        if ((rootForDependency = this.getRootForDependency(dependency, this.myNodeModulesDir)) != null) {
            return rootForDependency;
        }
        if (this.myWorkspaceRoot != null) {
            return this.myWorkspaceRoot.getNodeModulesDir().findFileByRelativePath(dependency);
        }
        return null;
    }

    @Nullable
    private VirtualFile getRootForDependency(@NotNull String dependency, @NotNull VirtualFile nodeModulesDir) {
        VirtualFile dir;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(26);
        }
        if (nodeModulesDir == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(27);
        }
        if ((dir = NodeModulesLibraryDirectory.findDescendantFileByRelativePath(nodeModulesDir, dependency)) != null && dir.isValid() && dir.isDirectory()) {
            return this.getDependencyToIndex(dir);
        }
        return null;
    }

    @Nullable
    private VirtualFile getDependencyToIndex(@NotNull VirtualFile dependencyRoot) {
        if (dependencyRoot == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(28);
        }
        if (!dependencyRoot.is(VFileProperty.SYMLINK)) {
            return dependencyRoot;
        }
        VirtualFile target = NodePackageLinkResolver.INSTANCE.resolve(dependencyRoot);
        if (NodeModuleSearchUtil.findAncestorNodeModulesDir(target) != null) {
            return target;
        }
        if (this.isUnderContentRoots(target)) {
            return null;
        }
        return target;
    }

    private boolean isUnderContentRoots(@NotNull VirtualFile file) {
        if (file == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(29);
        }
        if (NodeModulesDirectoryManager.shouldUseWorkspaceModel()) {
            return (Boolean)ReadAction.compute(() -> {
                if (this.myProject.isDisposed()) {
                    return false;
                }
                return this.myDirectoryManager.myFileIndex.getContentRootForFile(file, false) != null;
            });
        }
        return this.myDirectoryManager.isUnderContentRoots(file);
    }

    @Nullable
    private static VirtualFile findDescendantFileByRelativePath(@NotNull VirtualFile root, @NotNull String relPath) {
        if (root == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(30);
        }
        if (relPath == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(31);
        }
        int offset = 0;
        VirtualFile result2 = root;
        while (result2 != null && offset < relPath.length()) {
            String name;
            int separatorInd = relPath.indexOf(47, offset + 1);
            if (separatorInd < 0) {
                separatorInd = relPath.length();
            }
            result2 = (name = relPath.substring(offset, separatorInd)).equals(".") ? result2 : result2.findChild(name);
            offset = separatorInd + 1;
        }
        return root.equals(result2) ? null : result2;
    }

    @Nullable
    private static VirtualFile getParentNodeModules(@NotNull VirtualFile root) {
        VirtualFile parent;
        if (root == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(32);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(parent = root.getParent())) {
            return parent;
        }
        VirtualFile superParent = parent != null ? parent.getParent() : null;
        return NodeModulesDirectoryManager.isNodeModulesDir(superParent) ? superParent : null;
    }

    @NotNull
    private Pair<Set<VirtualFile>, Set<VirtualFile>> collectTsOnlyRoots(@NotNull Set<VirtualFile> indexableRoots) {
        if (indexableRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(33);
        }
        HashSet<VirtualFile> tsRoots = new HashSet<VirtualFile>();
        HashSet<VirtualFile> additionalRootsWithSources = new HashSet<VirtualFile>();
        HashSet<Pair> directDependencies = new HashSet<Pair>();
        HashSet<Pair> queuedDependencies = new HashSet<Pair>();
        for (VirtualFile virtualFile : indexableRoots) {
            List<String> additionalInclusions;
            String dependencyName;
            VirtualFile packageJson;
            PackageJsonData dependency2;
            if (NodeModuleUtil.isTypesDir(virtualFile) || (dependency2 = this.getPackageJsonDataForDependency(packageJson = NodeModulesLibraryDirectory.findPackageJsonForDependency(virtualFile))) == null || (dependencyName = NodeModulesLibraryDirectory.getPackageName(dependency2)) == null) continue;
            VirtualFile nodeModules = NodeModulesLibraryDirectory.getParentNodeModules(virtualFile);
            directDependencies.add(Pair.create((Object)dependencyName, (Object)nodeModules));
            if (dependency2.hasTypings()) {
                for (PackageJsonData.PackageJsonDependencyEntry dependencyEntry : dependency2.getAllDependencyEntries().values()) {
                    if (!NodeModulesLibraryDirectory.isIndexedIndirectDependencyType(dependencyEntry.getDependencyType())) continue;
                    queuedDependencies.add(Pair.create((Object)dependencyEntry.getName(), (Object)nodeModules));
                }
            }
            VirtualFile innerNodeModule = (additionalInclusions = this.myNodeModulesIndexingRulesProvider.getAdditionalInclusions(dependencyName)).isEmpty() ? null : NodeModuleUtil.findChildNodeModulesDir(virtualFile);
            for (String additionalDependency : additionalInclusions) {
                queuedDependencies.add(Pair.create((Object)additionalDependency, (Object)nodeModules));
                if (innerNodeModule == null) continue;
                queuedDependencies.add(Pair.create((Object)additionalDependency, (Object)innerNodeModule));
            }
            if (!TypeScriptExcludeUtil.arePackageSourcesExcluded(this.myProject, dependency2)) continue;
            tsRoots.add(virtualFile);
        }
        Stack stack = new Stack();
        for (Pair dependencyPair : queuedDependencies) {
            String dependency2 = (String)dependencyPair.getFirst();
            if (directDependencies.contains(dependencyPair) || this.myNodeModulesIndexingRulesProvider.isIndirectDependencyExcluded(dependency2)) continue;
            stack.add((Object)dependencyPair);
        }
        queuedDependencies.addAll(directDependencies);
        TypeScriptExcludeManager typeScriptExcludeManager = TypeScriptExcludeManager.getInstance(this.myProject);
        while (!stack.isEmpty()) {
            PackageJsonData dependencyPackageJsonData;
            String packageName;
            VirtualFile packageJson;
            Pair pair = (Pair)stack.pop();
            String dependencyName = (String)pair.getFirst();
            VirtualFile root = this.getDirectOrSymlinkedRoot(dependencyName, (VirtualFile)pair.getSecond());
            if (root == null || !root.isValid() || !root.isDirectory() || (packageJson = NodeModulesLibraryDirectory.findPackageJsonForDependency(root)) == null || (packageName = NodeModulesLibraryDirectory.getPackageName(dependencyPackageJsonData = this.getPackageJsonDataForDependency(packageJson))) == null) continue;
            VirtualFile nodeModules = NodeModulesLibraryDirectory.getParentNodeModules(root);
            this.myNodeModulesIndexingRulesProvider.getAdditionalInclusions(packageName).forEach(dependency -> {
                Pair nameWithNodeModules = Pair.create((Object)dependency, (Object)nodeModules);
                if (queuedDependencies.add(nameWithNodeModules)) {
                    stack.add((Object)nameWithNodeModules);
                }
            });
            if (!dependencyPackageJsonData.hasTypings()) continue;
            boolean includeSources = typeScriptExcludeManager.getIncludedJSSourcePackages().contains(packageName);
            (includeSources ? additionalRootsWithSources : tsRoots).add(root);
            for (PackageJsonData.PackageJsonDependencyEntry dependencyEntry : dependencyPackageJsonData.getAllDependencyEntries().values()) {
                if (!NodeModulesLibraryDirectory.isIndexedIndirectDependencyType(dependencyEntry.getDependencyType())) continue;
                Pair nameWithNodeModules = Pair.create((Object)dependencyEntry.getName(), (Object)nodeModules);
                if (this.myNodeModulesIndexingRulesProvider.isIndirectDependencyExcluded(dependencyEntry.getName()) || !queuedDependencies.add(nameWithNodeModules)) continue;
                stack.add((Object)nameWithNodeModules);
            }
        }
        Pair pair = Pair.create(tsRoots, additionalRootsWithSources);
        if (pair == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(34);
        }
        return pair;
    }

    private static boolean isIndexedIndirectDependencyType(@NotNull PackageJsonDependency dependencyType) {
        if (dependencyType == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(35);
        }
        return dependencyType == PackageJsonDependency.dependencies || dependencyType == PackageJsonDependency.peerDependencies || dependencyType == PackageJsonDependency.optionalDependencies;
    }

    @Nullable
    private VirtualFile getDirectOrSymlinkedRoot(@NotNull String dependencyName, @Nullable VirtualFile nodeModules) {
        VirtualFile root;
        if (dependencyName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(36);
        }
        if ((root = this.getRootForDependency(dependencyName)) == null || !root.isValid() || !root.isDirectory()) {
            if (nodeModules != null && !nodeModules.equals(this.myNodeModulesDir)) {
                return this.getRootForDependency(dependencyName, nodeModules);
            }
            return null;
        }
        return root;
    }

    @Nullable
    private static String getPackageName(@NotNull PackageJsonData packageJsonData) {
        String packageName;
        if (packageJsonData == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(37);
        }
        if ((packageName = packageJsonData.getName()) != null) {
            return packageName;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Name property missing in " + packageJsonData.getPackageJsonFile().getPath());
        }
        return null;
    }

    @NotNull
    private Condition<VirtualFile> getExcludeConditionForNonTsSources(@NotNull Set<VirtualFile> allRoots, @NotNull Set<VirtualFile> directRoots, @NotNull Set<VirtualFile> typingOnlyRoots, @NotNull List<VirtualFile> typingsModules) {
        if (allRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(38);
        }
        if (directRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(39);
        }
        if (typingOnlyRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(40);
        }
        if (typingsModules == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(41);
        }
        Set jsModulesWithTypings = ((StreamEx)StreamEx.of(typingsModules).map(module -> module.getName()).map(name -> ES6CreateImportUtil.convertScopedTypesName(name)).map(depName -> this.getRootForDependency((String)depName)).filter(Objects::nonNull)).toSet();
        Condition condition = file -> {
            if (file.isDirectory()) {
                return NodeModulesDirectoryManager.isNodeModulesDir(file);
            }
            VirtualFile parent = NodeModulesLibraryDirectory.findRoot(allRoots, file);
            if (parent == null) {
                return false;
            }
            if (typingOnlyRoots.contains(parent) || jsModulesWithTypings.contains(parent)) {
                return !NodeModulesIndexableFileNamesProvider.isIndexableFileName(file.getNameSequence(), directRoots.contains(parent) ? NodeModulesIndexableFileNamesProvider.DependencyKind.DIRECT_TYPINGS : NodeModulesIndexableFileNamesProvider.DependencyKind.INDIRECT_TYPINGS);
            }
            return !NodeModulesIndexableFileNamesProvider.isIndexableFileName(file.getNameSequence(), directRoots.contains(parent) ? NodeModulesIndexableFileNamesProvider.DependencyKind.DIRECT : NodeModulesIndexableFileNamesProvider.DependencyKind.INDIRECT);
        };
        if (condition == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(42);
        }
        return condition;
    }

    @Nullable
    private static VirtualFile findRoot(@NotNull Set<VirtualFile> allRoots, @NotNull VirtualFile file) {
        VirtualFile parent;
        if (allRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(43);
        }
        if (file == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(44);
        }
        for (parent = file.getParent(); parent != null && !allRoots.contains(parent); parent = parent.getParent()) {
        }
        return parent;
    }

    void addChildWorkspace(@NotNull VirtualFile childWorkspaceRoot) {
        if (childWorkspaceRoot == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(45);
        }
        this.myChildWorkspaceRoots.add(childWorkspaceRoot);
    }

    private void collectExcludedRoots(@NotNull VirtualFile dependency, @NotNull Set<? super VirtualFile> excludedRoots) {
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(46);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(47);
        }
        PackageJsonData dependencyPackageJsonData = this.getPackageJsonDataForDependency(NodeModulesLibraryDirectory.findPackageJsonForDependency(dependency));
        for (String name2 : BUILD_DIR_NAMES) {
            boolean shouldIndexDist;
            VirtualFile child = dependency.findChild(name2);
            if (child == null || !child.isDirectory() || (shouldIndexDist = dependencyPackageJsonData != null && (NodeModulesLibraryDirectory.isMainResolvedInsideFolder(dependencyPackageJsonData, name2) || dependencyPackageJsonData.hasTypings()))) continue;
            excludedRoots.add((VirtualFile)child);
        }
        ((StreamEx)StreamEx.of(this.myNodeModulesIndexingRulesProvider.getExcludedDirs(dependencyPackageJsonData == null ? null : dependencyPackageJsonData.getName())).map(name -> NodeModulesLibraryDirectory.findDescendantFileByRelativePath(dependency, name)).nonNull().filter(VirtualFile::isDirectory)).into(excludedRoots);
        if (dependencyPackageJsonData != null) {
            NodeModulesLibraryDirectory.collectExcludedAdditionalMainFiles(dependency, dependencyPackageJsonData, excludedRoots);
        }
    }

    private static boolean isMainResolvedInsideFolder(@NotNull PackageJsonData packageJsonData, @NotNull String folderName) {
        String jsNextMain;
        if (packageJsonData == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(48);
        }
        if (folderName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(49);
        }
        if ((jsNextMain = packageJsonData.getJsNextMain()) != null && NodeModulesLibraryDirectory.startsWithFolder(jsNextMain, folderName)) {
            return true;
        }
        String main = packageJsonData.getMain();
        return main != null && !main.equals(jsNextMain) && NodeModulesLibraryDirectory.startsWithFolder(main, folderName);
    }

    private static boolean startsWithFolder(@NotNull String path2, @NotNull String folderName) {
        if (path2 == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(50);
        }
        if (folderName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(51);
        }
        path2 = FileUtil.toSystemIndependentName((String)path2);
        int startInd = 0;
        if (path2.startsWith("./")) {
            startInd += 2;
        }
        if (StringUtil.startsWith((CharSequence)path2, (int)startInd, (CharSequence)folderName)) {
            if (folderName.length() + startInd == path2.length()) {
                return true;
            }
            return path2.charAt(startInd + folderName.length()) == '/';
        }
        return false;
    }

    @Contract(value="!null -> !null; null -> null")
    private PackageJsonData getPackageJsonDataForDependency(@Nullable VirtualFile dependencyPackageJson) {
        if (dependencyPackageJson == null) {
            return null;
        }
        return PackageJsonData.getOrCreateWithPreferredProject(this.myProject, dependencyPackageJson);
    }

    @Nullable
    private static VirtualFile findPackageJsonForDependency(@NotNull VirtualFile dependency) {
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(52);
        }
        return PackageJsonUtil.findChildPackageJsonFile(dependency);
    }

    private static void collectExcludedAdditionalMainFiles(@NotNull VirtualFile dependency, @NotNull PackageJsonData dependencyPackageJsonData, @NotNull Set<? super VirtualFile> excludedRoots) {
        Collection<String> additionalMainPaths;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(53);
        }
        if (dependencyPackageJsonData == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(54);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(55);
        }
        if ((additionalMainPaths = dependencyPackageJsonData.getAdditionalMains()).isEmpty()) {
            return;
        }
        String preferableMainFile = dependencyPackageJsonData.getJsNextMain();
        if (preferableMainFile == null) {
            preferableMainFile = dependencyPackageJsonData.getMain();
        }
        if (preferableMainFile == null) {
            return;
        }
        VirtualFile defaultFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, preferableMainFile);
        if (defaultFile == null) {
            return;
        }
        ArrayList<String> modules = new ArrayList<String>(additionalMainPaths.size() + 1);
        String main = dependencyPackageJsonData.getMain();
        if (main != null) {
            modules.add(main);
        }
        modules.addAll(additionalMainPaths);
        for (String mainToExclude : modules) {
            VirtualFile candidateFile;
            if (preferableMainFile.equals(mainToExclude) || StringUtil.isEmptyOrSpaces((String)mainToExclude) || (candidateFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, mainToExclude)) == null || defaultFile.equals(candidateFile) || candidateFile.isDirectory()) continue;
            excludedRoots.add((VirtualFile)candidateFile);
        }
    }

    private boolean isDependencyIndexed(@NotNull String dependencyName) {
        if (dependencyName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(56);
        }
        return this.myNodeModulesIndexingRulesProvider.isDependencyIndexed(dependencyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8, 9, 15, 19, 22, 24, 34, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryManager";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibraryDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSourceRootSet";
                break;
            }
            case 11: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directRoots";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsOnlyRoots";
                break;
            }
            case 13: 
            case 17: 
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 14: 
            case 21: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingsModules";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeCondition";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 25: 
            case 26: 
            case 46: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyRoot";
                break;
            }
            case 29: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexableRoots";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyType";
                break;
            }
            case 36: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 37: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonData";
                break;
            }
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingOnlyRoots";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childWorkspaceRoot";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyPackageJsonData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibraryDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getThisAndDescendants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateLibrary";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryWithoutExcludeCondition";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableModuleRoots";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toRootFiles";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTsOnlyRoots";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeConditionForNonTsSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 34: 
            case 42: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDescendant";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryWithoutExcludeCondition";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableModuleRoots";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toRootFiles";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRootForDependency";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyToIndex";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isUnderContentRoots";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findDescendantFileByRelativePath";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getParentNodeModules";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectTsOnlyRoots";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isIndexedIndirectDependencyType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDirectOrSymlinkedRoot";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeConditionForNonTsSources";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addChildWorkspace";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "collectExcludedRoots";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isMainResolvedInsideFolder";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "startsWithFolder";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findPackageJsonForDependency";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "collectExcludedAdditionalMainFiles";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyIndexed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8, 9, 15, 19, 22, 24, 34, 42 -> new IllegalStateException(string);
        };
    }

    private static final class PackageJsonFiles {
        private final List<Pair<VirtualFile, PackageJsonData>> myList;

        private PackageJsonFiles(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull List<VirtualFile> childWorkspaceRoots) {
            if (project == null) {
                PackageJsonFiles.$$$reportNull$$$0(0);
            }
            if (packageJson == null) {
                PackageJsonFiles.$$$reportNull$$$0(1);
            }
            if (childWorkspaceRoots == null) {
                PackageJsonFiles.$$$reportNull$$$0(2);
            }
            ArrayList<VirtualFile> packageJsonFiles = new ArrayList<VirtualFile>(1 + childWorkspaceRoots.size());
            packageJsonFiles.add(packageJson);
            for (VirtualFile workspaceRoot : childWorkspaceRoots) {
                if (!workspaceRoot.isValid()) continue;
                ContainerUtil.addIfNotNull(packageJsonFiles, (Object)PackageJsonUtil.findChildPackageJsonFile(workspaceRoot));
            }
            this.myList = ContainerUtil.map(packageJsonFiles, file -> {
                try (AccessToken ignored = ProjectLocator.withPreferredProject((VirtualFile)file, (Project)project);){
                    Pair pair = new Pair(file, (Object)PackageJsonData.getOrCreate(file));
                    return pair;
                }
            });
        }

        @NotNull
        public Set<String> getAllDependencies() {
            if (this.myList.size() == 1) {
                Set<String> set = ((PackageJsonData)this.myList.get((int)0).second).getAllDependencies();
                if (set == null) {
                    PackageJsonFiles.$$$reportNull$$$0(3);
                }
                return set;
            }
            HashSet<String> dependencies = new HashSet<String>();
            for (Pair<VirtualFile, PackageJsonData> pair : this.myList) {
                dependencies.addAll(((PackageJsonData)pair.second).getAllDependencies());
            }
            HashSet<String> hashSet = dependencies;
            if (hashSet == null) {
                PackageJsonFiles.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childWorkspaceRoots";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibraryDirectory$PackageJsonFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibraryDirectory$PackageJsonFiles";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

