/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesLibraryDirectory;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NodeModulesLibrariesSnapshot {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibrariesSnapshot.class);
    private final List<NodeModulesLibraryDirectory> myLibraryDirs;
    private final Map<VirtualFile, NodeModulesLibraryDirectory> myMap;

    NodeModulesLibrariesSnapshot(@NotNull NodeModulesDirectoryManager directoryManager, @NotNull Set<VirtualFile> nodeModulesDirs, @NotNull Set<VirtualFile> packageJsonFiles) {
        if (directoryManager == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(0);
        }
        if (nodeModulesDirs == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(1);
        }
        if (packageJsonFiles == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(2);
        }
        ArrayList workspaces = new ArrayList(nodeModulesDirs.size());
        Project project = directoryManager.getProject();
        ReadAction.run(() -> {
            VirtualFile rootDir;
            NotNullLazyValue contentRoots = NotNullLazyValue.createValue(() -> ContainerUtil.newHashSet((Object[])ProjectRootManager.getInstance((Project)project).getContentRoots()));
            HashMap<VirtualFile, Workspace> workspaceMap = new HashMap<VirtualFile, Workspace>(nodeModulesDirs.size());
            for (VirtualFile nodeModulesDir : nodeModulesDirs) {
                rootDir = nodeModulesDir.getParent();
                if (nodeModulesDir.isValid() && rootDir != null) {
                    String name = NodeModulesLibrariesSnapshot.buildLibraryName(project, nodeModulesDir, (NotNullLazyValue<Set<VirtualFile>>)contentRoots);
                    NodeModulesLibraryDirectory libraryDir = new NodeModulesLibraryDirectory(directoryManager, nodeModulesDir, name);
                    Workspace workspace = new Workspace(project, rootDir, libraryDir);
                    workspaces.add(workspace);
                    workspaceMap.put(workspace.myRoot, workspace);
                    continue;
                }
                LOG.warn("Filtering out invalid library node_modules: " + nodeModulesDir.getPath());
            }
            for (VirtualFile packageJson : packageJsonFiles) {
                if (!packageJson.isValid() || (rootDir = packageJson.getParent()) == null || workspaceMap.containsKey(rootDir)) continue;
                workspaces.add(new Workspace(project, rootDir, null));
            }
            Collections.sort(workspaces);
            for (int i = 0; i < workspaces.size(); ++i) {
                Workspace child;
                Workspace root = (Workspace)workspaces.get(i);
                if (root.myDirectory == null) continue;
                for (int j = i + 1; j < workspaces.size() && root.isAncestorOf(child = (Workspace)workspaces.get(j)); ++j) {
                    if (child.myDirectory != null) {
                        root.myDirectory.addDescendant(child.myDirectory);
                    }
                    if (!root.matchesChildWorkspace(child)) continue;
                    if (child.myDirectory != null) {
                        child.myDirectory.setWorkspaceRoot(root.myDirectory);
                        continue;
                    }
                    root.myDirectory.addChildWorkspace(child.myRoot);
                }
            }
        });
        this.myLibraryDirs = workspaces.stream().map(workspace -> workspace.myDirectory).filter(Objects::nonNull).collect(Collectors.toList());
        this.myMap = ContainerUtil.newMapFromValues(this.myLibraryDirs.iterator(), dir -> dir.getNodeModulesDir());
    }

    @NotNull
    public List<NodeModulesLibraryDirectory> getLibraryDirs() {
        List<NodeModulesLibraryDirectory> list2 = this.myLibraryDirs;
        if (list2 == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    public String findLibraryName(@NotNull VirtualFile nodeModulesDir) {
        NodeModulesLibraryDirectory directory;
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(4);
        }
        return (directory = this.myMap.get(nodeModulesDir)) != null ? directory.getLibraryName() : null;
    }

    @Nullable
    public NodeModulesLibraryDirectory findLibraryDir(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(5);
        }
        return this.myMap.get(nodeModulesDir);
    }

    public void onPackageJsonFileChanged(@NotNull VirtualFile packageJson) {
        NodeModulesLibraryDirectory d;
        NodeModulesLibraryDirectory directory;
        VirtualFile nodeModulesDir;
        if (packageJson == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(6);
        }
        if ((nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson)) != null && (directory = this.myMap.get(nodeModulesDir)) != null) {
            directory.invalidateRoots();
        }
        if ((d = this.findNodeModulesDirectoryByTopLevelDependentFile(packageJson)) != null) {
            d.invalidateRoots();
        }
    }

    @Nullable
    NodeModulesLibraryDirectory findNodeModulesDirectoryByTopLevelDependentFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        for (int steps = 3; steps > 0 && dir != null; dir = dir.getParent(), --steps) {
            NodeModulesLibraryDirectory directory = this.myMap.get(dir);
            if (directory == null) continue;
            return directory;
        }
        return null;
    }

    @NotNull
    private static String buildLibraryName(@NotNull Project project, @NotNull VirtualFile nodeModulesDir, @NotNull NotNullLazyValue<Set<VirtualFile>> contentRoots) {
        String relativePath;
        VirtualFile baseDir;
        if (project == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(8);
        }
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(9);
        }
        if (contentRoots == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(10);
        }
        if ((baseDir = project.getBaseDir()) != null && (relativePath = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, baseDir, false)) != null) {
            String string = relativePath;
            if (string == null) {
                NodeModulesLibrariesSnapshot.$$$reportNull$$$0(11);
            }
            return string;
        }
        VirtualFile contentRoot = NodeModulesLibrariesSnapshot.findContentRoot(nodeModulesDir, (Set)contentRoots.getValue());
        if (contentRoot != null) {
            String relativePath2 = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, contentRoot, false);
            if (relativePath2 != null) {
                String string = relativePath2;
                if (string == null) {
                    NodeModulesLibrariesSnapshot.$$$reportNull$$$0(12);
                }
                return string;
            }
            LOG.error("Failed to buildRelativeName(" + nodeModulesDir.getPath() + ", " + contentRoot.getPath() + ")");
        }
        LOG.warn("Cannot generate library name for " + nodeModulesDir.getPath());
        String path2 = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, nodeModulesDir, true);
        if (path2 != null) {
            String string = path2;
            if (string == null) {
                NodeModulesLibrariesSnapshot.$$$reportNull$$$0(13);
            }
            return string;
        }
        LOG.error("Failed to build relative name to itself: " + nodeModulesDir.getPath());
        return "unknown_node_modules";
    }

    @Nullable
    private static String buildRelativeName(@NotNull VirtualFile nodeModulesDir, @NotNull VirtualFile root, boolean prependEllipses) {
        String relativePath;
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(14);
        }
        if (root == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(15);
        }
        if (nodeModulesDir.equals(root)) {
            VirtualFile parentRoot = root.getParent();
            if (parentRoot == null) {
                return nodeModulesDir.getPath();
            }
            root = parentRoot;
        }
        if ((relativePath = VfsUtilCore.getRelativePath((VirtualFile)nodeModulesDir, (VirtualFile)root, (char)'/')) != null) {
            StringBuilder pathBuilder = new StringBuilder(root.getNameSequence());
            pathBuilder.append('/').append(relativePath);
            if (prependEllipses) {
                pathBuilder.insert(0, ".../");
            }
            return pathBuilder.toString();
        }
        return null;
    }

    @Nullable
    private static VirtualFile findContentRoot(@NotNull VirtualFile file, @NotNull Set<VirtualFile> contentRoots) {
        VirtualFile f;
        if (file == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(16);
        }
        if (contentRoots == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(17);
        }
        for (f = file; f != null && !contentRoots.contains(f); f = f.getParent()) {
        }
        return f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibrariesSnapshot";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoots";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibrariesSnapshot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryDirs";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryDir";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonFileChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findNodeModulesDirectoryByTopLevelDependentFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildLibraryName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildRelativeName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findContentRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    private static class Workspace
    implements Comparable<Workspace> {
        @Nullable
        private final NodeModulesLibraryDirectory myDirectory;
        private final VirtualFile myRoot;
        private final String myRootPath;
        private final Project myProject;
        @Nullable
        private List<PathMatcher> myWorkspaceMatchers;

        Workspace(@NotNull Project project, @NotNull VirtualFile root, @Nullable NodeModulesLibraryDirectory directory) {
            if (project == null) {
                Workspace.$$$reportNull$$$0(0);
            }
            if (root == null) {
                Workspace.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myRoot = root;
            this.myRootPath = this.myRoot.getPath();
            this.myDirectory = directory;
        }

        @NotNull
        private List<PathMatcher> getWorkspaceMatchers() {
            List workspaceMatchers = this.myWorkspaceMatchers;
            if (workspaceMatchers == null) {
                PackageJsonData data = this.getPackageJsonData();
                List<Object> workspaces = data != null ? data.getWorkspaces() : Collections.emptyList();
                this.myWorkspaceMatchers = workspaceMatchers = ContainerUtil.map(workspaces, workspace -> FileSystems.getDefault().getPathMatcher("glob:" + StringUtil.trimStart((String)workspace, (String)"./")));
            }
            List list2 = workspaceMatchers;
            if (list2 == null) {
                Workspace.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Nullable
        private PackageJsonData getPackageJsonData() {
            VirtualFile packageJson;
            VirtualFile virtualFile = packageJson = this.myRoot != null ? PackageJsonUtil.findChildPackageJsonFile(this.myRoot) : null;
            if (packageJson == null) {
                return null;
            }
            return PackageJsonData.getOrCreateWithPreferredProject(this.myProject, packageJson);
        }

        private boolean isAncestorOf(@NotNull Workspace child) {
            if (child == null) {
                Workspace.$$$reportNull$$$0(3);
            }
            return child.myRootPath.startsWith(this.myRootPath) && child.myRootPath.length() > this.myRootPath.length() && child.myRootPath.charAt(this.myRootPath.length()) == '/';
        }

        private boolean matchesChildWorkspace(@NotNull Workspace child) {
            List<PathMatcher> matchers;
            if (child == null) {
                Workspace.$$$reportNull$$$0(4);
            }
            if ((matchers = this.getWorkspaceMatchers()).isEmpty()) {
                return false;
            }
            String relativePath = child.myRootPath.substring(this.myRootPath.length() + 1);
            Path path2 = Paths.get(relativePath, new String[0]);
            for (PathMatcher matcher : matchers) {
                if (!matcher.matches(path2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(@NotNull Workspace w) {
            if (w == null) {
                Workspace.$$$reportNull$$$0(5);
            }
            return this.myRootPath.compareTo(w.myRootPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibrariesSnapshot$Workspace";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "w";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/node_modules/NodeModulesLibrariesSnapshot$Workspace";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWorkspaceMatchers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAncestorOf";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "matchesChildWorkspace";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

