/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesFileListener;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.TreeNodeProcessingResult;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J,\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f0\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesEarlyVfsEventProcessor;", "", "project", "Lcom/intellij/openapi/project/Project;", "nodeModulesDirectoryManager", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager;", "packageJsonFileManager", "Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileManager;", "listener", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesFileListener;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager;Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileManager;Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesFileListener;)V", "parentFilePointerDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "dispose", "", "dispose$intellij_javascript_impl", "process", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "processWhenAvailable", "parent", "Lcom/intellij/openapi/vfs/VirtualFile;", "newChildName", "", "processor", "Lkotlin/Function1;", "traverseDirectory", "dir", "intellij.javascript.impl"})
public final class NodeModulesEarlyVfsEventProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final NodeModulesDirectoryManager nodeModulesDirectoryManager;
    @NotNull
    private final PackageJsonFileManager packageJsonFileManager;
    @NotNull
    private final NodeModulesFileListener listener;
    @NotNull
    private Disposable parentFilePointerDisposable;

    public NodeModulesEarlyVfsEventProcessor(@NotNull Project project, @NotNull NodeModulesDirectoryManager nodeModulesDirectoryManager, @NotNull PackageJsonFileManager packageJsonFileManager, @NotNull NodeModulesFileListener listener2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)nodeModulesDirectoryManager, (String)"nodeModulesDirectoryManager");
        Intrinsics.checkNotNullParameter((Object)packageJsonFileManager, (String)"packageJsonFileManager");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.project = project;
        this.nodeModulesDirectoryManager = nodeModulesDirectoryManager;
        this.packageJsonFileManager = packageJsonFileManager;
        this.listener = listener2;
        Disposable disposable = Disposer.newDisposable((Disposable)this.nodeModulesDirectoryManager, (String)"node_modules file pointers");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.parentFilePointerDisposable = disposable;
    }

    public final void process(@NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof VFileCreateEvent && ((VFileCreateEvent)event).isDirectory()) {
            VirtualFile virtualFile = ((VFileCreateEvent)event).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            String string = ((VFileCreateEvent)event).getChildName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChildName(...)");
            this.processWhenAvailable(virtualFile, string, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this){
                final /* synthetic */ NodeModulesEarlyVfsEventProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    NodeModulesEarlyVfsEventProcessor.access$traverseDirectory(this.this$0, it);
                }
            }));
        } else if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getFile().isDirectory()) {
            String newName;
            VirtualFile parent = ((VFilePropertyChangeEvent)event).getFile().getParent();
            Object object = ((VFilePropertyChangeEvent)event).getNewValue();
            String string = newName = object instanceof String ? (String)object : null;
            if (parent != null && newName != null) {
                this.processWhenAvailable(parent, newName, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this){
                    final /* synthetic */ NodeModulesEarlyVfsEventProcessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull VirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        NodeModulesEarlyVfsEventProcessor.access$getListener$p(this.this$0).afterEarlyRenameEvent$intellij_javascript_impl(it);
                    }
                }));
            }
        } else if (event instanceof VFileMoveEvent && ((VFileMoveEvent)event).getFile().isDirectory()) {
            VirtualFile virtualFile = ((VFileMoveEvent)event).getNewParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getNewParent(...)");
            String string = ((VFileMoveEvent)event).getFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.processWhenAvailable(virtualFile, string, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this){
                final /* synthetic */ NodeModulesEarlyVfsEventProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    NodeModulesEarlyVfsEventProcessor.access$getListener$p(this.this$0).afterEarlyMoveEvent$intellij_javascript_impl(it);
                }
            }));
        }
    }

    private final void processWhenAvailable(VirtualFile parent, String newChildName, Function1<? super VirtualFile, Unit> processor) {
        Disposable disposable = Disposer.newDisposable((Disposable)this.parentFilePointerDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        String url = parent.getUrl() + "/" + newChildName;
        if (NodeModulesDirectoryManager.LOG.isDebugEnabled()) {
            NodeModulesDirectoryManager.LOG.debug("Watching " + url);
        }
        VirtualFilePointerManager.getInstance().create(url, disposable2, new VirtualFilePointerListener(parent, disposable2, url, newChildName, processor){
            final /* synthetic */ VirtualFile $parent;
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ String $url;
            final /* synthetic */ String $newChildName;
            final /* synthetic */ Function1<VirtualFile, Unit> $processor;
            {
                this.$parent = $parent;
                this.$disposable = $disposable;
                this.$url = $url;
                this.$newChildName = $newChildName;
                this.$processor = $processor;
            }

            public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
                Intrinsics.checkNotNullParameter((Object)pointers, (String)"pointers");
                if (!this.$parent.isValid()) {
                    Disposer.dispose((Disposable)this.$disposable);
                    if (NodeModulesDirectoryManager.LOG.isDebugEnabled()) {
                        NodeModulesDirectoryManager.LOG.debug("parent of " + this.$url + " became invalid, file pointer has been removed");
                    }
                    return;
                }
                VirtualFile file = this.$parent.findChild(this.$newChildName);
                if (NodeModulesDirectoryManager.LOG.isDebugEnabled()) {
                    NodeModulesDirectoryManager.LOG.debug("validityChanged for " + this.$url + ": " + (file != null));
                }
                if (file != null) {
                    Disposer.dispose((Disposable)this.$disposable);
                    this.$processor.invoke((Object)file);
                }
            }
        });
    }

    private final void traverseDirectory(VirtualFile dir) {
        if (!dir.isDirectory()) {
            return;
        }
        ProjectFileIndex projectFileIndex = (ProjectFileIndex)ReadAction.compute(() -> NodeModulesEarlyVfsEventProcessor.traverseDirectory$lambda$0(this));
        if (projectFileIndex == null) {
            return;
        }
        ProjectFileIndex fileIndex = projectFileIndex;
        List foundNodeModules = new ArrayList();
        fileIndex.iterateContentUnderDirectory(dir, (ContentIterator)((ContentIteratorEx)arg_0 -> NodeModulesEarlyVfsEventProcessor.traverseDirectory$lambda$1(this, foundNodeModules, arg_0)));
        this.nodeModulesDirectoryManager.addNodeModulesDirs(foundNodeModules);
    }

    public final void dispose$intellij_javascript_impl() {
        Disposer.dispose((Disposable)this.parentFilePointerDisposable);
    }

    private static final ProjectFileIndex traverseDirectory$lambda$0(NodeModulesEarlyVfsEventProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.project.isDisposed() ? null : ProjectFileIndex.getInstance((Project)this$0.project);
    }

    private static final TreeNodeProcessingResult traverseDirectory$lambda$1(NodeModulesEarlyVfsEventProcessor this$0, List $foundNodeModules, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$foundNodeModules, (String)"$foundNodeModules");
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        if (!fileOrDir.isValid()) {
            return TreeNodeProcessingResult.SKIP_CHILDREN;
        }
        if (PackageJsonUtil.isPackageJsonFile(fileOrDir)) {
            this$0.packageJsonFileManager.onPackageJsonAdded(fileOrDir);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(fileOrDir)) {
            $foundNodeModules.add(fileOrDir);
            return TreeNodeProcessingResult.SKIP_CHILDREN;
        }
        return TreeNodeProcessingResult.CONTINUE;
    }

    public static final /* synthetic */ void access$traverseDirectory(NodeModulesEarlyVfsEventProcessor $this, VirtualFile dir) {
        $this.traverseDirectory(dir);
    }

    public static final /* synthetic */ NodeModulesFileListener access$getListener$p(NodeModulesEarlyVfsEventProcessor $this) {
        return $this.listener;
    }
}

