/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeTypingsDownloadSession {
    private static final String NODE_TYPINGS_PACKAGE = "@types/node";

    @NotNull
    public static CompletableFuture<SemVer> start(@NotNull SemVer nodeVersion, @NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (nodeVersion == null) {
            NodeTypingsDownloadSession.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NodeTypingsDownloadSession.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            NodeTypingsDownloadSession.$$$reportNull$$$0(2);
        }
        CompletableFuture<SemVer> completableFuture = CompletableFuture.supplyAsync(() -> {
            SemVer typingsVersion = NodeTypingsDownloadSession.findTypingsVersion(nodeVersion);
            TypeScriptExternalDefinitionsRegistry definitionsRegistry = TypeScriptExternalDefinitionsRegistry.getInstance();
            SensitiveProgressWrapper installProgress = new SensitiveProgressWrapper(indicator);
            Future<VirtualFile> future = definitionsRegistry.installPackage(new TypeScriptPackageName(NODE_TYPINGS_PACKAGE, typingsVersion), project, (ProgressIndicator)installProgress);
            try {
                future.get(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", NODE_TYPINGS_PACKAGE), e);
            }
            catch (TimeoutException e) {
                installProgress.cancel();
                throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", NODE_TYPINGS_PACKAGE), e);
            }
            return typingsVersion;
        }, AppExecutorUtil.getAppExecutorService());
        if (completableFuture == null) {
            NodeTypingsDownloadSession.$$$reportNull$$$0(3);
        }
        return completableFuture;
    }

    @NotNull
    private static SemVer findTypingsVersion(@NotNull SemVer nodeVersion) {
        SemVer typingsVersion;
        if (nodeVersion == null) {
            NodeTypingsDownloadSession.$$$reportNull$$$0(4);
        }
        if ((typingsVersion = TypeScriptExternalDefinitionsRegistry.getInstance().findMatchedTypingsVersion(nodeVersion, NODE_TYPINGS_PACKAGE)) == null) {
            throw new RuntimeException("No @types/node versions available");
        }
        SemVer semVer = typingsVersion;
        if (semVer == null) {
            NodeTypingsDownloadSession.$$$reportNull$$$0(5);
        }
        return semVer;
    }

    @Nullable
    public static VirtualFile findNodeTypingsPackageDir(@NotNull NodeCoreLibraryConfigurator.NodeLibraryVersion version2) {
        VirtualFile typingsVirtualDir;
        String typingsPath;
        if (version2 == null) {
            NodeTypingsDownloadSession.$$$reportNull$$$0(6);
        }
        if ((typingsPath = NodeTypingsDownloadSession.getNodeTypingsPackageDirPath(version2)) != null && (typingsVirtualDir = LocalFileSystem.getInstance().findFileByIoFile(new File(typingsPath))) != null && typingsVirtualDir.isDirectory() && typingsVirtualDir.isValid()) {
            return typingsVirtualDir;
        }
        return null;
    }

    public static boolean isReconfigurationNeeded(@NotNull NodeCoreLibraryConfigurator.NodeLibraryVersion version2) {
        String typingsPath;
        if (version2 == null) {
            NodeTypingsDownloadSession.$$$reportNull$$$0(7);
        }
        return (typingsPath = NodeTypingsDownloadSession.getNodeTypingsPackageDirPath(version2)) == null || !new File(typingsPath).isDirectory();
    }

    @Nullable
    private static String getNodeTypingsPackageDirPath(@NotNull NodeCoreLibraryConfigurator.NodeLibraryVersion version2) {
        SemVer typingsVersion;
        if (version2 == null) {
            NodeTypingsDownloadSession.$$$reportNull$$$0(8);
        }
        if ((typingsVersion = version2.getNodeTypingsVersion()) != null) {
            TypeScriptPackageName typingsPackage = new TypeScriptPackageName(NODE_TYPINGS_PACKAGE, typingsVersion);
            return TypeScriptExternalDefinitionsRegistry.getExactModuleTypingsPath(typingsPackage);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeVersion";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeTypingsDownloadSession";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeTypingsDownloadSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findTypingsVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTypingsVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNodeTypingsPackageDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReconfigurationNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodeTypingsPackageDirPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

