/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryUtil;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesSnapshot;
import com.intellij.javascript.nodejs.library.core.NodeTypingsDownloadSession;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreSyntheticLibraryProvider
extends AdditionalLibraryRootsProvider {
    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(0);
        }
        SyntheticLibrary library = NodeCoreSyntheticLibraryProvider.getSyntheticLibrary(project);
        List list2 = ContainerUtil.createMaybeSingletonList((Object)library);
        if (list2 == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    public static SyntheticLibrary getSyntheticLibrary(@NotNull Project project) {
        if (project == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List<VirtualFile> coreModuleFiles = NodeCoreLibraryConfigurator.getInstance((Project)project).myTestCoreModuleFiles;
            if (coreModuleFiles == null) {
                return null;
            }
            return SyntheticLibrary.newImmutableLibrary(coreModuleFiles);
        }
        NodeCoreLibraryConfigurator.NodeLibraryVersion version2 = NodeCoreLibraryConfigurator.getConfiguredCoreLibraryVersion(project);
        if (version2 == null) {
            return null;
        }
        NodeCoreLibraryManager coreLibraryManager = NodeCoreLibraryManager.getInstance(project);
        NodeCoreSourcesSnapshot snapshot = coreLibraryManager.getSnapshot();
        if (snapshot == null) {
            return null;
        }
        if (!coreLibraryManager.hasAssociatedRoots()) {
            return null;
        }
        Set<VirtualFile> excluded = NodeCoreSyntheticLibraryProvider.getExcludedSources(snapshot);
        ArrayList<VirtualFile> sourceRoots = new ArrayList<VirtualFile>(NodeCoreSyntheticLibraryProvider.getPredefinedNodeLibraryFiles(version2));
        ContainerUtil.addAllNotNull(sourceRoots, (Object[])new VirtualFile[]{snapshot.getCoreModulesSrcDir()});
        SyntheticLibrary library = SyntheticLibrary.newImmutableLibrary(sourceRoots, excluded, null);
        return new NodeCoreSyntheticLibrary(project, version2.getNodeVersion().getRawVersion(), library);
    }

    @NotNull
    private static List<VirtualFile> getPredefinedNodeLibraryFiles(@NotNull NodeCoreLibraryConfigurator.NodeLibraryVersion version2) {
        VirtualFile typesNodePackageDir;
        if (version2 == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(3);
        }
        if (NodeCoreLibraryManager.shouldUseNodeTypings() && (typesNodePackageDir = NodeTypingsDownloadSession.findNodeTypingsPackageDir(version2)) != null) {
            List<VirtualFile> list2 = Collections.singletonList(typesNodePackageDir.getParent());
            if (list2 == null) {
                NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(4);
            }
            return list2;
        }
        return new ArrayList<VirtualFile>(NodeCoreLibraryUtil.getNodeGlobalStubFiles());
    }

    @NotNull
    private static Set<VirtualFile> getExcludedSources(@NotNull NodeCoreSourcesSnapshot snapshot) {
        VirtualFile coreModulesSrcDir;
        if (snapshot == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(5);
        }
        if (!(coreModulesSrcDir = snapshot.getCoreModulesSrcDir()).isValid()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(6);
            }
            return set;
        }
        HashSet excluded = ContainerUtil.newHashSet((Object[])VfsUtil.getChildren((VirtualFile)coreModulesSrcDir));
        Set<VirtualFile> filesToIndex = snapshot.getFilesToIndex();
        excluded.removeAll(filesToIndex);
        HashSet hashSet = excluded;
        if (hashSet == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectLibraries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedNodeLibraryFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectLibraries";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedNodeLibraryFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedSources";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class NodeCoreSyntheticLibrary
    extends SyntheticLibrary
    implements ItemPresentation,
    NavigatableWithText {
        private final Project myProject;
        private final String myVersion;
        private final SyntheticLibrary myDelegate;

        NodeCoreSyntheticLibrary(@NotNull Project project, @NotNull String version2, @NotNull SyntheticLibrary delegate) {
            if (project == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(0);
            }
            if (version2 == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(1);
            }
            if (delegate == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(2);
            }
            super("NodeCoreSyntheticLibrary", null);
            this.myProject = project;
            this.myVersion = version2;
            this.myDelegate = delegate;
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            Collection collection = this.myDelegate.getSourceRoots();
            if (collection == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @NotNull
        public Collection<VirtualFile> getBinaryRoots() {
            Collection collection = this.myDelegate.getBinaryRoots();
            if (collection == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @NotNull
        public Set<VirtualFile> getExcludedRoots() {
            Set set = this.myDelegate.getExcludedRoots();
            if (set == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(5);
            }
            return set;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            return this.myDelegate.equals((Object)((NodeCoreSyntheticLibrary)((Object)o)).myDelegate);
        }

        public int hashCode() {
            return this.myDelegate.hashCode();
        }

        @Nullable
        public String getPresentableText() {
            return "Node.js Core";
        }

        @Nullable
        public String getLocationString() {
            return this.myVersion;
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return JavaScriptLanguageIcons.Nodejs.Nodejs;
        }

        public void navigate(boolean requestFocus) {
            NodeSettingsConfigurable.showSettingsDialog(this.myProject);
        }

        public boolean canNavigate() {
            return true;
        }

        @Nullable
        public String getNavigateActionText(boolean focusEditor) {
            return JavaScriptBundle.message("node.core.navigate_action_text.text", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider$NodeCoreSyntheticLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider$NodeCoreSyntheticLibrary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceRoots";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinaryRoots";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExcludedRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

