/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.remote;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeBaseRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeJsRemoteInterpreterType
extends NodeJsInterpreterType<NodeJsRemoteInterpreter> {
    private static final NodeJsRemoteInterpreterType INSTANCE = new NodeJsRemoteInterpreterType();
    static final String DOCKER_COMPOSE_PREFIX = "docker-compose://";
    static final String DOCKER_PREFIX = "docker://";
    static final String VAGRANT_PREFIX = "vagrant://";
    static final String SFTP_PREFIX = "sftp://";
    static final String SSH_PREFIX = "ssh://";
    static final String DBST_PREFIX = "dbst://";

    @NotNull
    public static NodeJsRemoteInterpreterType getInstance() {
        NodeJsRemoteInterpreterType nodeJsRemoteInterpreterType = INSTANCE;
        if (nodeJsRemoteInterpreterType == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(0);
        }
        return nodeJsRemoteInterpreterType;
    }

    @Nullable
    private static NodeBaseRemoteInterpreterManager getManager() {
        return NodeBaseRemoteInterpreterManager.getInstanceBase();
    }

    @Override
    @NotNull
    public String getName() {
        return "remote";
    }

    @Override
    public boolean isAvailable() {
        return NodeJsRemoteInterpreterType.getManager() != null;
    }

    public boolean isRemoteReference(@NotNull NodeJsInterpreterRef ref) {
        if (ref == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(1);
        }
        return NodeJsRemoteInterpreterType.isKnownRemoteReferenceName(ref.getReferenceName());
    }

    private static boolean isKnownRemoteReferenceName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(2);
        }
        return referenceName.startsWith(VAGRANT_PREFIX) || referenceName.startsWith(SFTP_PREFIX) || referenceName.startsWith(SSH_PREFIX) || referenceName.startsWith(DOCKER_PREFIX) || referenceName.startsWith(DOCKER_COMPOSE_PREFIX) || referenceName.startsWith("sshConfig://") || referenceName.startsWith(DBST_PREFIX);
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter findByReferenceName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(3);
        }
        return NodeJsRemoteInterpreterType.isKnownRemoteReferenceName(referenceName) ? new NodeJsRemoteInterpreter(referenceName) : null;
    }

    @Override
    @NotNull
    public List<NodeJsRemoteInterpreter> getInterpreters() {
        NodeBaseRemoteInterpreterManager manager = NodeJsRemoteInterpreterType.getManager();
        if (manager != null) {
            List<NodeJsRemoteInterpreter> list2 = manager.getRemoteInterpreters();
            if (list2 == null) {
                NodeJsRemoteInterpreterType.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<NodeJsRemoteInterpreter> list3 = Collections.emptyList();
        if (list3 == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter showAddDialog(@NotNull Project project) {
        String id;
        NodeBaseRemoteInterpreterManager manager;
        if (project == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(6);
        }
        if ((manager = NodeJsRemoteInterpreterType.getManager()) != null && (id = manager.createRemoteInterpreter(project)) != null) {
            return new NodeJsRemoteInterpreter(id);
        }
        return null;
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter edit(@NotNull Project project, @NotNull NodeJsRemoteInterpreter interpreter) {
        NodeBaseRemoteInterpreterManager manager;
        if (project == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(7);
        }
        if (interpreter == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(8);
        }
        if ((manager = NodeJsRemoteInterpreterType.getManager()) != null) {
            return manager.editRemoteInterpreter(project, interpreter);
        }
        return null;
    }

    @Override
    public void setInterpreters(@NotNull List<NodeJsRemoteInterpreter> interpreters) {
        NodeBaseRemoteInterpreterManager manager;
        if (interpreters == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(9);
        }
        if ((manager = NodeJsRemoteInterpreterType.getManager()) != null) {
            HashSet<NodeJsRemoteInterpreter> toDelete = new HashSet<NodeJsRemoteInterpreter>(manager.getRemoteInterpreters());
            for (NodeJsRemoteInterpreter interpreter : interpreters) {
                toDelete.remove(interpreter);
            }
            for (NodeJsRemoteInterpreter interpreter : toDelete) {
                manager.deleteRemoteInterpreter(interpreter);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isKnownRemoteReferenceName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findByReferenceName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showAddDialog";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

