/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.NodeTargetRunSetup;
import com.intellij.javascript.nodejs.interpreter.remote.NodeBaseRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsRemoteInterpreter
extends NodeJsInterpreter {
    @NlsSafe
    private final String myRemoteUrl;

    public NodeJsRemoteInterpreter(@NotNull @NlsSafe String remoteUrl) {
        if (remoteUrl == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(0);
        }
        this.myRemoteUrl = remoteUrl;
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String string = this.myRemoteUrl;
        if (string == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getRemoteUrl() {
        String string = this.myRemoteUrl;
        if (string == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myRemoteUrl;
        if (string == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        NodeBaseRemoteInterpreterManager remoteInterpreterManager = NodeBaseRemoteInterpreterManager.getInstanceBase();
        if (remoteInterpreterManager != null) {
            SemVer version2 = remoteInterpreterManager.getNodeVersionCached(this);
            return Ref.create((Object)version2);
        }
        return null;
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<? super SemVer> consumer) {
        if (consumer == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> consumer.consume(null));
    }

    @Override
    @Nullable
    public String validate(@Nullable Project project) {
        NodeBaseRemoteInterpreterManager manager = NodeBaseRemoteInterpreterManager.getInstanceBase();
        if (manager == null) {
            return NodeBaseRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage();
        }
        return null;
    }

    @Override
    @NotNull
    public NodeJsInterpreterType<? extends NodeJsInterpreter> getType() {
        NodeJsRemoteInterpreterType nodeJsRemoteInterpreterType = NodeJsRemoteInterpreterType.getInstance();
        if (nodeJsRemoteInterpreterType == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(5);
        }
        return nodeJsRemoteInterpreterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsRemoteInterpreter that = (NodeJsRemoteInterpreter)o;
        return this.myRemoteUrl.equals(that.myRemoteUrl);
    }

    public int hashCode() {
        return this.myRemoteUrl.hashCode();
    }

    public String toString() {
        return this.myRemoteUrl;
    }

    @Nullable
    public static NodeJsRemoteInterpreter tryCast(@Nullable NodeJsInterpreter interpreter) {
        return (NodeJsRemoteInterpreter)ObjectUtils.tryCast((Object)interpreter, NodeJsRemoteInterpreter.class);
    }

    public static boolean isDockerCompose(@Nullable NodeJsInterpreter interpreter) {
        return NodeJsRemoteInterpreter.isRemoteInterpreterStartsWith(interpreter, "docker-compose://");
    }

    public static boolean isVagrant(@Nullable NodeJsInterpreter interpreter) {
        return NodeJsRemoteInterpreter.isRemoteInterpreterStartsWith(interpreter, "vagrant://");
    }

    public static boolean isDocker(@Nullable NodeJsInterpreter interpreter) {
        return NodeJsRemoteInterpreter.isRemoteInterpreterStartsWith(interpreter, "docker://");
    }

    public static boolean isSsh(@Nullable NodeJsInterpreter interpreter) {
        return NodeJsRemoteInterpreter.isRemoteInterpreterStartsWith(interpreter, "ssh://") || NodeJsRemoteInterpreter.isRemoteInterpreterStartsWith(interpreter, "sftp://") || NodeJsRemoteInterpreter.isRemoteInterpreterStartsWith(interpreter, "sshConfig://");
    }

    private static boolean isRemoteInterpreterStartsWith(@Nullable NodeJsInterpreter interpreter, @NotNull String prefix) {
        if (prefix == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(6);
        }
        return interpreter instanceof NodeJsRemoteInterpreter && ((NodeJsRemoteInterpreter)interpreter).getRemoteUrl().startsWith(prefix);
    }

    @Override
    @NotNull
    public NodeTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeTargetRunOptions options) throws ExecutionException {
        NodeBaseRemoteInterpreterManager remoteManager;
        if (project == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(7);
        }
        if (options == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(8);
        }
        if ((remoteManager = NodeBaseRemoteInterpreterManager.getInstanceBase()) == null) {
            throw new ExecutionException(NodeBaseRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage());
        }
        NodeTargetRunSetup nodeTargetRunSetup = remoteManager.createTargetRunSetup(project, this, options);
        if (nodeTargetRunSetup == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(9);
        }
        return nodeTargetRunSetup;
    }

    @Override
    @NotNull
    public TargetEnvironmentType<?> getTargetEnvironmentType() throws IllegalStateException {
        NodeBaseRemoteInterpreterManager remoteManager = NodeBaseRemoteInterpreterManager.getInstanceBase();
        if (remoteManager == null) {
            throw new IllegalStateException(NodeBaseRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage());
        }
        TargetEnvironmentType<?> targetEnvironmentType = remoteManager.getTargetEnvironmentType(this);
        if (targetEnvironmentType == null) {
            NodeJsRemoteInterpreter.$$$reportNull$$$0(10);
        }
        return targetEnvironmentType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetRunSetup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetEnvironmentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteInterpreterStartsWith";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRunSetup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 9, 10 -> new IllegalStateException(string);
        };
    }
}

