/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.download;

import com.intellij.codeWithMe.ClientId;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.system.CpuArch;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService;", "", "()V", "installExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "ensureInstalled", "", "project", "Lcom/intellij/openapi/project/Project;", "node", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "runWhenInstalled", "Ljava/util/function/Consumer;", "Companion", "Handler", "intellij.javascript.impl"})
public final class NodeJsDownloadService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService installExecutor;

    public NodeJsDownloadService() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"NodeJsInstaller", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.installExecutor = executorService;
    }

    public final void ensureInstalled(@Nullable Project project, @NotNull NodeJsInterpreter node, @NotNull Consumer<NodeJsInterpreter> runWhenInstalled) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(runWhenInstalled, (String)"runWhenInstalled");
        if (node instanceof NodeJsDownloadableInterpreter) {
            this.installExecutor.execute(() -> NodeJsDownloadService.ensureInstalled$lambda$0(project, node, runWhenInstalled));
        } else {
            runWhenInstalled.accept(node);
        }
    }

    private static final void ensureInstalled$lambda$0(Project $project, NodeJsInterpreter $node, Consumer $runWhenInstalled) {
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)$runWhenInstalled, (String)"$runWhenInstalled");
        Handler.INSTANCE.installWithProgress$intellij_javascript_impl($project, (NodeJsDownloadableInterpreter)$node, $runWhenInstalled);
    }

    @NotNull
    public static final NodeJsDownloadService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Companion;", "", "()V", "instance", "Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService;", "getInstance$annotations", "getInstance", "()Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nNodeJsDownloadService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeJsDownloadService.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,111:1\n42#2,3:112\n*S KotlinDebug\n*F\n+ 1 NodeJsDownloadService.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Companion\n*L\n43#1:112,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeJsDownloadService getInstance() {
            boolean $i$f$service = false;
            Class<NodeJsDownloadService> serviceClass$iv = NodeJsDownloadService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (NodeJsDownloadService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nH\u0007J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0007J-\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0000\u00a2\u0006\u0002\b\u0019R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Handler;", "", "()V", "installDirectory", "", "getInstallDirectory$annotations", "getInstallDirectory", "()Ljava/lang/String;", "constructFilename", "node", "Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadableInterpreter;", "constructUrl", "version", "Lcom/intellij/util/text/SemVer;", "filename", "getNpmInstallDirectory", "interpreter", "install", "", "runWhenInstalled", "Ljava/util/function/Consumer;", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "installWithProgress", "project", "Lcom/intellij/openapi/project/Project;", "installWithProgress$intellij_javascript_impl", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nNodeJsDownloadService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeJsDownloadService.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n11#2:112\n11#2:113\n*S KotlinDebug\n*F\n+ 1 NodeJsDownloadService.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Handler\n*L\n58#1:112\n81#1:113\n*E\n"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        public final void installWithProgress$intellij_javascript_impl(@Nullable Project project, @NotNull NodeJsDownloadableInterpreter node, @NotNull Consumer<NodeJsInterpreter> runWhenInstalled) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(runWhenInstalled, (String)"runWhenInstalled");
            Object[] objectArray = new Object[]{node};
            String string = JavaScriptBundle.message("node.js.downloading", objectArray);
            objectArray = Task.Backgroundable.ALWAYS_BACKGROUND;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, node, runWhenInstalled, string, (PerformInBackgroundOption)objectArray){
                final /* synthetic */ NodeJsDownloadableInterpreter $node;
                final /* synthetic */ Consumer<NodeJsInterpreter> $runWhenInstalled;
                {
                    this.$node = $node;
                    this.$runWhenInstalled = $runWhenInstalled;
                    super($project, $super_call_param$1, true, $super_call_param$2);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Handler.install(this.$node, this.$runWhenInstalled);
                }
            });
        }

        @JvmStatic
        public static final void install(@NotNull NodeJsDownloadableInterpreter node, @Nullable Consumer<NodeJsInterpreter> runWhenInstalled) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            try {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(NodeJsDownloadService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Installing Node.js " + node.getCachedVersion().get());
                String installDirectory = INSTANCE.getInstallDirectory(node);
                if (!FileUtil.exists((String)installDirectory)) {
                    String filename = INSTANCE.constructFilename(node);
                    Object object = node.getCachedVersion().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    String url = INSTANCE.constructUrl((SemVer)object, filename);
                    File file = FileUtil.createTempFile((String)"", (String)"", (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
                    File tempFile = file;
                    DownloadUtil.downloadAtomically((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (String)url, (File)tempFile);
                    Decompressor decompressor = SystemInfo.isWindows ? (Decompressor)new Decompressor.Zip(tempFile) : (Decompressor)new Decompressor.Tar(tempFile);
                    decompressor.extract(new File(Handler.getInstallDirectory()));
                }
                NodeJsLocalInterpreter interpreter = new NodeJsLocalInterpreter(installDirectory + (!SystemInfo.isWindows ? "/bin" : "") + "/node" + (SystemInfo.isWindows ? ".exe" : ""));
                NodeJsLocalInterpreterType nodeJsLocalInterpreterType = NodeJsLocalInterpreterType.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)nodeJsLocalInterpreterType, (String)"getInstance(...)");
                NodeJsLocalInterpreterType type2 = nodeJsLocalInterpreterType;
                List interpreters = new ArrayList(type2.getInterpreters());
                if (!interpreters.contains(interpreter)) {
                    interpreters.add(interpreter);
                    type2.setInterpreters(interpreters);
                }
                if (runWhenInstalled != null) {
                    ApplicationManager.getApplication().invokeLater(() -> Handler.install$lambda$0(runWhenInstalled, interpreter));
                }
            }
            catch (IOException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(NodeJsDownloadService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot install Node.js interpreter: " + e.getMessage(), (Throwable)e);
            }
        }

        private final String constructFilename(NodeJsDownloadableInterpreter node) {
            Ref<SemVer> ref = node.getCachedVersion();
            SemVer version2 = (SemVer)ref.get();
            String os = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "darwin" : "linux");
            String arch = CpuArch.isIntel32() ? "x86" : "x64";
            return "node-v" + version2 + "-" + os + "-" + arch;
        }

        private final String getInstallDirectory(NodeJsDownloadableInterpreter node) {
            return Handler.getInstallDirectory() + this.constructFilename(node);
        }

        @NotNull
        public static final String getInstallDirectory() {
            return PathManager.getConfigPath() + "/node/";
        }

        @JvmStatic
        public static /* synthetic */ void getInstallDirectory$annotations() {
        }

        @JvmStatic
        @NotNull
        public static final String getNpmInstallDirectory(@NotNull NodeJsDownloadableInterpreter interpreter) {
            Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
            return INSTANCE.getInstallDirectory(interpreter) + (SystemInfo.isWindows ? "" : "/lib") + "/node_modules/npm/";
        }

        private final String constructUrl(SemVer version2, String filename) {
            String extension = SystemInfo.isWindows ? "zip" : "tar.gz";
            return "https://nodejs.org/dist/v" + version2 + "/" + filename + "." + extension;
        }

        private static final void install$lambda$0(Consumer $runWhenInstalled, NodeJsLocalInterpreter $interpreter) {
            Intrinsics.checkNotNullParameter((Object)$interpreter, (String)"$interpreter");
            $runWhenInstalled.accept($interpreter);
        }
    }
}

