/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeLocalCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class NodeCommandLineConfigurator {
    private static final Key<Boolean> EXE_PATH_SET = Key.create((String)"exe path set");

    public abstract void configure(@NotNull GeneralCommandLine var1) throws ExecutionException;

    public void configure(@NotNull GeneralCommandLine commandLine, @NotNull Options options) throws ExecutionException {
        NodePackage yarnPkg;
        NpmManager npmManager;
        if (commandLine == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(0);
        }
        if (options == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(1);
        }
        if (!YarnPnpNodePackage.isWithYarnRun(commandLine) && options.shouldWrapWithYarnNodeCommand() && NpmUtil.isYarnAlikePackageRef((npmManager = NpmManager.getInstance(options.myProject)).getPackageRef()) && (yarnPkg = npmManager.getPackage(this.getInterpreter())) != null) {
            commandLine.getParametersList().addAt(0, NpmUtil.getValidNpmCliJsFilePath(yarnPkg, this.getInterpreter()));
            commandLine.getParametersList().addAt(1, "node");
            NodeCommandLineUtil.prependNodeDirToPATH(commandLine, this.getInterpreter());
        }
        this.configure(commandLine);
    }

    public abstract String convertLocalPathToRemote(@NotNull String var1);

    @NotNull
    protected abstract NodeJsInterpreter getInterpreter();

    @NotNull
    public static NodeCommandLineConfigurator find(@NotNull NodeJsInterpreterRef interpreterRef, @NotNull Project project) throws ExecutionException {
        NodeJsInterpreter interpreter;
        if (interpreterRef == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(2);
        }
        if (project == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(3);
        }
        if ((interpreter = interpreterRef.resolve(project)) == null) {
            throw new ExecutionException(JavaScriptBundle.message("node.interpreter.unresolved_reference.error.message", interpreterRef.getReferenceName()));
        }
        return NodeCommandLineConfigurator.find(interpreter);
    }

    @NotNull
    public static NodeCommandLineConfigurator find(@NotNull NodeJsInterpreter interpreter) throws ExecutionException {
        if (interpreter == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(4);
        }
        if (interpreter instanceof NodeJsLocalInterpreter) {
            NodeJsLocalInterpreter localInterpreter = (NodeJsLocalInterpreter)interpreter;
            if (!localInterpreter.isValid()) {
                throw new ExecutionException(JavaScriptBundle.message("node.interpreter.invalid_interpreter.error.message", localInterpreter.getInterpreterSystemDependentPath()));
            }
            return new NodeLocalCommandLineConfigurator(localInterpreter);
        }
        if (interpreter instanceof WslNodeInterpreter) {
            return new WslCommandLineConfigurator((WslNodeInterpreter)interpreter);
        }
        throw new ExecutionException(JavaScriptBundle.message("node.interpreter.no_local_interpreter.error.message", new Object[0]));
    }

    @NotNull
    public static Options defaultOptions(@NotNull Project project) {
        if (project == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(5);
        }
        return new Options(project);
    }

    @NotNull
    public static Options emptyOptions(@NotNull Project project) {
        if (project == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(6);
        }
        return new Options(project){

            @Override
            protected boolean shouldWrapWithYarnNodeCommand() {
                return false;
            }
        };
    }

    public static void markExePathAsSet(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(7);
        }
        commandLine.putUserData(EXE_PATH_SET, (Object)Boolean.TRUE);
    }

    public static boolean isExePathSet(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineConfigurator.$$$reportNull$$$0(8);
        }
        return Boolean.TRUE.equals(commandLine.getUserData(EXE_PATH_SET));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configure";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "defaultOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "emptyOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "markExePathAsSet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isExePathSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Options {
        private final Project myProject;
        private final List<YarnPnpNodePackage> myRequiredNodePackages;

        private Options(@NotNull Project project) {
            if (project == null) {
                Options.$$$reportNull$$$0(0);
            }
            this.myRequiredNodePackages = new ArrayList<YarnPnpNodePackage>();
            this.myProject = project;
        }

        protected boolean shouldWrapWithYarnNodeCommand() throws ExecutionException {
            if (this.myRequiredNodePackages.isEmpty() && YarnPnpManager.getInstance(this.myProject).getPnpFiles().isEmpty()) {
                return false;
            }
            NodePackageRef projectNpmPackageRef = NpmManager.getInstance(this.myProject).getPackageRef();
            boolean yarn = NpmUtil.isYarnAlikePackageRef(projectNpmPackageRef);
            YarnPnpNodePackage yarnPnpNodePackage = (YarnPnpNodePackage)ContainerUtil.getFirstItem(this.myRequiredNodePackages);
            if (yarnPnpNodePackage != null) {
                yarnPnpNodePackage.requireYarnPackageManager(this.myProject, yarn, false);
            }
            return yarn;
        }

        @NotNull
        public Options withRequiredNodePackage(@NotNull NodePackage requiredNodePackage) {
            if (requiredNodePackage == null) {
                Options.$$$reportNull$$$0(1);
            }
            if (requiredNodePackage instanceof YarnPnpNodePackage) {
                this.myRequiredNodePackages.add((YarnPnpNodePackage)requiredNodePackage);
            }
            Options options = this;
            if (options == null) {
                Options.$$$reportNull$$$0(2);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requiredNodePackage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator$Options";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator$Options";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRequiredNodePackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withRequiredNodePackage";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

