/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NodeLocalFileTransfer
implements NodeFileTransfer {
    public static final NodeLocalFileTransfer INSTANCE = new NodeLocalFileTransfer();

    @Override
    public List<String> listDirectoryContents(@NotNull String remoteWorkingDir) throws IOException {
        String[] list2;
        if (remoteWorkingDir == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(0);
        }
        if ((list2 = new File(remoteWorkingDir).list()) == null) {
            throw new IOException("Wrong local directory: " + remoteWorkingDir);
        }
        return Arrays.asList(list2);
    }

    @Override
    public void copy(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        File[] files;
        File ioTargetDir;
        File ioSourceDir;
        if (sourceDir == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(1);
        }
        if (names == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(2);
        }
        if (targetDir == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(3);
        }
        if (FileUtil.filesEqual((File)(ioSourceDir = new File(sourceDir)), (File)(ioTargetDir = new File(targetDir)))) {
            return;
        }
        for (File file : files = ioSourceDir.listFiles()) {
            if (!names.contains(file.getName())) continue;
            FileUtil.copy((File)file, (File)new File(ioTargetDir, file.getName()));
        }
    }

    @Override
    public void fetch(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(4);
        }
        if (names == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(5);
        }
        if (targetDir == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(6);
        }
        this.copy(sourceDir, names, targetDir);
    }

    @Override
    public void fetch(@NotNull String sourcePath, @NotNull String targetPath) throws IOException {
        if (sourcePath == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(7);
        }
        if (targetPath == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(8);
        }
        FileUtil.copy((File)new File(sourcePath), (File)new File(targetPath));
    }

    @Override
    public String copyToRemoteTmpFile(@NotNull String remoteDir, String localFileName, String content) throws IOException {
        if (remoteDir == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(9);
        }
        File created = FileUtil.createTempFile((File)new File(remoteDir), (String)localFileName, null, (boolean)true);
        FileUtil.writeToFile((File)created, (String)content);
        return created.getAbsolutePath();
    }

    @Override
    public String getPathForTempFile(@NotNull String remoteDir, String localFileName) throws IOException {
        if (remoteDir == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(10);
        }
        return FileUtil.createTempFile((File)new File(remoteDir), (String)localFileName, null, (boolean)false).getAbsolutePath();
    }

    @Override
    public void grouped(@NotNull String title, @NotNull ThrowableConsumer<NodeFileTransfer, IOException> consumer) throws IOException {
        if (title == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(12);
        }
        consumer.consume((Object)this);
    }

    @Override
    public void deleteRemote(@NotNull String path2) throws IOException {
        if (path2 == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(13);
        }
        FileUtil.delete((File)new File(path2));
    }

    @Override
    public void delete(@NotNull String dir, @NotNull HashSet<String> set) throws IOException {
        if (dir == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(14);
        }
        if (set == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(15);
        }
        for (String name : set) {
            FileUtil.delete((File)new File(dir, name));
        }
    }

    @Override
    public boolean mkDir(@NotNull String remoteDir, String name) throws IOException {
        if (remoteDir == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(16);
        }
        return FileUtil.createDirectory((File)new File(remoteDir, name));
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean hasInternalMapping() {
        return false;
    }

    @Override
    public String getMappingFor(@NotNull String localPath) throws ExecutionException {
        if (localPath == null) {
            NodeLocalFileTransfer.$$$reportNull$$$0(17);
        }
        return localPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteWorkingDir";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDir";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/NodeLocalFileTransfer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "listDirectoryContents";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "copy";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fetch";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToRemoteTmpFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathForTempFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "grouped";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRemote";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "delete";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "mkDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getMappingFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

