/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.jest.JestPackageProvider;
import com.intellij.javascript.jest.JestPkgInfo;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testing.JSTestRunnerUtil;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.json.JsonFileType;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JestUtil {
    private static final Logger LOG = Logger.getInstance(JestUtil.class);
    public static final String JEST_PACKAGE_NAME = "jest";
    public static final String PACKAGE_JSON_TOP_LEVEL_KEY = "jest";
    public static final String VUE_CLI_SERVICE = "@vue/cli-service";
    public static final String ANGULAR_CLI = "@angular/cli";
    static final String JEST_CLI_PACKAGE_NAME = "jest-cli";
    public static final NodePackageDescriptor PKG_DESCRIPTOR = JestUtil.createDescriptor();
    private static final String TEST_PROTOCOL_PREFIX = "test://";
    private static final String TAG__CONFIG_FILE = "config-file";
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    private static final String TAG__NODE_OPTIONS = "node-options";
    private static final String TAG__JEST_PACKAGE = "jest-package";
    private static final String KEY__JEST_PACKAGE_DIR = "nodejs.jest.jest_package";
    private static final String TAG__WORKING_DIR = "working-dir";
    private static final String TAG__JEST_OPTIONS = "jest-options";
    public static final String CONFIG_PREFIX = "jest.config";
    private static final List<String> EXTENSIONS = List.of(".js", ".ts", ".mjs", ".cjs", ".json");
    static final List<String> DEFAULT_CONFIG_FILE_NAMES = List.copyOf(ContainerUtil.map(EXTENSIONS, ext -> CONFIG_PREFIX + ext));

    private static NodePackageDescriptor createDescriptor() {
        List<JestPkgInfo> packages = JestPackageProvider.getAllJestPackageInfos();
        return new NodePackageDescriptor(ContainerUtil.mapNotNull(packages, pkg -> pkg.getPackageName().equals(ANGULAR_CLI) ? null : pkg.getPackageName()), ContainerUtil.map2MapNotNull(packages, info2 -> info2.getRequiredDependency() != null ? Pair.create((Object)info2.getPackageName(), (Object)info2.getRequiredDependency()) : null), JavaScriptBundle.message("jest.package.placeholder.text", new Object[0])){

            @Override
            @NotNull
            public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                List<NodePackage> packages = new NodePackageDescriptor(JestUtil.ANGULAR_CLI).listAvailable(project, interpreter, contextFileOrDirectory, directDependenciesInsideProject, true);
                ArrayList<NodePackage> result2 = new ArrayList<NodePackage>();
                for (NodePackage pkg : packages) {
                    Object path2 = pkg.getSystemIndependentPath();
                    path2 = StringUtil.trimEnd((String)path2, (String)JestUtil.ANGULAR_CLI) + "@angular-builders/jest";
                    if (LocalFileSystem.getInstance().findFileByPath((String)path2) == null) continue;
                    result2.add(pkg);
                }
                result2.addAll(super.listAvailable(project, interpreter, contextFileOrDirectory, directDependenciesInsideProject));
                ArrayList<NodePackage> arrayList = result2;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/jest/JestUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/jest/JestUtil$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listAvailable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "listAvailable";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private JestUtil() {
    }

    @NotNull
    public static JestRunSettings readXml(@NotNull Element element) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(0);
        }
        JestRunSettings.Builder builder2 = new JestRunSettings.Builder();
        builder2.setConfigFilePath(JestUtil.readValue(element, TAG__CONFIG_FILE));
        String interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__NODE_INTERPRETER);
        builder2.setInterpreterRef(NodeJsInterpreterRef.create(interpreterRefName));
        builder2.setNodeOptions(JestUtil.readValue(element, TAG__NODE_OPTIONS));
        String pkg = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__JEST_PACKAGE);
        if (pkg != null && !pkg.isEmpty()) {
            builder2.setJestPackage(PKG_DESCRIPTOR.createPackage(pkg));
        }
        builder2.setWorkingDir(JestUtil.readValue(element, TAG__WORKING_DIR));
        builder2.setJestOptions(JestUtil.readValue(element, TAG__JEST_OPTIONS));
        builder2.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        builder2.setScope(JsTestRunScope.readExternal(element));
        JestRunSettings jestRunSettings = builder2.build();
        if (jestRunSettings == null) {
            JestUtil.$$$reportNull$$$0(1);
        }
        return jestRunSettings;
    }

    @NotNull
    private static String readValue(@NotNull Element element, @NotNull String key2) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(2);
        }
        if (key2 == null) {
            JestUtil.$$$reportNull$$$0(3);
        }
        String string = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)key2));
        if (string == null) {
            JestUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void writeValue(@NotNull Element element, @NotNull String tagName, @Nullable String value) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(5);
        }
        if (tagName == null) {
            JestUtil.$$$reportNull$$$0(6);
        }
        if (value != null && !value.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)tagName, (String)value);
        }
    }

    public static void writeXml(@NotNull Element element, @NotNull JestRunSettings settings2) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(7);
        }
        if (settings2 == null) {
            JestUtil.$$$reportNull$$$0(8);
        }
        if (!StringUtil.isEmptyOrSpaces((String)settings2.getConfigFileSystemDependentPath())) {
            JestUtil.writeValue(element, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings2.getConfigFileSystemDependentPath()));
        }
        JestUtil.writeValue(element, TAG__NODE_INTERPRETER, settings2.getInterpreterRef().getReferenceName());
        JestUtil.writeValue(element, TAG__NODE_OPTIONS, settings2.getNodeOptions());
        if (settings2.getJestPackage() != null) {
            JestUtil.writeValue(element, TAG__JEST_PACKAGE, settings2.getJestPackage().getSystemIndependentPath());
        }
        JestUtil.writeValue(element, TAG__WORKING_DIR, settings2.getWorkingDirSystemIndependentPath());
        if (StringUtil.isNotEmpty((String)settings2.getJestOptions())) {
            JestUtil.writeValue(element, TAG__JEST_OPTIONS, settings2.getJestOptions());
        }
        settings2.getEnvData().writeExternal(element);
        settings2.getScope().writeExternal(element);
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(9);
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope2 = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (FileType type2 : new FileType[]{JsonFileType.INSTANCE, JavaScriptFileType.INSTANCE, TypeScriptFileType.INSTANCE, ES6FileType.INSTANCE}) {
            Collection files = FileTypeIndex.getFiles((FileType)type2, (GlobalSearchScope)scope2);
            for (VirtualFile file : files) {
                if (!file.isValid() || file.isDirectory() || !JestUtil.isJestConfigFile(file.getNameSequence()) || JSLibraryUtil.isProbableLibraryFile(file)) continue;
                result2.add(file);
            }
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            JestUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public static boolean isJestConfigFile(@NotNull CharSequence fileName) {
        String extension;
        if (fileName == null) {
            JestUtil.$$$reportNull$$$0(11);
        }
        if ((extension = (String)ContainerUtil.find(EXTENSIONS, ext -> StringUtil.endsWith((CharSequence)fileName, (CharSequence)ext))) != null) {
            String prefix = "jest";
            String suffix = "config";
            String delimiter = ".-_";
            if (fileName.length() >= prefix.length() + 1 + suffix.length() + extension.length() && Strings.startsWith((CharSequence)fileName, (int)0, (CharSequence)prefix) && Strings.startsWith((CharSequence)fileName, (int)(fileName.length() - suffix.length() - extension.length()), (CharSequence)suffix) && Strings.containsChar((String)delimiter, (char)fileName.charAt(prefix.length())) && Strings.containsChar((String)delimiter, (char)fileName.charAt(fileName.length() - suffix.length() - extension.length() - 1))) {
                return true;
            }
        }
        return StringUtil.equals((CharSequence)fileName, (CharSequence)CONFIG_PREFIX);
    }

    @NotNull
    public static NodePackage getJestPackage(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(12);
        }
        String packagePath = JestUtil.getPackagePath(project);
        NodePackage nodePackage = PKG_DESCRIPTOR.createPackage(StringUtil.notNullize((String)packagePath));
        if (nodePackage == null) {
            JestUtil.$$$reportNull$$$0(13);
        }
        return nodePackage;
    }

    public static void setJestPackage(@NotNull Project project, @NotNull NodePackage jestPackage) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(14);
        }
        if (jestPackage == null) {
            JestUtil.$$$reportNull$$$0(15);
        }
        JestUtil.setPackagePath(project, jestPackage.getSystemIndependentPath());
    }

    private static void setPackagePath(@NotNull Project project, @NotNull String value) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(16);
        }
        if (value == null) {
            JestUtil.$$$reportNull$$$0(17);
        }
        PropertiesComponent.getInstance((Project)project).setValue(KEY__JEST_PACKAGE_DIR, value);
    }

    @Nullable
    private static String getPackagePath(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(18);
        }
        return PropertiesComponent.getInstance((Project)project).getValue(KEY__JEST_PACKAGE_DIR);
    }

    @NotNull
    public static File getJestMainJsFile(@NotNull NodePackage pkg) throws ExecutionException {
        File bin;
        String pkgName;
        JestPkgInfo info2;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(19);
        }
        if ((info2 = JestPackageProvider.findJestPackageInfo(pkgName = pkg.getName())) != null && Files.isRegularFile((bin = new File(pkg.getSystemDependentPath(), info2.getBinFilePath())).toPath(), new LinkOption[0])) {
            File file = bin;
            if (file == null) {
                JestUtil.$$$reportNull$$$0(20);
            }
            return file;
        }
        String binaryName = PackageJsonUtil.guessDefaultBinaryNameOfDependency(pkg);
        File binFile = pkg.findBinFile(binaryName, null);
        if (binFile != null) {
            File file = binFile;
            if (file == null) {
                JestUtil.$$$reportNull$$$0(21);
            }
            return file;
        }
        throw new ExecutionException(JavaScriptBundle.message("jest.cannot.find.bin.file.for.package.dialog.message", pkgName));
    }

    public static void checkRunConfiguration(@NotNull JestRunConfiguration configuration) throws RuntimeConfigurationException {
        JestRunSettings settings2;
        if (configuration == null) {
            JestUtil.$$$reportNull$$$0(22);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(settings2 = configuration.getRunSettings()).getConfigFileSystemDependentPath())) {
            JestUtil.validatePath(false, "configuration file", settings2.getConfigFileSystemDependentPath());
        }
        JestUtil.validatePath(true, "working directory", settings2.getWorkingDirSystemDependentPath());
        NodeInterpreterUtil.checkForRunConfiguration(settings2.getInterpreterRef().resolve(configuration.getProject()));
        configuration.getJestPackage().validateForRunConfiguration("jest");
        JestUtil.validatePath(true, "working directory", settings2.getWorkingDirSystemDependentPath());
        JsTestRunScope scope2 = settings2.getScope();
        JsTestRunScopeKind scopeKind = scope2.getKind();
        if (scopeKind == JsTestRunScopeKind.TEST_FILE || scopeKind == JsTestRunScopeKind.SUITE || scopeKind == JsTestRunScopeKind.TEST) {
            String testFilePath = settings2.getTestFileSystemDependentPathAndExpandMacros();
            if (testFilePath.equals(settings2.getTestFileSystemDependentPath())) {
                JestUtil.validatePath(false, "test file", testFilePath);
            }
            if (scopeKind == JsTestRunScopeKind.SUITE && scope2.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.unspecified.suite.name", new Object[0]));
            }
            if (scopeKind == JsTestRunScopeKind.TEST && scope2.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.unspecified.test.name", new Object[0]));
            }
        }
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String pathLabelName, @Nullable String path2) throws RuntimeConfigurationException {
        boolean exists;
        if (pathLabelName == null) {
            JestUtil.$$$reportNull$$$0(23);
        }
        if (StringUtil.isEmptyOrSpaces((String)path2)) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.unspecified", pathLabelName));
        }
        File file = new File(path2);
        if (!file.isAbsolute()) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.no.such", pathLabelName));
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message("dialog.message.no.such", pathLabelName));
        }
    }

    public static boolean isReactScriptsFamilyPackage(@NotNull NodePackage pkg) {
        JestPkgInfo info2;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(24);
        }
        if ((info2 = JestPackageProvider.findJestPackageInfo(pkg.getName())) != null) {
            return info2.isReactScriptsFamily();
        }
        return new File(pkg.getSystemDependentPath(), "scripts/test.js").isFile();
    }

    public static void emitNewLineToFlushTrailingOutput(final @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            JestUtil.$$$reportNull$$$0(25);
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final String LINE = "Watch Usage: Press w to show more.";
            private Alarm myAlarm;
            private int myInd = 0;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (ProcessOutputType.isStdout((Key)outputType)) {
                    this.disposeAlarm();
                    String text2 = event.getText();
                    if (LINE.regionMatches(this.myInd, text2, 0, text2.length())) {
                        this.myInd += text2.length();
                        if (this.myInd == LINE.length()) {
                            Alarm alarm = new Alarm();
                            alarm.addRequest(() -> {
                                processHandler.notifyTextAvailable("\n", outputType);
                                this.disposeAlarm();
                            }, 100);
                            this.myAlarm = alarm;
                        }
                    } else {
                        this.myInd = 0;
                    }
                }
            }

            private void disposeAlarm() {
                if (this.myAlarm != null) {
                    Disposer.dispose((Disposable)this.myAlarm);
                    this.myAlarm = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/jest/JestUtil$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static String resolveFilePath(@NotNull String filePath) {
        String string;
        if (filePath == null) {
            JestUtil.$$$reportNull$$$0(26);
        }
        try {
            Path path2 = Paths.get(filePath, new String[0]);
            Path realPath = path2.toRealPath(new LinkOption[0]);
            string = realPath.toString();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            String string2 = filePath;
            if (string2 == null) {
                JestUtil.$$$reportNull$$$0(28);
            }
            return string2;
        }
        if (string == null) {
            JestUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String createTestPathPattern(@NotNull String testFilePath, boolean directory) {
        String endPattern;
        if (testFilePath == null) {
            JestUtil.$$$reportNull$$$0(29);
        }
        String string = endPattern = directory ? "" : "$";
        if (SystemInfo.isWindows) {
            String pattern = "^" + JSTestRunnerUtil.escapeJavaScriptRegexp(testFilePath.replace('\\', '\u0000')) + endPattern;
            String string2 = pattern.replace('\u0000', '.');
            if (string2 == null) {
                JestUtil.$$$reportNull$$$0(30);
            }
            return string2;
        }
        String string3 = "^" + JSTestRunnerUtil.escapeJavaScriptRegexp(testFilePath) + endPattern;
        if (string3 == null) {
            JestUtil.$$$reportNull$$$0(31);
        }
        return string3;
    }

    @Nullable
    public static List<String> getTestLocationPath(@NotNull AbstractTestProxy proxy) {
        String locationUrl;
        if (proxy == null) {
            JestUtil.$$$reportNull$$$0(32);
        }
        if ((locationUrl = proxy.getLocationUrl()) != null && locationUrl.startsWith(TEST_PROTOCOL_PREFIX)) {
            String locationPath = locationUrl.substring(TEST_PROTOCOL_PREFIX.length());
            return EscapeUtils.split(locationPath, '.');
        }
        return null;
    }

    @Nullable
    public static VirtualFile findContextFile(@NotNull JestRunSettings settings2) {
        VirtualFile f;
        if (settings2 == null) {
            JestUtil.$$$reportNull$$$0(33);
        }
        if ((f = JestUtil.findFile(settings2.getConfigFileSystemDependentPath())) != null) {
            return f;
        }
        JsTestRunScope scope2 = settings2.getScope();
        if (scope2.getKind() == JsTestRunScopeKind.TEST_FILE || scope2.getKind() == JsTestRunScopeKind.TEST || scope2.getKind() == JsTestRunScopeKind.SUITE) {
            return JestUtil.findFile(scope2.getTestFilePath());
        }
        if (scope2.getKind() == JsTestRunScopeKind.DIRECTORY) {
            return JestUtil.findFile(scope2.getTestDirectoryPath());
        }
        return JestUtil.findFile(settings2.getWorkingDirSystemDependentPath());
    }

    @Nullable
    private static VirtualFile findFile(@NotNull String path2) {
        if (path2 == null) {
            JestUtil.$$$reportNull$$$0(34);
        }
        return FileUtil.isAbsolute((String)path2) ? LocalFileSystem.getInstance().findFileByPath(path2) : null;
    }

    public static boolean isJestOrJestCliPackage(@NotNull String packageName) {
        if (packageName == null) {
            JestUtil.$$$reportNull$$$0(35);
        }
        return "jest".equals(packageName) || JEST_CLI_PACKAGE_NAME.equals(packageName);
    }

    public static void notify(@NotNull Project project, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType notificationType) {
        NotificationGroup jestNotificationGroup;
        if (project == null) {
            JestUtil.$$$reportNull$$$0(36);
        }
        if (title == null) {
            JestUtil.$$$reportNull$$$0(37);
        }
        if (content == null) {
            JestUtil.$$$reportNull$$$0(38);
        }
        if (notificationType == null) {
            JestUtil.$$$reportNull$$$0(39);
        }
        if ((jestNotificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Jest test runner")) == null) {
            LOG.error("Cannot find \"Jest test runner\" notification group");
            return;
        }
        jestNotificationGroup.createNotification(title, content, notificationType).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 10, 13, 20, 21, 27, 28, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 13: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 8: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestPackage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathLabelName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilePath";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readXml";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleConfigFilesInProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJestPackage";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getJestMainJsFile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFilePath";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestPathPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readXml";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 13: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeXml";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleConfigFilesInProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isJestConfigFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getJestPackage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setJestPackage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setPackagePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPackagePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getJestMainJsFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkRunConfiguration";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isReactScriptsFamilyPackage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "emitNewLineToFlushTrailingOutput";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveFilePath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createTestPathPattern";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocationPath";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findContextFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isJestOrJestCliPackage";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 10, 13, 20, 21, 27, 28, 30, 31 -> new IllegalStateException(string);
        };
    }
}

