/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.jest.JestConfigurationType;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunConfigurationProducer;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testing.JSTestRunnerManager;
import com.intellij.javascript.testing.JsPackageDependentTestRunConfigurationProducer;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003*+,B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0016\u0010\t\u001a\b\u0018\u00010\nR\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\b\u0018\u00010\nR\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001e\u0010\u0011\u001a\b\u0018\u00010\nR\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0014\u001a\b\u0018\u00010\nR\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0015\u001a\b\u0018\u00010\nR\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\"\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001bJ\u0018\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020&H\u0014J&\u0010'\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0)H\u0014\u00a8\u0006-"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationProducer;", "Lcom/intellij/javascript/testing/JsPackageDependentTestRunConfigurationProducer;", "Lcom/intellij/javascript/jest/JestRunConfiguration;", "()V", "areConfigFilesEffectivelySame", "", "generatedSettings", "Lcom/intellij/javascript/jest/JestRunSettings;", "existingSettings", "buildConfigSettings", "Lcom/intellij/javascript/jest/JestRunConfigurationProducer$ExtendedSettings;", "context", "Lcom/intellij/javascript/jest/JestRunConfigurationProducer$Context;", "buildContextSettings", "element", "Lcom/intellij/psi/PsiElement;", "templateRunSettings", "buildDirectorySettings", "psiDirectory", "Lcom/intellij/psi/PsiDirectory;", "buildSuiteOrTestSettings", "buildTestFileSettings", "findContextSuiteOrTestPath", "Lcom/intellij/javascript/testFramework/JsTestElementPath;", "fixWorkingDir", "settings", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getContainingJsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "guessWorkingDir", "contextFile", "isConfigurationFromCompatibleContext", "configuration", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromCompatibleContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Companion", "Context", "ExtendedSettings", "intellij.javascript.impl"})
public class JestRunConfigurationProducer
extends JsPackageDependentTestRunConfigurationProducer<JestRunConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public JestRunConfigurationProducer() {
        super(JestUtil.PKG_DESCRIPTOR, (List<String>)CollectionsKt.emptyList());
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        JestConfigurationType jestConfigurationType = JestConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jestConfigurationType), (String)"getInstance(...)");
        return (ConfigurationFactory)jestConfigurationType;
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement element = context2.getPsiLocation();
        if (element == null || !this.isTestRunnerAvailableFor(element, context2)) {
            return false;
        }
        JestRunSettings jestRunSettings = configuration.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings, (String)"getRunSettings(...)");
        ExtendedSettings extendedSettings = this.buildContextSettings(element, jestRunSettings);
        if (extendedSettings == null) {
            return false;
        }
        ExtendedSettings extendedSettings2 = extendedSettings;
        configuration.setRunSettings(extendedSettings2.getSettings());
        sourceElement.set((Object)extendedSettings2.getEnclosingElement());
        configuration.setGeneratedName();
        return true;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        RunConfiguration runConfiguration = this.cloneTemplateConfiguration(context2).getConfiguration();
        JestRunConfiguration jestRunConfiguration = runConfiguration instanceof JestRunConfiguration ? (JestRunConfiguration)runConfiguration : null;
        if (jestRunConfiguration == null) {
            return false;
        }
        JestRunConfiguration templateConfiguration = jestRunConfiguration;
        JestRunSettings jestRunSettings = templateConfiguration.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings, (String)"getRunSettings(...)");
        ExtendedSettings extendedSettings = this.buildContextSettings(element, jestRunSettings);
        if (extendedSettings == null) {
            return false;
        }
        ExtendedSettings extendedSettings2 = extendedSettings;
        JestRunSettings thisRunSettings = extendedSettings2.getSettings();
        JestRunSettings jestRunSettings2 = configuration.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings2, (String)"getRunSettings(...)");
        JestRunSettings thatRunSettings = jestRunSettings2;
        return this.areConfigFilesEffectivelySame(thisRunSettings, thatRunSettings) && Intrinsics.areEqual((Object)thisRunSettings.getWorkingDirSystemDependentPath(), (Object)thatRunSettings.getWorkingDirSystemDependentPath()) && Intrinsics.areEqual((Object)thisRunSettings.getScope().normalize(), (Object)thatRunSettings.getScope().normalize());
    }

    private final boolean areConfigFilesEffectivelySame(JestRunSettings generatedSettings, JestRunSettings existingSettings) {
        VirtualFile workdirDir;
        if (Intrinsics.areEqual((Object)generatedSettings.getConfigFileSystemDependentPath(), (Object)existingSettings.getConfigFileSystemDependentPath())) {
            return true;
        }
        if (((CharSequence)generatedSettings.getConfigFileSystemDependentPath()).length() == 0 && ((CharSequence)existingSettings.getConfigFileSystemDependentPath()).length() > 0 && (workdirDir = LocalFileSystem.getInstance().findFileByPath(generatedSettings.getWorkingDirSystemDependentPath())) != null) {
            VirtualFile virtualFile = Companion.findDefaultConfigFile(workdirDir);
            return Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getPath() : null), (Object)existingSettings.getConfigFileSystemIndependentPath());
        }
        return false;
    }

    private final ExtendedSettings buildContextSettings(PsiElement element, JestRunSettings templateRunSettings) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        Context context2 = new Context(element, element.getContainingFile(), virtualFile, templateRunSettings);
        if (element instanceof PsiDirectory) {
            return this.buildDirectorySettings((PsiDirectory)element, context2);
        }
        ExtendedSettings extendedSettings = this.buildSuiteOrTestSettings(context2);
        if (extendedSettings != null) {
            ExtendedSettings it = extendedSettings;
            boolean bl = false;
            return it;
        }
        extendedSettings = this.buildConfigSettings(context2);
        if (extendedSettings != null) {
            ExtendedSettings it = extendedSettings;
            boolean bl = false;
            return it;
        }
        return this.buildTestFileSettings(context2);
    }

    private final ExtendedSettings buildDirectorySettings(PsiDirectory psiDirectory, Context context2) {
        VirtualFile virtualFile = context2.getFile();
        Project project = psiDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (Intrinsics.areEqual((Object)virtualFile, (Object)ProjectUtil.guessProjectDir((Project)project)) || Companion.findDefaultConfigFile(context2.getFile()) != null) {
            return new ExtendedSettings(context2.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)buildDirectorySettings.1.INSTANCE)).build(), context2.getFile(), (PsiElement)psiDirectory);
        }
        if (JsTestFileByTestNameIndex.hasJasmineTestsUnderDirectory(psiDirectory.getProject(), context2.getFile())) {
            return new ExtendedSettings(context2.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)new Function1<JsTestRunScope.Builder, Unit>(context2){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull JsTestRunScope.Builder it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.kind(JsTestRunScopeKind.DIRECTORY);
                    String string = this.$context.getFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    it.testDirectoryPath(string);
                }
            })).build(), context2.getFile(), (PsiElement)psiDirectory);
        }
        return null;
    }

    private final ExtendedSettings buildSuiteOrTestSettings(Context context2) {
        JsTestElementPath jsTestElementPath = this.findContextSuiteOrTestPath(context2.getElement());
        if (jsTestElementPath == null) {
            return null;
        }
        JsTestElementPath testPath = jsTestElementPath;
        JestRunSettings.Builder builder2 = context2.getTemplateRunSettings().builder();
        JsTestRunScope.Builder builder3 = builder2.getScope().builder();
        String string = context2.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        builder2.setScope(builder3.testFilePath(string).build());
        String testName = testPath.getTestName();
        if (testName == null) {
            JsTestRunScope.Builder builder4 = builder2.getScope().builder().kind(JsTestRunScopeKind.SUITE);
            List<String> list2 = testPath.getSuiteNames();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSuiteNames(...)");
            builder2.setScope(builder4.testNames(list2).build());
        } else {
            JsTestRunScope.Builder builder5 = builder2.getScope().builder().kind(JsTestRunScopeKind.TEST);
            List<String> list3 = testPath.getSuiteNames();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getSuiteNames(...)");
            builder2.setScope(builder5.testNames(CollectionsKt.plus((Collection)list3, (Object)testName)).build());
        }
        JestRunSettings jestRunSettings = builder2.build();
        VirtualFile virtualFile = context2.getFile();
        PsiElement psiElement = testPath.getTestElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getTestElement(...)");
        return new ExtendedSettings(jestRunSettings, virtualFile, psiElement);
    }

    private final ExtendedSettings buildConfigSettings(Context context2) {
        JsonProperty jestProp;
        if (context2.getPsiFile() != null && JestUtil.isJestConfigFile(context2.getFile().getName())) {
            JestRunSettings settings2 = context2.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)buildConfigSettings.settings.1.INSTANCE)).build();
            return new ExtendedSettings(settings2, context2.getFile(), (PsiElement)context2.getPsiFile());
        }
        if (PackageJsonUtil.isPackageJsonFile(context2.getPsiFile()) && (jestProp = PackageJsonUtil.findContainingTopLevelProperty(context2.getElement())) != null && Intrinsics.areEqual((Object)"jest", (Object)jestProp.getName())) {
            JestRunSettings settings3 = context2.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)buildConfigSettings.settings.2.INSTANCE)).build();
            return new ExtendedSettings(settings3, context2.getFile(), (PsiElement)jestProp);
        }
        return null;
    }

    private final ExtendedSettings buildTestFileSettings(Context context2) {
        JSTestFileType testFileType;
        PsiFile psiFile = context2.getPsiFile();
        JSFile jSFile = psiFile instanceof JSFile ? (JSFile)psiFile : null;
        JSTestFileType jSTestFileType = testFileType = jSFile != null ? jSFile.getTestFileType() : null;
        if (testFileType == JSTestFileType.JASMINE) {
            JestRunSettings.Builder builder2 = context2.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)new Function1<JsTestRunScope.Builder, Unit>(context2){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull JsTestRunScope.Builder it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.kind(JsTestRunScopeKind.TEST_FILE);
                    String string = this.$context.getFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    it.testFilePath(string);
                }
            }));
            return new ExtendedSettings(builder2.build(), context2.getFile(), (PsiElement)context2.getPsiFile());
        }
        return null;
    }

    private final JsTestElementPath findContextSuiteOrTestPath(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        JSFile jSFile = this.getContainingJsFile(element);
        if (jSFile == null) {
            return null;
        }
        JSFile jsFile = jSFile;
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return null;
        }
        TextRange textRange2 = textRange;
        Object t = JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        Intrinsics.checkNotNullExpressionValue(t, (String)"fetchCachedTestFileStructure(...)");
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)t;
        return jasmineStructure.findTestElementPath(textRange2);
    }

    private final JSFile getContainingJsFile(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        return psiFile instanceof JSFile ? (JSFile)psiFile : null;
    }

    @Nullable
    public final VirtualFile guessWorkingDir(@NotNull Project project, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref firstPackageJsonDir = ref;
        AtomicBoolean basedOnJestDeclaredDependency = new AtomicBoolean(false);
        VirtualFile workingDir2 = (VirtualFile)JSProjectUtil.processDirectoriesUpToContentRootAndFindFirst(project, contextFile, arg_0 -> JestRunConfigurationProducer.guessWorkingDir$lambda$2((Function1)new Function1<VirtualFile, VirtualFile>((Ref<VirtualFile>)firstPackageJsonDir, this, basedOnJestDeclaredDependency, project){
            final /* synthetic */ Ref<VirtualFile> $firstPackageJsonDir;
            final /* synthetic */ JestRunConfigurationProducer this$0;
            final /* synthetic */ AtomicBoolean $basedOnJestDeclaredDependency;
            final /* synthetic */ Project $project;
            {
                this.$firstPackageJsonDir = $firstPackageJsonDir;
                this.this$0 = $receiver;
                this.$basedOnJestDeclaredDependency = $basedOnJestDeclaredDependency;
                this.$project = $project;
                super(1);
            }

            @Nullable
            public final VirtualFile invoke(@NotNull VirtualFile dir) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                VirtualFile defaultConfigFile2 = JestRunConfigurationProducer.Companion.findDefaultConfigFile(dir);
                if (defaultConfigFile2 != null) {
                    return dir;
                }
                VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
                if (packageJson != null) {
                    this.$firstPackageJsonDir.setIfNull((Object)dir);
                    PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
                    Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
                    PackageJsonData data = packageJsonData;
                    if (JSTestRunnerManager.isDeclaredInPackageJson(data, this.this$0)) {
                        this.$basedOnJestDeclaredDependency.set(true);
                        return dir;
                    }
                    if (JsTestRunConfigurationProducer.Companion.hasTestScript(this.$project, packageJson, data)) {
                        return dir;
                    }
                }
                return null;
            }
        }, arg_0));
        VirtualFile firstPackageJson = (VirtualFile)firstPackageJsonDir.get();
        if (firstPackageJson != null && !Intrinsics.areEqual((Object)firstPackageJson, (Object)workingDir2) && basedOnJestDeclaredDependency.get()) {
            return firstPackageJson;
        }
        return workingDir2;
    }

    private final JestRunSettings fixWorkingDir(JestRunSettings settings2, VirtualFile contextFileOrDir, Project project) {
        VirtualFile virtualFile;
        if (StringsKt.isBlank((CharSequence)settings2.getWorkingDirSystemDependentPath()) && (virtualFile = this.guessWorkingDir(project, contextFileOrDir)) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            JestRunSettings.Builder builder2 = settings2.builder();
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return builder2.setWorkingDir(string).build();
        }
        return settings2;
    }

    private static final VirtualFile guessWorkingDir$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VirtualFile)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationProducer$Companion;", "", "()V", "findDefaultConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dir", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nJestRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JestRunConfigurationProducer.kt\ncom/intellij/javascript/jest/JestRunConfigurationProducer$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,220:1\n179#2,2:221\n*S KotlinDebug\n*F\n+ 1 JestRunConfigurationProducer.kt\ncom/intellij/javascript/jest/JestRunConfigurationProducer$Companion\n*L\n214#1:221,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VirtualFile findDefaultConfigFile(@NotNull VirtualFile dir) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                List<String> list2 = JestUtil.DEFAULT_CONFIG_FILE_NAMES;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"DEFAULT_CONFIG_FILE_NAMES");
                Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<String, VirtualFile>(dir){
                    final /* synthetic */ VirtualFile $dir;
                    {
                        this.$dir = $dir;
                        super(1);
                    }

                    @Nullable
                    public final VirtualFile invoke(String it) {
                        return this.$dir.findChild(it);
                    }
                }));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl = false;
                    if (!(it != null && !it.isDirectory())) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationProducer$Context;", "", "element", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "templateRunSettings", "Lcom/intellij/javascript/jest/JestRunSettings;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/javascript/jest/JestRunSettings;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getTemplateRunSettings", "()Lcom/intellij/javascript/jest/JestRunSettings;", "intellij.javascript.impl"})
    private static final class Context {
        @NotNull
        private final PsiElement element;
        @Nullable
        private final PsiFile psiFile;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final JestRunSettings templateRunSettings;

        public Context(@NotNull PsiElement element, @Nullable PsiFile psiFile, @NotNull VirtualFile file, @NotNull JestRunSettings templateRunSettings) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)templateRunSettings, (String)"templateRunSettings");
            this.element = element;
            this.psiFile = psiFile;
            this.file = file;
            this.templateRunSettings = templateRunSettings;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @Nullable
        public final PsiFile getPsiFile() {
            return this.psiFile;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final JestRunSettings getTemplateRunSettings() {
            return this.templateRunSettings;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationProducer$ExtendedSettings;", "", "initialSettings", "Lcom/intellij/javascript/jest/JestRunSettings;", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "enclosingElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/javascript/jest/JestRunConfigurationProducer;Lcom/intellij/javascript/jest/JestRunSettings;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/PsiElement;)V", "getEnclosingElement", "()Lcom/intellij/psi/PsiElement;", "settings", "getSettings", "()Lcom/intellij/javascript/jest/JestRunSettings;", "intellij.javascript.impl"})
    private final class ExtendedSettings {
        @NotNull
        private final PsiElement enclosingElement;
        @NotNull
        private final JestRunSettings settings;

        public ExtendedSettings(@NotNull JestRunSettings initialSettings, @NotNull VirtualFile contextFileOrDir, PsiElement enclosingElement) {
            Intrinsics.checkNotNullParameter((Object)initialSettings, (String)"initialSettings");
            Intrinsics.checkNotNullParameter((Object)contextFileOrDir, (String)"contextFileOrDir");
            Intrinsics.checkNotNullParameter((Object)enclosingElement, (String)"enclosingElement");
            this.enclosingElement = enclosingElement;
            Project project = this.enclosingElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.settings = JestRunConfigurationProducer.this.fixWorkingDir(initialSettings, contextFileOrDir, project).modify((Function1<? super JestRunSettings.Builder, Unit>)((Function1)settings.1.INSTANCE));
        }

        @NotNull
        public final PsiElement getEnclosingElement() {
            return this.enclosingElement;
        }

        @NotNull
        public final JestRunSettings getSettings() {
            return this.settings;
        }
    }
}

