/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.css.resolve.CssSimpleSelectorReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptCssReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JavaScriptCssReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context2) {
                return ((JSLiteralExpression)element).isQuotedLiteral() && JavaScriptReferenceContributor.isAcceptableCssLiteralPlace((PsiElement)element, true) && JavaScriptCssReferenceContributor.isAcceptableCssLiteral((JSLiteralExpression)element, true);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                boolean startsWithDotOrSharp;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(psiElement instanceof JSLiteralExpression)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                JSLiteralExpression literal = (JSLiteralExpression)psiElement;
                if (JavaScriptCssReferenceContributor.isAcceptableCssLiteral(literal, false)) {
                    if (JavaScriptCssReferenceContributor.isAcceptableMultiClassReference(psiElement)) {
                        PsiReference[] psiReferenceArray = JavaScriptCssReferenceContributor.buildMultiReferences(literal);
                        if (psiReferenceArray == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return psiReferenceArray;
                    }
                    if (literal.getStringValue() == null) {
                        if (PsiReference.EMPTY_ARRAY == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return PsiReference.EMPTY_ARRAY;
                    }
                    PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(psiElement, CssSelectorSuffixType.ID, null, false, false)};
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return psiReferenceArray;
                }
                String text2 = literal.getStringValue();
                if (text2 == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                int offset = JavaScriptReferenceContributor.skipChars(text2, false, false, true);
                boolean bl = startsWithDotOrSharp = text2.charAt(offset) == '.' || text2.charAt(offset) == '#';
                if (offset == 0 && startsWithDotOrSharp) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(psiElement, text2.charAt(0) == '#' ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS, null, true, true)};
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    return psiReferenceArray;
                }
                if (startsWithDotOrSharp) {
                    CssSelectorSuffixType selectorType = text2.charAt(offset) == '#' ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
                    PsiReference[] psiReferenceArray = new PsiReference[]{new CssSimpleSelectorReference(psiElement, new TextRange(1, offset + 1)), new MyCssClassOrIdReference(psiElement, selectorType, new TextRange(offset + 1 + 1, text2.length() + 1), true, false)};
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(9);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingContext";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/JavaScriptCssReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/JavaScriptCssReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
                };
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context2) {
                return JavaScriptCssReferenceContributor.isHtmlAttributeReference((PsiElement)element);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                JSReferenceExpression methodExpression;
                if (psiElement == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((methodExpression = JSUtils.getMethodNameIfInsideCall(psiElement.getParent())) == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                CssSelectorSuffixType selectorType = "getElementById".equals(methodExpression.getReferenceName()) ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
                PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(psiElement, selectorType, null, false, false)};
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingContext";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/JavaScriptCssReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/JavaScriptCssReferenceContributor$3";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement((IElementType)JSTokenTypes.STRING_LITERAL).withParent(JSProperty.class), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
                PsiElement parent;
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (!((parent = element.getParent()) instanceof JSProperty)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if (((JSProperty)parent).getNameIdentifier() != element) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        5.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiElement objectLiteralCandidate = parent.getParent();
                if (!(objectLiteralCandidate instanceof JSObjectLiteralExpression)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        5.$$$reportNull$$$0(4);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                JSReferenceExpression methodExpression = JSUtils.getMethodNameIfInsideCall(objectLiteralCandidate.getParent());
                if (methodExpression == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        5.$$$reportNull$$$0(5);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if (!JavaScriptReferenceContributor.isCssLibraryHelper(methodExpression)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        5.$$$reportNull$$$0(6);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String text2 = element.getText();
                String unquoted = JSStringUtil.unquoteStringLiteralValue(text2);
                PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(element, CssSelectorSuffixType.CLASS, TextRange.create((int)1, (int)(1 + unquoted.length())), false, false)};
                if (psiReferenceArray == null) {
                    5.$$$reportNull$$$0(7);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4, 5, 6, 7 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/JavaScriptCssReferenceContributor$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/JavaScriptCssReferenceContributor$5";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
                };
            }
        });
    }

    @NotNull
    private static List<Pair<String, Integer>> buildPartsWithOffsets(@NotNull JSLiteralExpression literalExpression) {
        String value;
        if (literalExpression == null) {
            JavaScriptCssReferenceContributor.$$$reportNull$$$0(1);
        }
        if ((value = literalExpression.getStringValue()) != null) {
            List<Pair<String, Integer>> list2 = Collections.singletonList(new Pair((Object)value, (Object)1));
            if (list2 == null) {
                JavaScriptCssReferenceContributor.$$$reportNull$$$0(2);
            }
            return list2;
        }
        if (literalExpression instanceof JSStringTemplateExpression) {
            String text2 = literalExpression.getText();
            Object[] ranges = ((JSStringTemplateExpression)literalExpression).getStringRanges();
            List list3 = ContainerUtil.map((Object[])ranges, el -> new Pair((Object)el.subSequence((CharSequence)text2).toString(), (Object)el.getStartOffset()));
            if (list3 == null) {
                JavaScriptCssReferenceContributor.$$$reportNull$$$0(3);
            }
            return list3;
        }
        List<Pair<String, Integer>> list4 = Collections.emptyList();
        if (list4 == null) {
            JavaScriptCssReferenceContributor.$$$reportNull$$$0(4);
        }
        return list4;
    }

    private static PsiReference @NotNull [] buildMultiReferences(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            JavaScriptCssReferenceContributor.$$$reportNull$$$0(5);
        }
        ArrayList<MyCssClassOrIdReference> result2 = new ArrayList<MyCssClassOrIdReference>();
        List<Pair<String, Integer>> pairs = JavaScriptCssReferenceContributor.buildPartsWithOffsets(literalExpression);
        if (pairs.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaScriptCssReferenceContributor.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Pair<String, Integer> first = pairs.get(0);
        block0: for (Pair<String, Integer> pair : pairs) {
            int end;
            String text2 = (String)pair.getFirst();
            Integer offset = (Integer)pair.getSecond();
            int start = 0;
            while (start < text2.length() && (start = pair == first ? start : JavaScriptCssReferenceContributor.skipChars(text2, start, true)) != (end = JavaScriptCssReferenceContributor.skipChars(text2, start, false))) {
                result2.add(new MyCssClassOrIdReference((PsiElement)literalExpression, CssSelectorSuffixType.CLASS, new TextRange(start + offset, end + offset), false, false));
                if (end == text2.length()) continue block0;
                start = JavaScriptCssReferenceContributor.skipChars(text2, end, true);
            }
        }
        PsiReference[] psiReferenceArray = result2.isEmpty() ? PsiReference.EMPTY_ARRAY : result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            JavaScriptCssReferenceContributor.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    private static boolean isAcceptableMultiClassReference(@NotNull PsiElement psiElement) {
        PsiElement parent;
        JSReferenceExpression invokedMethod;
        if (psiElement == null) {
            JavaScriptCssReferenceContributor.$$$reportNull$$$0(8);
        }
        String name = (invokedMethod = JSUtils.getMethodNameIfInsideCall(parent = JavaScriptReferenceContributor.getTopLevelContext(psiElement))) != null ? invokedMethod.getReferenceName() : null;
        return name != null && (name.contains("Class") || JavaScriptReferenceContributor.isCssLibraryHelper(invokedMethod)) || parent instanceof JSEmbeddedContent;
    }

    private static boolean isAcceptableCssLiteral(@NotNull JSLiteralExpression expression, boolean allowDotsOrSharps) {
        JSLiteralExpressionKind kind;
        if (expression == null) {
            JavaScriptCssReferenceContributor.$$$reportNull$$$0(9);
        }
        if ((kind = expression.getExpressionKind(false)) == JSLiteralExpressionKind.QUOTED || kind == JSLiteralExpressionKind.TEMPLATE_NO_ARGS) {
            String text2 = expression.getStringValue();
            return text2 != null && JavaScriptReferenceContributor.skipChars(text2, allowDotsOrSharps, true, true) == text2.length();
        }
        if (expression instanceof JSStringTemplateExpression) {
            TextRange[] ranges;
            String template = expression.getText();
            for (TextRange range : ranges = ((JSStringTemplateExpression)expression).getStringRanges()) {
                String text3 = range.subSequence((CharSequence)template).toString();
                if (JavaScriptReferenceContributor.skipChars(text3, false, true, true) == text3.length()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int skipChars(String text2, int start, boolean whiteSpace) {
        int result2;
        for (result2 = start; result2 < text2.length() && whiteSpace == Character.isWhitespace(text2.charAt(result2)); ++result2) {
        }
        return result2;
    }

    private static boolean isHtmlAttributeReference(@Nullable PsiElement element) {
        if (!(element instanceof JSLiteralExpression) || !((JSLiteralExpression)element).isQuotedLiteral()) {
            return false;
        }
        JSReferenceExpression methodExpression = JSUtils.getMethodNameIfInsideCall(element.getParent());
        if (methodExpression == null) {
            return false;
        }
        return "getElementById".equals(methodExpression.getReferenceName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JavaScriptCssReferenceContributor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JavaScriptCssReferenceContributor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPartsWithOffsets";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMultiReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildPartsWithOffsets";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildMultiReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableMultiClassReference";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableCssLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class MyCssClassOrIdReference
    extends CssClassOrIdReference {
        @NotNull
        private final CssSelectorSuffixType mySelectorType;
        private final boolean myHasExplicitIdMark;
        private final boolean myHasExplicitClassMark;

        MyCssClassOrIdReference(PsiElement psiElement, @NotNull CssSelectorSuffixType selectorType, @Nullable TextRange range, boolean hasExplicitIdMark, boolean hasExplicitClassMark) {
            if (selectorType == null) {
                MyCssClassOrIdReference.$$$reportNull$$$0(0);
            }
            super(psiElement, range);
            this.mySelectorType = selectorType;
            this.myHasExplicitIdMark = hasExplicitIdMark;
            this.myHasExplicitClassMark = hasExplicitClassMark;
        }

        public boolean isId() {
            return this.mySelectorType == CssSelectorSuffixType.ID;
        }

        protected boolean hasExplicitIdMark() {
            return this.myHasExplicitIdMark;
        }

        protected boolean hasExplicitClassMark() {
            return this.myHasExplicitClassMark;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorType", "com/intellij/javascript/JavaScriptCssReferenceContributor$MyCssClassOrIdReference", "<init>"));
        }
    }
}

