/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/JSLanguageLevelGuesser;", "Lcom/intellij/platform/DirectoryProjectConfigurator$AsyncDirectoryProjectConfigurator;", "()V", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/openapi/module/Module;", "isProjectCreatedWithWizard", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/util/Ref;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.javascript.impl"})
public final class JSLanguageLevelGuesser
extends DirectoryProjectConfigurator.AsyncDirectoryProjectConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Object configure(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.readAction((Function0)((Function0)new Function0<Unit>(project, baseDir){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $baseDir;
            {
                this.$project = $project;
                this.$baseDir = $baseDir;
                super(0);
            }

            public final void invoke() {
                JSLanguageLevelGuesser.Companion.configureProject(this.$project, this.$baseDir);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @RequiresReadLock(generateAssertion=false)
    public static final void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir) {
        Companion.configureProject(project, baseDir);
    }

    @JvmStatic
    public static final void applyGuessedLanguageLevel(@NotNull Project project, @Nullable JSLanguageLevel guessedLevel) {
        Companion.applyGuessedLanguageLevel(project, guessedLevel);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/JSLanguageLevelGuesser$Companion;", "", "()V", "applyGuessedLanguageLevel", "", "project", "Lcom/intellij/openapi/project/Project;", "guessedLevel", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "configureProject", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @RequiresReadLock(generateAssertion=false)
        public final void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            JSLanguageLevel guessedLevel = null;
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(baseDir);
            if (packageJson != null) {
                PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
                Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
                PackageJsonData data = packageJsonData;
                for (String dep : data.getAllDependencies()) {
                    if (Intrinsics.areEqual((Object)"react", (Object)dep)) {
                        guessedLevel = JSLanguageLevel.getLevelForJSX();
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)"flow-bin", (Object)dep)) continue;
                    guessedLevel = JSLanguageLevel.FLOW;
                    break;
                }
            }
            if (guessedLevel != JSLanguageLevel.FLOW && baseDir.findChild(".flowconfig") != null) {
                guessedLevel = JSLanguageLevel.FLOW;
            }
            this.applyGuessedLanguageLevel(project, guessedLevel);
        }

        @JvmStatic
        public final void applyGuessedLanguageLevel(@NotNull Project project, @Nullable JSLanguageLevel guessedLevel) {
            JSRootConfiguration rootConfiguration;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (guessedLevel != null && guessedLevel.isAtLeast((rootConfiguration = JSRootConfiguration.getInstance(project)).getLanguageLevel()) && guessedLevel != rootConfiguration.getLanguageLevel()) {
                rootConfiguration.storeLanguageLevelAndUpdateCaches(guessedLevel);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

