/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.InternalAttributeKeyImpl;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.AnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.ArrayAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.BoolAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.DoubleAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.IntAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.StringAnyValueMarshaler;
import io.opentelemetry.extension.incubator.logs.KeyAnyValue;
import io.opentelemetry.proto.common.v1.internal.KeyValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;

public final class KeyValueMarshaler
extends MarshalerWithSize {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final KeyValueMarshaler[] EMPTY_REPEATED = new KeyValueMarshaler[0];
    private final byte[] keyUtf8;
    private final Marshaler value;

    private KeyValueMarshaler(byte[] keyUtf8, Marshaler value) {
        super(KeyValueMarshaler.calculateSize(keyUtf8, value));
        this.keyUtf8 = keyUtf8;
        this.value = value;
    }

    public static KeyValueMarshaler createForKeyAnyValue(KeyAnyValue keyAnyValue) {
        return new KeyValueMarshaler(keyAnyValue.getKey().getBytes(StandardCharsets.UTF_8), AnyValueMarshaler.create(keyAnyValue.getAnyValue()));
    }

    public static KeyValueMarshaler[] createForAttributes(Attributes attributes) {
        if (attributes.isEmpty()) {
            return EMPTY_REPEATED;
        }
        final KeyValueMarshaler[] marshalers = new KeyValueMarshaler[attributes.size()];
        attributes.forEach(new BiConsumer<AttributeKey<?>, Object>(){
            int index = 0;

            @Override
            public void accept(AttributeKey<?> attributeKey, Object o) {
                marshalers[this.index++] = KeyValueMarshaler.create(attributeKey, o);
            }
        });
        return marshalers;
    }

    private static KeyValueMarshaler create(AttributeKey<?> attributeKey, Object value) {
        byte[] keyUtf8 = attributeKey.getKey().isEmpty() ? EMPTY_BYTES : (attributeKey instanceof InternalAttributeKeyImpl ? ((InternalAttributeKeyImpl)attributeKey).getKeyUtf8() : attributeKey.getKey().getBytes(StandardCharsets.UTF_8));
        switch (attributeKey.getType()) {
            case STRING: {
                return new KeyValueMarshaler(keyUtf8, StringAnyValueMarshaler.create((String)value));
            }
            case LONG: {
                return new KeyValueMarshaler(keyUtf8, IntAnyValueMarshaler.create((Long)value));
            }
            case BOOLEAN: {
                return new KeyValueMarshaler(keyUtf8, BoolAnyValueMarshaler.create((Boolean)value));
            }
            case DOUBLE: {
                return new KeyValueMarshaler(keyUtf8, DoubleAnyValueMarshaler.create((Double)value));
            }
            case STRING_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createString((List)value));
            }
            case LONG_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createInt((List)value));
            }
            case BOOLEAN_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createBool((List)value));
            }
            case DOUBLE_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createDouble((List)value));
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type.");
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeString(KeyValue.KEY, this.keyUtf8);
        output.serializeMessage(KeyValue.VALUE, this.value);
    }

    private static int calculateSize(byte[] keyUtf8, Marshaler value) {
        int size = 0;
        size += MarshalerUtil.sizeBytes(KeyValue.KEY, keyUtf8);
        return size += MarshalerUtil.sizeMessage(KeyValue.VALUE, value);
    }
}

