/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.http.logging.HttpMessageArgProviderFactory;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.IdleTimeoutHandler;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;

final class HttpTrafficHandler
extends ChannelDuplexHandler
implements Runnable,
ChannelFutureListener {
    static final String MULTIPART_PREFIX = "multipart";
    static final HttpVersion H2 = HttpVersion.valueOf((String)"HTTP/2.0");
    final BiPredicate<HttpServerRequest, HttpServerResponse> compress;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final HttpMessageLogFactory httpMessageLogFactory;
    final Duration idleTimeout;
    final ConnectionObserver listener;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    final int maxKeepAliveRequests;
    final Duration readTimeout;
    final Duration requestTimeout;
    ChannelHandlerContext ctx;
    boolean nonInformationalResponse;
    boolean overflow;
    int pendingResponses;
    boolean persistentConnection = true;
    Queue<Object> pipelined;
    SocketAddress remoteAddress;
    Boolean secure;

    HttpTrafficHandler(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, @Nullable Duration idleTimeout, ConnectionObserver listener2, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, int maxKeepAliveRequests, @Nullable Duration readTimeout, @Nullable Duration requestTimeout) {
        this.listener = listener2;
        this.formDecoderProvider = formDecoderProvider;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.compress = compress;
        this.cookieEncoder = encoder;
        this.cookieDecoder = decoder;
        this.httpMessageLogFactory = httpMessageLogFactory;
        this.idleTimeout = idleTimeout;
        this.mapHandle = mapHandle;
        this.maxKeepAliveRequests = maxKeepAliveRequests;
        this.readTimeout = readTimeout;
        this.requestTimeout = requestTimeout;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New http connection, requesting read"));
        }
        ctx.read();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        IdleTimeoutHandler.addIdleTimeoutHandler(ctx.pipeline(), this.idleTimeout);
        ctx.fireChannelActive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        DecoderResult decoderResult;
        if (this.secure == null) {
            this.secure = ctx.channel().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel())).orElse(ctx.channel().remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            IdleTimeoutHandler.removeIdleTimeoutHandler(ctx.pipeline());
            HttpRequest request2 = (HttpRequest)msg;
            if (H2.equals((Object)request2.protocolVersion())) {
                IllegalStateException e = new IllegalStateException("Unexpected request [" + request2.method() + " " + request2.uri() + " HTTP/2.0]");
                request2.setDecoderResult(DecoderResult.failure((Throwable)(e.getCause() != null ? e.getCause() : e)));
                this.sendDecodingFailures(e, msg);
                return;
            }
            if (this.persistentConnection) {
                ++this.pendingResponses;
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Increasing pending responses, now {}"), this.pendingResponses);
                }
            } else {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropping pipelined HTTP request, previous response requested connection close"));
                }
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            this.persistentConnection = HttpUtil.isKeepAlive((HttpMessage)request2);
            if (this.pendingResponses > 1) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Buffering pipelined HTTP request, pending response count: {}, queue: {}"), this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0);
                }
                this.overflow = true;
                this.doPipeline(ctx, new HttpRequestHolder(request2));
                return;
            }
            this.overflow = false;
            DecoderResult decoderResult2 = request2.decoderResult();
            if (decoderResult2.isFailure()) {
                this.sendDecodingFailures(decoderResult2.cause(), msg);
                return;
            }
            ZonedDateTime timestamp = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
            ConnectionInfo connectionInfo = null;
            try {
                connectionInfo = ConnectionInfo.from(ctx.channel(), request2, this.secure, this.remoteAddress, this.forwardedHeaderHandler);
                ops = new HttpServerOperations(Connection.from(ctx.channel()), this.listener, request2, this.compress, connectionInfo, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.httpMessageLogFactory, false, this.mapHandle, this.readTimeout, this.requestTimeout, this.secure, timestamp);
            }
            catch (RuntimeException e) {
                request2.setDecoderResult(DecoderResult.failure((Throwable)(e.getCause() != null ? e.getCause() : e)));
                this.sendDecodingFailures(e, msg, timestamp, connectionInfo);
                return;
            }
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
            ctx.fireChannelRead(msg);
            return;
        }
        if (this.persistentConnection && this.pendingResponses == 0) {
            if (msg instanceof LastHttpContent) {
                DecoderResult decoderResult3 = ((LastHttpContent)msg).decoderResult();
                if (decoderResult3.isFailure()) {
                    this.sendDecodingFailures(decoderResult3.cause(), msg);
                    return;
                }
                ctx.fireChannelRead(msg);
            } else {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), msg instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(msg)) : msg);
                }
                ReferenceCountUtil.release((Object)msg);
            }
            ctx.read();
            return;
        }
        if (this.overflow) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Buffering pipelined HTTP content, pending response count: {}, pending pipeline:{}"), this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0);
            }
            this.doPipeline(ctx, msg);
            return;
        }
        if (msg instanceof DecoderResultProvider && (decoderResult = ((DecoderResultProvider)msg).decoderResult()).isFailure()) {
            this.sendDecodingFailures(decoderResult.cause(), msg);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    void sendDecodingFailures(Throwable t, Object msg) {
        this.sendDecodingFailures(t, msg, null, null);
    }

    void sendDecodingFailures(Throwable t, Object msg, @Nullable ZonedDateTime timestamp, @Nullable ConnectionInfo connectionInfo) {
        this.persistentConnection = false;
        HttpServerOperations.sendDecodingFailures(this.ctx, this.listener, this.secure, t, msg, this.httpMessageLogFactory, timestamp, connectionInfo, this.remoteAddress);
    }

    void doPipeline(ChannelHandlerContext ctx, Object msg) {
        if (this.pipelined == null) {
            this.pipelined = Queues.unbounded().get();
        }
        if (!this.pipelined.offer(msg)) {
            ctx.fireExceptionCaught((Throwable)Exceptions.failWithOverflow());
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            boolean maxKeepAliveRequestsReached;
            HttpResponse response2 = (HttpResponse)msg;
            this.nonInformationalResponse = !HttpTrafficHandler.isInformational(response2);
            boolean bl = maxKeepAliveRequestsReached = this.maxKeepAliveRequests != -1 && HttpServerOperations.requestsCounter(ctx.channel()) == (long)this.maxKeepAliveRequests;
            if (maxKeepAliveRequestsReached || !HttpUtil.isKeepAlive((HttpMessage)response2) || !HttpTrafficHandler.isSelfDefinedMessageLength(response2)) {
                this.pendingResponses = 0;
                this.persistentConnection = false;
            }
            if (!this.shouldKeepAlive()) {
                HttpUtil.setKeepAlive((HttpMessage)response2, (boolean)false);
            }
            if (response2.status().equals((Object)HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
        }
        if (msg instanceof LastHttpContent) {
            if (!this.shouldKeepAlive()) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Detected non persistent http connection, preparing to close"), this.pendingResponses);
                }
                ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener)this).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener)this);
            if (!this.persistentConnection) {
                return;
            }
            if (this.nonInformationalResponse) {
                this.nonInformationalResponse = false;
                --this.pendingResponses;
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Decreasing pending responses, now {}"), this.pendingResponses);
                }
            }
            if (this.pipelined != null && !this.pipelined.isEmpty()) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Draining next pipelined request, pending response count: {}, queued: {}"), this.pendingResponses, this.pipelined.size());
                }
                ctx.executor().execute((Runnable)this);
            } else {
                ctx.read();
            }
            return;
        }
        if (this.persistentConnection && this.pendingResponses == 0) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), msg instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(msg)) : msg);
            }
            ReferenceCountUtil.release((Object)msg);
            promise.setSuccess();
            return;
        }
        ctx.write(msg, promise);
    }

    @Override
    public void run() {
        Object next;
        HttpRequest nextRequest = null;
        while ((next = this.pipelined.peek()) != null) {
            if (next instanceof HttpRequestHolder) {
                HttpServerOperations ops;
                if (nextRequest != null) {
                    return;
                }
                if (!this.persistentConnection) {
                    this.discard();
                    return;
                }
                HttpRequestHolder holder = (HttpRequestHolder)next;
                nextRequest = holder.request;
                DecoderResult decoderResult = nextRequest.decoderResult();
                if (decoderResult.isFailure()) {
                    this.sendDecodingFailures(decoderResult.cause(), nextRequest, holder.timestamp, null);
                    this.discard();
                    return;
                }
                ConnectionInfo connectionInfo = null;
                try {
                    connectionInfo = ConnectionInfo.from(this.ctx.channel(), nextRequest, this.secure, this.remoteAddress, this.forwardedHeaderHandler);
                    ops = new HttpServerOperations(Connection.from(this.ctx.channel()), this.listener, nextRequest, this.compress, connectionInfo, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.httpMessageLogFactory, false, this.mapHandle, this.readTimeout, this.requestTimeout, this.secure, holder.timestamp);
                }
                catch (RuntimeException e) {
                    holder.request.setDecoderResult(DecoderResult.failure((Throwable)(e.getCause() != null ? e.getCause() : e)));
                    this.sendDecodingFailures(e, holder.request, holder.timestamp, connectionInfo);
                    return;
                }
                ops.bind();
                this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
                this.pipelined.poll();
                this.ctx.fireChannelRead((Object)holder.request);
                continue;
            }
            this.ctx.fireChannelRead(this.pipelined.poll());
        }
        this.overflow = false;
    }

    public void operationComplete(ChannelFuture future) {
        if (!future.isSuccess()) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Sending last HTTP packet was not successful, terminating the channel"), future.cause());
            }
        } else if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Last HTTP packet was sent, terminating the channel"));
        }
        IdleTimeoutHandler.addIdleTimeoutHandler(future.channel().pipeline(), this.idleTimeout);
        HttpServerOperations.cleanHandlerTerminate(future.channel());
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.discard();
    }

    final void discard() {
        if (this.pipelined != null && !this.pipelined.isEmpty()) {
            Object o;
            while ((o = this.pipelined.poll()) != null) {
                ReferenceCountUtil.release((Object)o);
            }
        }
    }

    boolean shouldKeepAlive() {
        return this.pendingResponses != 0 && this.persistentConnection;
    }

    static boolean isSelfDefinedMessageLength(HttpResponse response2) {
        return HttpUtil.isContentLengthSet((HttpMessage)response2) || HttpUtil.isTransferEncodingChunked((HttpMessage)response2) || HttpTrafficHandler.isMultipart(response2) || HttpTrafficHandler.isInformational(response2) || HttpTrafficHandler.isNotModified(response2) || HttpTrafficHandler.isNoContent(response2);
    }

    static boolean isInformational(HttpResponse response2) {
        return response2.status().codeClass() == HttpStatusClass.INFORMATIONAL;
    }

    static boolean isNoContent(HttpResponse response2) {
        return HttpResponseStatus.NO_CONTENT.code() == response2.status().code();
    }

    static boolean isNotModified(HttpResponse response2) {
        return HttpResponseStatus.NOT_MODIFIED.code() == response2.status().code();
    }

    static boolean isMultipart(HttpResponse response2) {
        String contentType2 = response2.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return contentType2 != null && contentType2.regionMatches(true, 0, MULTIPART_PREFIX, 0, MULTIPART_PREFIX.length());
    }

    static final class HttpRequestHolder {
        final HttpRequest request;
        final ZonedDateTime timestamp;

        HttpRequestHolder(HttpRequest request2) {
            this.request = request2;
            this.timestamp = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
        }
    }
}

