/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.InternalMonoOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoLift<I, O>
extends InternalMonoOperator<I, O> {
    final Operators.LiftFunction<I, O> liftFunction;

    MonoLift(Publisher<I> p, Operators.LiftFunction<I, O> liftFunction) {
        super(Mono.from(p));
        this.liftFunction = liftFunction;
    }

    @Override
    public CoreSubscriber<? super I> subscribeOrReturn(CoreSubscriber<? super O> actual) {
        CoreSubscriber input = this.liftFunction.lifter.apply(this.source, actual);
        Objects.requireNonNull(input, "Lifted subscriber MUST NOT be null");
        return input;
    }

    @Override
    public String stepName() {
        if (this.source instanceof Scannable) {
            return Scannable.from(this.source).stepName();
        }
        return super.stepName();
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key2) {
        if (key2 == Scannable.Attr.RUN_STYLE) {
            return Scannable.from(this.source).scanUnsafe(key2);
        }
        if (key2 == Scannable.Attr.LIFTER) {
            return this.liftFunction.name;
        }
        return super.scanUnsafe(key2);
    }
}

