/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.org.jcodings.util;

import org.graalvm.shadowed.org.jcodings.util.Hash;

public final class IntArrayHash<V>
extends Hash<V> {
    public IntArrayHash() {
    }

    public IntArrayHash(int size) {
        super(size);
    }

    @Override
    protected void init() {
        this.head = new IntArrayHashEntry();
    }

    private int hashCode(int[] key2) {
        switch (key2.length) {
            case 1: {
                return key2[0];
            }
            case 2: {
                return key2[0] + key2[1];
            }
            case 3: {
                return key2[0] + key2[1] + key2[2];
            }
            case 4: {
                return key2[0] + key2[1] + key2[2] + key2[3];
            }
        }
        int h = 0;
        for (int i = 0; i < key2.length; ++i) {
            h += key2[i];
        }
        return h;
    }

    public V put(int[] key2, V value) {
        this.checkResize();
        int hash = IntArrayHash.hashValue(this.hashCode(key2));
        int i = IntArrayHash.bucketIndex(hash, this.table.length);
        IntArrayHashEntry entry = (IntArrayHashEntry)this.table[i];
        while (entry != null) {
            if (entry.hash == hash && entry.equals(key2)) {
                entry.value = value;
                return value;
            }
            entry = (IntArrayHashEntry)entry.next;
        }
        this.table[i] = new IntArrayHashEntry<V>(hash, this.table[i], value, key2, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(int[] key2, V value) {
        this.checkResize();
        int hash = IntArrayHash.hashValue(this.hashCode(key2));
        int i = IntArrayHash.bucketIndex(hash, this.table.length);
        this.table[i] = new IntArrayHashEntry<V>(hash, this.table[i], value, key2, this.head);
        ++this.size;
    }

    public V get(int ... key2) {
        int hash = IntArrayHash.hashValue(this.hashCode(key2));
        IntArrayHashEntry entry = (IntArrayHashEntry)this.table[IntArrayHash.bucketIndex(hash, this.table.length)];
        while (entry != null) {
            if (entry.hash == hash && entry.equals(key2)) {
                return (V)entry.value;
            }
            entry = (IntArrayHashEntry)entry.next;
        }
        return null;
    }

    public V delete(int ... key2) {
        int hash = IntArrayHash.hashValue(this.hashCode(key2));
        int i = IntArrayHash.bucketIndex(hash, this.table.length);
        IntArrayHashEntry entry = (IntArrayHashEntry)this.table[i];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash && entry.equals(key2)) {
            this.table[i] = entry.next;
            --this.size;
            entry.remove();
            return (V)entry.value;
        }
        while (entry.next != null) {
            Hash.HashEntry tmp = entry.next;
            if (tmp.hash == hash && entry.equals(key2)) {
                entry.next = entry.next.next;
                --this.size;
                tmp.remove();
                return tmp.value;
            }
            entry = (IntArrayHashEntry)entry.next;
        }
        return null;
    }

    public static final class IntArrayHashEntry<V>
    extends Hash.HashEntry<V> {
        public final int[] key;

        public IntArrayHashEntry(int hash, Hash.HashEntry<V> next, V value, int[] key2, Hash.HashEntry<V> head) {
            super(hash, next, value, head);
            this.key = key2;
        }

        public IntArrayHashEntry() {
            this.key = null;
        }

        public boolean equals(int[] key2) {
            if (this.key == key2) {
                return true;
            }
            if (this.key.length != key2.length) {
                return false;
            }
            switch (key2.length) {
                case 1: {
                    return this.key[0] == key2[0];
                }
                case 2: {
                    return this.key[0] == key2[0] && this.key[1] == key2[1];
                }
                case 3: {
                    return this.key[0] == key2[0] && this.key[1] == key2[1] && this.key[2] == key2[2];
                }
                case 4: {
                    return this.key[0] == key2[0] && this.key[1] == key2[1] && this.key[2] == key2[2] && this.key[3] == key2[3];
                }
            }
            for (int i = 0; i < key2.length; ++i) {
                if (this.key[i] == key2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

