/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.collections;

import java.util.Map;
import java.util.function.BiFunction;
import org.graalvm.collections.EconomicMapImpl;
import org.graalvm.collections.EconomicMapWrap;
import org.graalvm.collections.EmptyMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;

public interface EconomicMap<K, V>
extends UnmodifiableEconomicMap<K, V> {
    public V put(K var1, V var2);

    default public V putIfAbsent(K key2, V value) {
        Object v = this.get(key2);
        if (v == null) {
            v = this.put(key2, value);
        }
        return v;
    }

    default public void putAll(EconomicMap<K, V> other) {
        UnmodifiableMapCursor e = other.getEntries();
        while (e.advance()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    default public void putAll(UnmodifiableEconomicMap<? extends K, ? extends V> other) {
        UnmodifiableMapCursor<K, V> entry = other.getEntries();
        while (entry.advance()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear();

    public V removeKey(K var1);

    @Override
    public MapCursor<K, V> getEntries();

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> var1);

    public static <K, V> EconomicMap<K, V> create() {
        return EconomicMap.create(Equivalence.DEFAULT);
    }

    public static <K, V> EconomicMap<K, V> create(int initialCapacity) {
        return EconomicMap.create(Equivalence.DEFAULT, initialCapacity);
    }

    public static <K, V> EconomicMap<K, V> create(Equivalence strategy) {
        return EconomicMapImpl.create(strategy, false);
    }

    public static <K, V> EconomicMap<K, V> create(UnmodifiableEconomicMap<K, V> m) {
        return EconomicMap.create(Equivalence.DEFAULT, m);
    }

    public static <K, V> EconomicMap<K, V> create(Equivalence strategy, UnmodifiableEconomicMap<K, V> m) {
        return EconomicMapImpl.create(strategy, m, false);
    }

    public static <K, V> EconomicMap<K, V> create(Equivalence strategy, int initialCapacity) {
        return EconomicMapImpl.create(strategy, initialCapacity, false);
    }

    public static <K, V> EconomicMap<K, V> wrapMap(Map<K, V> map2) {
        return new EconomicMapWrap<K, V>(map2);
    }

    public static <K, V> MapCursor<K, V> emptyCursor() {
        return EmptyMap.EMPTY_CURSOR;
    }

    public static <K, V> EconomicMap<K, V> emptyMap() {
        return EmptyMap.EMPTY_MAP;
    }

    public static <K, V> EconomicMap<K, V> of(K key1, V value1) {
        EconomicMap<K, V> map2 = EconomicMap.create(1);
        map2.put(key1, value1);
        return map2;
    }

    public static <K, V> EconomicMap<K, V> of(K key1, V value1, K key2, V value2) {
        EconomicMap<K, V> map2 = EconomicMap.create(2);
        map2.put(key1, value1);
        map2.put(key2, value2);
        return map2;
    }
}

