/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.writer;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import net.minidev.asm.Accessor;
import net.minidev.asm.BeansAccess;
import net.minidev.asm.ConvertDate;
import net.minidev.json.JSONUtil;
import net.minidev.json.writer.ArraysMapper;
import net.minidev.json.writer.JsonReader;
import net.minidev.json.writer.JsonReaderI;

public abstract class BeansMapper<T>
extends JsonReaderI<T> {
    public static JsonReaderI<Date> MAPPER_DATE = new ArraysMapper<Date>(null){

        @Override
        public Date convert(Object current) {
            return ConvertDate.convertToDate(current);
        }
    };

    public BeansMapper(JsonReader base) {
        super(base);
    }

    @Override
    public abstract Object getValue(Object var1, String var2);

    public static class BeanNoConv<T>
    extends JsonReaderI<T> {
        final Class<T> clz;
        final BeansAccess<T> ba;
        final HashMap<String, Accessor> index;

        public BeanNoConv(JsonReader base, Class<T> clz) {
            super(base);
            this.clz = clz;
            this.ba = BeansAccess.get(clz, JSONUtil.JSON_SMART_FIELD_FILTER);
            this.index = this.ba.getMap();
        }

        @Override
        public void setValue(Object current, String key2, Object value) {
            this.ba.set(current, key2, value);
        }

        @Override
        public Object getValue(Object current, String key2) {
            return this.ba.get(current, key2);
        }

        @Override
        public Type getType(String key2) {
            Accessor nfo = this.index.get(key2);
            return nfo.getGenericType();
        }

        @Override
        public JsonReaderI<?> startArray(String key2) {
            Accessor nfo = this.index.get(key2);
            if (nfo == null) {
                throw new RuntimeException("Can not set " + key2 + " field in " + this.clz);
            }
            return this.base.getMapper(nfo.getGenericType());
        }

        @Override
        public JsonReaderI<?> startObject(String key2) {
            Accessor f = this.index.get(key2);
            if (f == null) {
                throw new RuntimeException("Can not set " + key2 + " field in " + this.clz);
            }
            return this.base.getMapper(f.getGenericType());
        }

        @Override
        public Object createObject() {
            return this.ba.newInstance();
        }
    }

    public static class Bean<T>
    extends JsonReaderI<T> {
        final Class<T> clz;
        final BeansAccess<T> ba;
        final HashMap<String, Accessor> index;

        public Bean(JsonReader base, Class<T> clz) {
            super(base);
            this.clz = clz;
            this.ba = BeansAccess.get(clz, JSONUtil.JSON_SMART_FIELD_FILTER);
            this.index = this.ba.getMap();
        }

        @Override
        public void setValue(Object current, String key2, Object value) {
            this.ba.set(current, key2, value);
        }

        @Override
        public Object getValue(Object current, String key2) {
            return this.ba.get(current, key2);
        }

        @Override
        public Type getType(String key2) {
            Accessor nfo = this.index.get(key2);
            return nfo.getGenericType();
        }

        @Override
        public JsonReaderI<?> startArray(String key2) {
            Accessor nfo = this.index.get(key2);
            if (nfo == null) {
                throw new RuntimeException("Can not find Array '" + key2 + "' field in " + this.clz);
            }
            return this.base.getMapper(nfo.getGenericType());
        }

        @Override
        public JsonReaderI<?> startObject(String key2) {
            Accessor f = this.index.get(key2);
            if (f == null) {
                throw new RuntimeException("Can not find Object '" + key2 + "' field in " + this.clz);
            }
            return this.base.getMapper(f.getGenericType());
        }

        @Override
        public Object createObject() {
            return this.ba.newInstance();
        }
    }
}

