/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.ibm.icu.lang.UCharacter;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldTable;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.RegexValidator;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonRegexParser;
import com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.function.BiPredicate;

public final class PythonFlavor
extends RegexFlavor {
    public static final PythonFlavor INSTANCE = new PythonFlavor();

    private PythonFlavor() {
        super(253);
    }

    @Override
    public RegexValidator createValidator(RegexSource source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegexParser createParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return new PythonRegexParser(language, source, compilationBuffer);
    }

    @Override
    public BiPredicate<Integer, Integer> getEqualsIgnoreCasePredicate(RegexAST ast) {
        if (ast.getOptions().getEncoding() == Encodings.UTF_32) {
            return PythonFlavor::equalsIgnoreCaseUnicode;
        }
        assert (ast.getOptions().getEncoding() == Encodings.LATIN_1);
        return CaseFoldTable.CaseFoldingAlgorithm.PythonAscii.getEqualsPredicate();
    }

    private static boolean equalsIgnoreCaseUnicode(int codePointA, int codePointB) {
        return UCharacter.toLowerCase(codePointA) == UCharacter.toLowerCase(codePointB);
    }
}

