/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;

final class FinalIntMap {
    @CompilerDirectives.CompilationFinal
    Entry first;

    FinalIntMap() {
    }

    @ExplodeLoop
    int get(Object key2) {
        Entry current = this.first;
        while (current != null) {
            if (current.key == key2) {
                return current.value;
            }
            current = current.next;
        }
        return -1;
    }

    void put(Object key2, int value) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.get(key2) == -1) : "replace not supported by this map implementation";
        assert (value >= 0) : "only positive integers supported";
        Entry prev = null;
        Entry current = this.first;
        while (current != null) {
            prev = current;
            current = current.next;
        }
        Entry entry = new Entry(key2, value);
        if (prev == null) {
            assert (current == this.first);
            this.first = entry;
        } else {
            prev.next = entry;
        }
    }

    static final class Entry {
        final Object key;
        final int value;
        @CompilerDirectives.CompilationFinal
        Entry next;

        Entry(Object key2, int value) {
            this.key = key2;
            this.value = value;
        }
    }
}

