/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.ObjectPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectPrototypeObject;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import java.util.List;

public final class JSObjectPrototype
extends JSNonProxy {
    public static final TruffleString CLASS_NAME = Strings.UC_OBJECT;
    public static final JSObjectPrototype INSTANCE = new JSObjectPrototype();
    public static final JSBuiltinsContainer BUILTINS = ObjectPrototypeBuiltins.BUILTINS;

    private JSObjectPrototype() {
    }

    public static JSObjectPrototypeObject create(JSContext context) {
        return JSObjectPrototype.create(context.makeEmptyShapeWithNullPrototype(INSTANCE));
    }

    public static boolean isJSObjectPrototype(Object obj) {
        return obj instanceof JSObjectPrototypeObject;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public TruffleString toDisplayStringImpl(JSDynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        return this.defaultToString(obj);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(JSDynamicObject thisObj, Object key2) {
        if (super.hasOwnProperty(thisObj, key2)) {
            return true;
        }
        long index = JSRuntime.propertyKeyToArrayIndex(key2);
        if (JSRuntime.isArrayIndex(index)) {
            return JSObject.getArray(thisObj).hasElement(thisObj, index);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(JSDynamicObject thisObj, long index) {
        ScriptArray array = JSObject.getArray(thisObj);
        if (array.hasElement(thisObj, index)) {
            return true;
        }
        return super.hasOwnProperty(thisObj, Strings.fromLong(index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(JSDynamicObject store, Object thisObj, long index, Node encapsulatingNode) {
        ScriptArray array = JSObject.getArray(store);
        if (array.hasElement(store, index)) {
            return array.getElement(store, index);
        }
        return super.getOwnHelper(store, thisObj, Strings.fromLong(index), encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(JSDynamicObject store, Object thisObj, Object key2, Node encapsulatingNode) {
        long idx = JSRuntime.propertyKeyToArrayIndex(key2);
        if (JSRuntime.isArrayIndex(idx)) {
            return this.getOwnHelper(store, thisObj, idx, encapsulatingNode);
        }
        return super.getOwnHelper(store, thisObj, key2, encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(JSDynamicObject thisObj, Object key2, boolean isStrict) {
        long index = JSRuntime.propertyKeyToArrayIndex(key2);
        if (index >= 0L) {
            return this.delete(thisObj, index, isStrict);
        }
        return super.delete(thisObj, key2, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(JSDynamicObject thisObj, long index, boolean isStrict) {
        ScriptArray array = JSObject.getArray(thisObj);
        if (array.hasElement(thisObj, index)) {
            if (array.canDeleteElement(thisObj, index, isStrict)) {
                JSObject.setArray(thisObj, array.deleteElement(thisObj, index, isStrict));
                return true;
            }
            return false;
        }
        return JSOrdinary.INSTANCE.delete(thisObj, index, isStrict);
    }

    @Override
    public List<Object> getOwnPropertyKeys(JSDynamicObject thisObj, boolean strings, boolean symbols) {
        if (!strings || JSObject.getArray(thisObj).length(thisObj) == 0L) {
            return super.getOwnPropertyKeys(thisObj, strings, symbols);
        }
        return JSAbstractArray.ownPropertyKeysSlowArray(thisObj, strings, symbols);
    }

    @Override
    public boolean hasOnlyShapeProperties(JSDynamicObject thisObj) {
        return JSObject.getArray(thisObj).length(thisObj) == 0L;
    }

    @Override
    public PropertyDescriptor getOwnProperty(JSDynamicObject thisObj, Object key2) {
        assert (JSRuntime.isPropertyKey(key2));
        return JSAbstractArray.ordinaryGetOwnPropertyArray(thisObj, key2);
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }

    @Override
    public boolean setPrototypeOf(JSDynamicObject thisObj, JSDynamicObject newPrototype) {
        return JSObject.getPrototype(thisObj) == newPrototype;
    }

    @Override
    public boolean set(JSDynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        boolean result2 = super.set(thisObj, index, value, receiver, isStrict, encapsulatingNode);
        JSObject.getJSContext(thisObj).getArrayPrototypeNoElementsAssumption().invalidate("Array.prototype no element assumption");
        return result2;
    }

    @Override
    public boolean set(JSDynamicObject thisObj, Object key2, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        boolean result2 = super.set(thisObj, key2, value, receiver, isStrict, encapsulatingNode);
        if (JSRuntime.isArrayIndex(key2)) {
            JSObject.getJSContext(thisObj).getArrayPrototypeNoElementsAssumption().invalidate("Array.prototype no element assumption");
        }
        return result2;
    }

    @Override
    public boolean defineOwnProperty(JSDynamicObject thisObj, Object key2, PropertyDescriptor desc, boolean doThrow) {
        boolean result2 = super.defineOwnProperty(thisObj, key2, desc, doThrow);
        if (JSRuntime.isArrayIndex(key2)) {
            JSObject.getJSContext(thisObj).getArrayPrototypeNoElementsAssumption().invalidate("Array.prototype no element assumption");
        }
        return result2;
    }

    public static JSObjectPrototypeObject create(Shape shape) {
        assert (JSShape.getJSClassNoCast(shape) == INSTANCE);
        return new JSObjectPrototypeObject(shape);
    }
}

