/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public abstract class AbstractDoubleArray
extends AbstractWritableArray {
    protected AbstractDoubleArray(int integrityLevel, DynamicArray.DynamicArrayCache cache2) {
        super(integrityLevel, cache2);
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(JSDynamicObject object, int length2, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        return HolesDoubleArray.makeHolesDoubleArray(object, length2, (double[])array, indexOffset, arrayOffset, usedLength, holeCount, this.integrityLevel);
    }

    public abstract void setInBoundsFast(JSDynamicObject var1, int var2, double var3);

    @Override
    public final ScriptArray setElementImpl(JSDynamicObject object, long index, Object value, boolean strict) {
        assert (index >= 0L);
        if (CompilerDirectives.injectBranchProbability(0.9999, (value instanceof Integer || value instanceof Double) && this.isSupported(object, (int)index))) {
            double doubleValue = JSRuntime.doubleValue((Number)value);
            assert (!HolesDoubleArray.isHoleValue(doubleValue));
            this.setSupported(object, (int)index, doubleValue, null, AbstractWritableArray.SetSupportedProfileAccess.getUncached());
            return this;
        }
        return this.rewrite(object, index, value).setElementImpl(object, index, value, strict);
    }

    private ScriptArray rewrite(JSDynamicObject object, long index, Object value) {
        if (value instanceof Integer || value instanceof Double) {
            if (this.isSupportedContiguous(object, index)) {
                return this.toContiguous(object, index, value);
            }
            if (this.isSupportedHoles(object, index)) {
                return this.toHoles(object, index, value);
            }
            return this.toSparse(object, index, value);
        }
        return this.toObject(object, index, value);
    }

    @Override
    public Object getInBoundsFast(JSDynamicObject object, int index) {
        return this.getInBoundsFastDouble(object, index);
    }

    @Override
    public abstract double getInBoundsFastDouble(JSDynamicObject var1, int var2);

    @Override
    int getArrayLength(Object array) {
        return ((double[])array).length;
    }

    protected static double[] getArray(JSDynamicObject object) {
        Object array = JSAbstractArray.arrayGetArray(object);
        if (array.getClass() == double[].class) {
            return (double[])array;
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public final void setInBounds(JSDynamicObject object, int index, double value, Node node, AbstractWritableArray.SetSupportedProfileAccess profile) {
        AbstractDoubleArray.getArray((JSDynamicObject)object)[this.prepareInBounds((JSDynamicObject)object, (int)index, (Node)node, (AbstractWritableArray.SetSupportedProfileAccess)profile)] = value;
    }

    public final void setSupported(JSDynamicObject object, int index, double value, Node node, AbstractWritableArray.SetSupportedProfileAccess profile) {
        int preparedIndex = this.prepareSupported(object, index, node, profile);
        AbstractDoubleArray.getArray((JSDynamicObject)object)[preparedIndex] = value;
    }

    @Override
    void fillWithHoles(Object array, int fromIndex, int toIndex) {
        double[] doubleArray = (double[])array;
        for (int i = fromIndex; i < toIndex; ++i) {
            doubleArray[i] = HolesDoubleArray.HOLE_VALUE_DOUBLE;
        }
    }

    @Override
    protected final void setHoleValue(JSDynamicObject object, int preparedIndex) {
        AbstractDoubleArray.getArray((JSDynamicObject)object)[preparedIndex] = HolesDoubleArray.HOLE_VALUE_DOUBLE;
    }

    @Override
    protected final boolean isHolePrepared(JSDynamicObject object, int preparedIndex) {
        return HolesDoubleArray.isHoleValue(AbstractDoubleArray.getArray(object)[preparedIndex]);
    }

    @Override
    protected final int getArrayCapacity(JSDynamicObject object) {
        return AbstractDoubleArray.getArray(object).length;
    }

    @Override
    protected final void resizeArray(JSDynamicObject object, int newCapacity, int oldCapacity, int offset) {
        double[] newArray = new double[newCapacity];
        System.arraycopy(AbstractDoubleArray.getArray(object), 0, newArray, offset, oldCapacity);
        JSAbstractArray.arraySetArray(object, newArray);
    }

    @Override
    public abstract AbstractDoubleArray toHoles(JSDynamicObject var1, long var2, Object var4);

    @Override
    public final AbstractWritableArray toDouble(JSDynamicObject object, long index, double value) {
        return this;
    }

    @Override
    public ScriptArray deleteElementImpl(JSDynamicObject object, long index, boolean strict) {
        return this.toHoles(object, index, 9221120237041090561L).deleteElementImpl(object, index, strict);
    }

    @Override
    protected final void moveRangePrepared(JSDynamicObject object, int src, int dst, int len) {
        double[] array = AbstractDoubleArray.getArray(object);
        System.arraycopy(array, src, array, dst, len);
    }

    @Override
    public final Object allocateArray(int length2) {
        return new double[length2];
    }

    @Override
    public Object cloneArray(JSDynamicObject object) {
        return AbstractDoubleArray.getArray(object).clone();
    }

    @Override
    protected abstract AbstractDoubleArray withIntegrityLevel(int var1);
}

