/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;

public final class Properties {
    private static boolean validKey(Object key2) {
        return !(key2 instanceof String);
    }

    private static boolean validKeyValue(Object key2, Object value) {
        return !(key2 instanceof String) && !(value instanceof String);
    }

    public static void putWithFlags(DynamicObjectLibrary lib, DynamicObject obj, Object key2, Object value, int flags) {
        assert (Properties.validKeyValue(key2, value));
        lib.putWithFlags(obj, key2, value, flags);
    }

    public static void putWithFlagsUncached(DynamicObject obj, Object key2, Object value, int flags) {
        Properties.putWithFlags(DynamicObjectLibrary.getUncached(), obj, key2, value, flags);
    }

    public static void putConstant(DynamicObjectLibrary lib, DynamicObject obj, Object key2, Object value, int flags) {
        assert (Properties.validKeyValue(key2, value));
        lib.putConstant(obj, key2, value, flags);
    }

    public static void putConstantUncached(DynamicObject obj, Object key2, Object value, int flags) {
        Properties.putConstant(DynamicObjectLibrary.getUncached(), obj, key2, value, flags);
    }

    public static Object getOrDefault(DynamicObjectLibrary lib, DynamicObject obj, Object key2, Object defaultValue) {
        assert (Properties.validKeyValue(key2, defaultValue));
        return lib.getOrDefault(obj, key2, defaultValue);
    }

    public static Object getOrDefaultUncached(DynamicObject obj, Object key2, Object defaultValue) {
        return Properties.getOrDefault(DynamicObjectLibrary.getUncached(), obj, key2, defaultValue);
    }

    public static void put(DynamicObjectLibrary lib, DynamicObject obj, Object key2, Object value) {
        assert (Properties.validKeyValue(key2, value));
        lib.put(obj, key2, value);
    }

    public static void putUncached(DynamicObject obj, Object key2, Object value) {
        Properties.put(DynamicObjectLibrary.getUncached(), obj, key2, value);
    }

    public static boolean putIfPresent(DynamicObjectLibrary lib, DynamicObject obj, Object key2, Object value) {
        assert (Properties.validKeyValue(key2, value));
        return lib.putIfPresent(obj, key2, value);
    }

    public static boolean putIfPresentUncached(DynamicObject obj, Object key2, Object value) {
        return Properties.putIfPresent(DynamicObjectLibrary.getUncached(), obj, key2, value);
    }

    public static boolean removeKey(DynamicObjectLibrary lib, DynamicObject obj, Object key2) {
        assert (Properties.validKey(key2));
        return lib.removeKey(obj, key2);
    }

    public static boolean removeKeyUncached(DynamicObject obj, Object key2) {
        return Properties.removeKey(DynamicObjectLibrary.getUncached(), obj, key2);
    }

    public static boolean containsKey(DynamicObjectLibrary lib, DynamicObject obj, Object key2) {
        assert (Properties.validKey(key2));
        return lib.containsKey(obj, key2);
    }

    public static boolean containsKeyUncached(DynamicObject obj, Object key2) {
        return Properties.containsKey(DynamicObjectLibrary.getUncached(), obj, key2);
    }

    public static Property getProperty(DynamicObjectLibrary lib, DynamicObject obj, Object key2) {
        assert (Properties.validKey(key2));
        return lib.getProperty(obj, key2);
    }

    public static Property getPropertyUncached(DynamicObject obj, Object key2) {
        return Properties.getProperty(DynamicObjectLibrary.getUncached(), obj, key2);
    }

    public static void setPropertyFlags(DynamicObjectLibrary lib, DynamicObject obj, Object key2, int flags) {
        assert (Properties.validKey(key2));
        lib.setPropertyFlags(obj, key2, flags);
    }

    public static void setPropertyFlagsUncached(DynamicObject obj, Object key2, int flags) {
        Properties.setPropertyFlags(DynamicObjectLibrary.getUncached(), obj, key2, flags);
    }
}

