/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.JSProxyPropertyGetNodeGen;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSUncheckedProxyHandlerObject;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

@NodeInfo(cost=NodeCost.NONE)
public abstract class JSProxyPropertyGetNode
extends JavaScriptBaseNode {
    @Node.Child
    protected GetMethodNode trapGet;
    @Node.Child
    private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
    @Node.Child
    private JSGetOwnPropertyNode getOwnPropertyNode;
    @Node.Child
    private JSIdenticalNode sameValueNode;
    @Node.Child
    private ForeignObjectPrototypeNode foreignObjectPrototypeNode;

    protected JSProxyPropertyGetNode(JSContext context) {
        this.trapGet = GetMethodNode.create(context, JSProxy.GET);
    }

    @NeverDefault
    public static JSProxyPropertyGetNode create(JSContext context) {
        return JSProxyPropertyGetNodeGen.create(context);
    }

    public abstract Object executeWithReceiver(Object var1, Object var2, Object var3, Object var4);

    @Specialization
    protected Object doGeneric(JSDynamicObject proxy, Object receiver, Object key2, Object defaultValue, @Cached JSToPropertyKeyNode toPropertyKeyNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile hasTrap, @Cached JSClassProfile targetClassProfile) {
        assert (JSProxy.isJSProxy(proxy));
        assert (!(key2 instanceof HiddenKey));
        Object propertyKey = toPropertyKeyNode.execute(key2);
        JSDynamicObject handler = JSProxy.getHandler(proxy);
        if (handler == Null.instance) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorProxyRevoked(JSProxy.GET, this);
        }
        Object target = JSProxy.getTarget(proxy);
        Object trapFun = this.trapGet.executeWithTarget(handler);
        if (hasTrap.profile(this, trapFun == Undefined.instance)) {
            if (JSDynamicObject.isJSDynamicObject(target)) {
                return JSObject.getOrDefault((JSDynamicObject)target, propertyKey, receiver, defaultValue, targetClassProfile, (Node)this);
            }
            Object result2 = JSInteropUtil.readMemberOrDefault(target, propertyKey, null);
            if (result2 == null) {
                result2 = this.maybeGetFromPrototype(target, propertyKey, receiver, defaultValue, targetClassProfile);
            }
            return result2;
        }
        Object trapResult = this.callNode.executeCall(JSArguments.create(handler, trapFun, target, propertyKey, receiver));
        if (!(handler instanceof JSUncheckedProxyHandlerObject)) {
            this.checkInvariants(propertyKey, target, trapResult, errorBranch);
        }
        return trapResult;
    }

    @HostCompilerDirectives.InliningCutoff
    private Object maybeGetFromPrototype(Object target, Object propertyKey, Object receiver, Object defaultValue, JSClassProfile protoClassProfile) {
        assert (JSRuntime.isPropertyKey(propertyKey));
        if (this.getLanguage().getJSContext().getContextOptions().hasForeignObjectPrototype()) {
            if (this.foreignObjectPrototypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.foreignObjectPrototypeNode = this.insert(ForeignObjectPrototypeNode.create());
            }
            JSDynamicObject prototype = this.foreignObjectPrototypeNode.execute(target);
            return JSObject.getOrDefault(prototype, propertyKey, receiver, defaultValue, protoClassProfile, (Node)this);
        }
        return defaultValue;
    }

    private void checkInvariants(Object propertyKey, Object proxyTarget, Object trapResult, @Cached InlinedBranchProfile errorBranch) {
        assert (JSRuntime.isPropertyKey(propertyKey));
        if (!JSDynamicObject.isJSDynamicObject(proxyTarget)) {
            return;
        }
        PropertyDescriptor targetDesc = this.getOwnProperty((JSDynamicObject)proxyTarget, propertyKey);
        if (targetDesc != null) {
            Object targetValue;
            if (targetDesc.isDataDescriptor() && !targetDesc.getConfigurable() && !targetDesc.getWritable() && !this.isSameValue(trapResult, targetValue = targetDesc.getValue())) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorProxyGetInvariantViolated(propertyKey, targetValue, trapResult);
            }
            if (targetDesc.isAccessorDescriptor() && !targetDesc.getConfigurable() && targetDesc.getGet() == Undefined.instance && trapResult != Undefined.instance) {
                errorBranch.enter(this);
                throw Errors.createTypeError("Trap result must be undefined since the proxy target has a corresponding non-configurable own accessor property with undefined getter");
            }
        }
    }

    private boolean isSameValue(Object trapResult, Object value) {
        if (this.sameValueNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.sameValueNode = this.insert(JSIdenticalNode.createSameValue());
        }
        return this.sameValueNode.executeBoolean(trapResult, value);
    }

    private PropertyDescriptor getOwnProperty(JSDynamicObject target, Object propertyKey) {
        if (this.getOwnPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getOwnPropertyNode = this.insert(JSGetOwnPropertyNode.create());
        }
        return this.getOwnPropertyNode.execute(target, propertyKey);
    }
}

