/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class JSONHelper {
    private JSONHelper() {
    }

    private static String quote(CharSequence value) {
        StringBuilder builder2 = new StringBuilder(value.length() + 2);
        builder2.append('\"');
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    builder2.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    builder2.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    builder2.append("\\b");
                    continue block9;
                }
                case '\f': {
                    builder2.append("\\f");
                    continue block9;
                }
                case '\n': {
                    builder2.append("\\n");
                    continue block9;
                }
                case '\r': {
                    builder2.append("\\r");
                    continue block9;
                }
                case '\t': {
                    builder2.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        builder2.append("\\u00");
                        builder2.append(Character.forDigit(c >> 4 & 0xF, 16));
                        builder2.append(Character.forDigit(c & 0xF, 16));
                        continue block9;
                    }
                    builder2.append(c);
                }
            }
        }
        builder2.append('\"');
        return builder2.toString();
    }

    public static JSONObjectBuilder object() {
        return new JSONObjectBuilder();
    }

    public static JSONArrayBuilder array() {
        return new JSONArrayBuilder();
    }

    public static final class JSONObjectBuilder
    extends JSONStringBuilder {
        private final Map<String, Object> contents = new LinkedHashMap<String, Object>();

        private JSONObjectBuilder() {
        }

        public JSONObjectBuilder add(String key2, String value) {
            this.contents.put(key2, value);
            return this;
        }

        public JSONObjectBuilder add(String key2, Number value) {
            this.contents.put(key2, value);
            return this;
        }

        public JSONObjectBuilder add(String key2, Boolean value) {
            this.contents.put(key2, value);
            return this;
        }

        public JSONObjectBuilder add(String key2, JSONStringBuilder value) {
            this.contents.put(key2, value);
            return this;
        }

        @Override
        protected void appendTo(StringBuilder sb) {
            sb.append("{");
            boolean comma = false;
            for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
                if (comma) {
                    sb.append(", ");
                }
                sb.append(JSONHelper.quote(entry.getKey()));
                sb.append(": ");
                JSONObjectBuilder.appendValue(sb, entry.getValue());
                comma = true;
            }
            sb.append("}");
        }
    }

    public static final class JSONArrayBuilder
    extends JSONStringBuilder {
        private final List<Object> contents = new ArrayList<Object>();

        private JSONArrayBuilder() {
        }

        public JSONArrayBuilder add(String value) {
            this.contents.add(value);
            return this;
        }

        public JSONArrayBuilder add(Number value) {
            this.contents.add(value);
            return this;
        }

        public JSONArrayBuilder add(Boolean value) {
            this.contents.add(value);
            return this;
        }

        public JSONArrayBuilder add(JSONStringBuilder value) {
            this.contents.add(value);
            return this;
        }

        @Override
        protected void appendTo(StringBuilder sb) {
            sb.append("[");
            boolean comma = false;
            for (Object value : this.contents) {
                if (comma) {
                    sb.append(", ");
                }
                JSONArrayBuilder.appendValue(sb, value);
                comma = true;
            }
            sb.append("]");
        }
    }

    public static abstract class JSONStringBuilder {
        private JSONStringBuilder() {
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }

        protected abstract void appendTo(StringBuilder var1);

        protected static void appendValue(StringBuilder sb, Object value) {
            if (value instanceof JSONStringBuilder) {
                ((JSONStringBuilder)value).appendTo(sb);
            } else if (value instanceof Integer || value instanceof Boolean || value == null) {
                sb.append(value);
            } else {
                sb.append(JSONHelper.quote(String.valueOf(value)));
            }
        }
    }
}

