/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;

@ExportLibrary(value=ReflectionLibrary.class, receiverType=Object.class)
final class ReflectionLibraryDefault {
    static final int LIMIT = 8;

    ReflectionLibraryDefault() {
    }

    @ExportMessage
    static class Send {
        Send() {
        }

        @Specialization(guards={"message == cachedMessage", "cachedLibrary.accepts(receiver)"}, limit="LIMIT")
        static Object doSendCached(Object receiver, Message message2, Object[] args, @Cached(value="message") Message cachedMessage, @Cached(value="createLibrary(message, receiver)") Library cachedLibrary) throws Exception {
            return cachedMessage.getFactory().genericDispatch(cachedLibrary, receiver, cachedMessage, args, 0);
        }

        static Library createLibrary(Message message2, Object receiver) {
            return message2.getFactory().create(receiver);
        }

        @Specialization(replaces={"doSendCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doSendGeneric(Object receiver, Message message2, Object[] args) throws Exception {
            LibraryFactory<?> lib = message2.getFactory();
            return lib.genericDispatch((Library)lib.getUncached(receiver), receiver, message2, args, 0);
        }
    }
}

