/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.exception.DefaultStackTraceElementObject;
import com.oracle.truffle.api.exception.HostStackTraceElementObject;
import com.oracle.truffle.api.exception.InteropList;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class ExceptionAccessor
extends Accessor {
    static final ExceptionAccessor ACCESSOR = new ExceptionAccessor();

    private ExceptionAccessor() {
    }

    static final class ExceptionSupportImpl
    extends Accessor.ExceptionSupport {
        ExceptionSupportImpl() {
        }

        @Override
        public Throwable getLazyStackTrace(Throwable exception) {
            return ((AbstractTruffleException)exception).getLazyStackTrace();
        }

        @Override
        public void setLazyStackTrace(Throwable exception, Throwable stackTrace) {
            ((AbstractTruffleException)exception).setLazyStackTrace(stackTrace);
        }

        @Override
        public Object createDefaultStackTraceElementObject(RootNode rootNode, SourceSection sourceSection) {
            return new DefaultStackTraceElementObject(rootNode, sourceSection);
        }

        @Override
        public boolean isException(Object receiver) {
            return receiver instanceof AbstractTruffleException;
        }

        @Override
        public RuntimeException throwException(Object receiver) {
            throw (AbstractTruffleException)receiver;
        }

        @Override
        public Object getExceptionType(Object receiver) {
            return ExceptionType.RUNTIME_ERROR;
        }

        @Override
        public boolean isExceptionIncompleteSource(Object receiver) {
            return false;
        }

        @Override
        public int getExceptionExitStatus(Object receiver) {
            throw ExceptionSupportImpl.throwUnsupportedMessageException();
        }

        @Override
        public boolean hasExceptionCause(Object receiver) {
            return this.isException(((AbstractTruffleException)receiver).getCause());
        }

        @Override
        public Object getExceptionCause(Object receiver) {
            Throwable throwable = ((AbstractTruffleException)receiver).getCause();
            if (this.isException(throwable)) {
                return throwable;
            }
            throw ExceptionSupportImpl.throwUnsupportedMessageException();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasExceptionMessage(Object receiver) {
            return ((AbstractTruffleException)receiver).getMessage() != null;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getExceptionMessage(Object receiver) {
            String message2 = ((AbstractTruffleException)receiver).getMessage();
            if (message2 == null) {
                throw ExceptionSupportImpl.throwUnsupportedMessageException();
            }
            return message2;
        }

        @Override
        public boolean hasExceptionStackTrace(Object receiver) {
            return true;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getExceptionStackTrace(Object receiver, Object polyglotContext) {
            Object[] items;
            Throwable throwable = (Throwable)receiver;
            List<TruffleStackTraceElement> stack = TruffleStackTrace.getStackTrace(throwable);
            if (stack == null) {
                stack = Collections.emptyList();
            }
            boolean hasGuestToHostCalls = false;
            boolean inHost = true;
            for (TruffleStackTraceElement element : stack) {
                if (ACCESSOR.hostSupport().isGuestToHostRootNode(element.getTarget().getRootNode())) {
                    hasGuestToHostCalls = true;
                    break;
                }
                inHost = false;
            }
            if (hasGuestToHostCalls) {
                Object polyglotEngine = polyglotContext == null ? ACCESSOR.engineSupport().getCurrentPolyglotEngine() : ACCESSOR.engineSupport().getEngineFromPolyglotObject(polyglotContext);
                items = ExceptionSupportImpl.mergeHostGuestFrames(throwable, stack, inHost, polyglotEngine);
            } else {
                items = new Object[stack.size()];
                for (int i = 0; i < items.length; ++i) {
                    items[i] = stack.get(i).getGuestObject();
                }
            }
            return new InteropList(items);
        }

        private static Object[] mergeHostGuestFrames(Throwable throwable, List<TruffleStackTraceElement> guestStack, boolean inHost, Object polyglotEngine) {
            StackTraceElement[] hostStack = null;
            AbstractPolyglotImpl.AbstractHostLanguageService hostService = ACCESSOR.engineSupport().getHostService(polyglotEngine);
            if (hostService.isHostException(throwable)) {
                Throwable original = hostService.unboxHostException(throwable);
                hostStack = original.getStackTrace();
            } else if (throwable instanceof AbstractTruffleException) {
                Throwable lazyStackTrace = ((AbstractTruffleException)throwable).getLazyStackTrace();
                if (lazyStackTrace != null) {
                    hostStack = ACCESSOR.languageSupport().getInternalStackTraceElements(lazyStackTrace);
                }
            } else {
                hostStack = throwable.getStackTrace();
            }
            if (hostStack == null) {
                hostStack = new StackTraceElement[]{};
            }
            final ListIterator<TruffleStackTraceElement> guestStackIterator = guestStack.listIterator();
            final boolean includeHostFrames = ACCESSOR.engineSupport().getHostService(polyglotEngine).isHostStackTraceVisibleToGuest();
            final int lastGuestToHostIndex = includeHostFrames ? ExceptionSupportImpl.indexOfLastGuestToHostFrame(guestStack) : -1;
            Iterator<Object> mergedElements = ACCESSOR.engineSupport().mergeHostGuestFrames(polyglotEngine, hostStack, guestStackIterator, inHost, includeHostFrames, new Function<StackTraceElement, Object>(){

                @Override
                public Object apply(StackTraceElement element) {
                    assert (includeHostFrames);
                    if (!guestStackIterator.hasNext()) {
                        return null;
                    }
                    if (guestStackIterator.nextIndex() > lastGuestToHostIndex) {
                        return null;
                    }
                    return new HostStackTraceElementObject(element);
                }
            }, new Function<TruffleStackTraceElement, Object>(){

                @Override
                public Object apply(TruffleStackTraceElement element) {
                    RootNode rootNode = element.getTarget().getRootNode();
                    if (ACCESSOR.hostSupport().isGuestToHostRootNode(rootNode)) {
                        return null;
                    }
                    if (ACCESSOR.engineSupport().isHostToGuestRootNode(rootNode)) {
                        return null;
                    }
                    return element.getGuestObject();
                }
            });
            ArrayList<Object> elementsList = new ArrayList<Object>();
            while (mergedElements.hasNext()) {
                elementsList.add(mergedElements.next());
            }
            return elementsList.toArray();
        }

        private static int indexOfLastGuestToHostFrame(List<TruffleStackTraceElement> guestStack) {
            ListIterator<TruffleStackTraceElement> iterator = guestStack.listIterator(guestStack.size());
            while (iterator.hasPrevious()) {
                int index = iterator.previousIndex();
                TruffleStackTraceElement element = iterator.previous();
                if (!ACCESSOR.hostSupport().isGuestToHostRootNode(element.getTarget().getRootNode())) continue;
                return index;
            }
            return -1;
        }

        @Override
        public boolean hasSourceLocation(Object receiver) {
            Node location = ((AbstractTruffleException)receiver).getLocation();
            return location != null && location.getEncapsulatingSourceSection() != null;
        }

        @Override
        public SourceSection getSourceLocation(Object receiver) {
            SourceSection sourceSection;
            Node location = ((AbstractTruffleException)receiver).getLocation();
            SourceSection sourceSection2 = sourceSection = location != null ? location.getEncapsulatingSourceSection() : null;
            if (sourceSection == null) {
                throw ExceptionSupportImpl.throwUnsupportedMessageException();
            }
            return sourceSection;
        }

        @Override
        public int getStackTraceElementLimit(Object receiver) {
            return ((AbstractTruffleException)receiver).getStackTraceElementLimit();
        }

        @Override
        public Node getLocation(Object receiver) {
            return ((AbstractTruffleException)receiver).getLocation();
        }

        @Override
        public boolean assertGuestObject(Object guestObject) {
            if (guestObject == null) {
                throw new AssertionError((Object)"Guest object must be null.");
            }
            InteropLibrary interop = InteropLibrary.getUncached();
            if (interop.hasExecutableName(guestObject)) {
                Object executableName;
                try {
                    executableName = interop.getExecutableName(guestObject);
                }
                catch (UnsupportedMessageException um) {
                    throw new AssertionError("Failed to get the executable name.", um);
                }
                if (!interop.isString(executableName)) {
                    throw new AssertionError((Object)"Executable name must be an interop string.");
                }
            }
            if (interop.hasDeclaringMetaObject(guestObject)) {
                Object metaObject;
                try {
                    metaObject = interop.getDeclaringMetaObject(guestObject);
                }
                catch (UnsupportedMessageException um) {
                    throw new AssertionError("Failed to get the declaring meta object.", um);
                }
                if (!interop.isMetaObject(metaObject)) {
                    throw new AssertionError((Object)"Declaring meta object must be an interop meta object");
                }
            }
            return true;
        }

        private static RuntimeException throwUnsupportedMessageException() {
            throw ExceptionSupportImpl.silenceException(RuntimeException.class, UnsupportedMessageException.create());
        }

        private static <E extends Throwable> E silenceException(Class<E> type, Throwable ex) throws E {
            throw ex;
        }
    }
}

