/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.cache;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.cache.Cache;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class LRUCache
implements Cache {
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, JsonPath> map = new ConcurrentHashMap<String, JsonPath>();
    private final Deque<String> queue = new LinkedList<String>();
    private final int limit;

    public LRUCache(int limit) {
        this.limit = limit;
    }

    @Override
    public void put(String key2, JsonPath value) {
        JsonPath oldValue = this.map.put(key2, value);
        if (oldValue != null) {
            this.removeThenAddKey(key2);
        } else {
            this.addKey(key2);
        }
        if (this.map.size() > this.limit) {
            this.map.remove(this.removeLast());
        }
    }

    @Override
    public JsonPath get(String key2) {
        JsonPath jsonPath = this.map.get(key2);
        if (jsonPath != null) {
            this.removeThenAddKey(key2);
        }
        return jsonPath;
    }

    private void addKey(String key2) {
        this.lock.lock();
        try {
            this.queue.addFirst(key2);
        }
        finally {
            this.lock.unlock();
        }
    }

    private String removeLast() {
        this.lock.lock();
        try {
            String removedKey;
            String string = removedKey = this.queue.removeLast();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeThenAddKey(String key2) {
        this.lock.lock();
        try {
            this.queue.removeFirstOccurrence(key2);
            this.queue.addFirst(key2);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeFirstOccurrence(String key2) {
        this.lock.lock();
        try {
            this.queue.removeFirstOccurrence(key2);
        }
        finally {
            this.lock.unlock();
        }
    }

    public JsonPath getSilent(String key2) {
        return this.map.get(key2);
    }

    public void remove(String key2) {
        this.removeFirstOccurrence(key2);
        this.map.remove(key2);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }
}

