/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.httpClient.postman.PostmanMapperKt;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanPath;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanPathItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/postman/converter/deserialization/PostmanPathDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanPath;", "()V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nPostmanUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostmanUrl.kt\ncom/intellij/httpClient/postman/converter/deserialization/PostmanPathDeserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,74:1\n55#2:75\n43#2:76\n*S KotlinDebug\n*F\n+ 1 PostmanUrl.kt\ncom/intellij/httpClient/postman/converter/deserialization/PostmanPathDeserializer\n*L\n59#1:75\n59#1:76\n*E\n"})
public final class PostmanPathDeserializer
extends JsonDeserializer<PostmanPath> {
    @Nullable
    public PostmanPath deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
        PostmanPath postmanPath;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonNode jsonNode = (JsonNode)parser.getCodec().readTree(parser);
        if (jsonNode == null) {
            return null;
        }
        JsonNode node = jsonNode;
        if (node.isTextual()) {
            String string = node.textValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
            postmanPath = new PostmanPath.PathString(string);
        } else if (node.isArray()) {
            ObjectMapper $this$treeToValue$iv = PostmanMapperKt.getPostmanMapper();
            boolean $i$f$treeToValue = false;
            boolean $i$f$jacksonTypeRef = false;
            postmanPath = new PostmanPath.PathObject((List)$this$treeToValue$iv.readValue($this$treeToValue$iv.treeAsTokens((TreeNode)node), (TypeReference)new TypeReference<List<? extends PostmanPathItem>>(){}));
        } else {
            postmanPath = null;
        }
        return postmanPath;
    }
}

