/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.httpClient.postman.PostmanMapperKt;
import com.intellij.httpClient.postman.converter.FileType;
import com.intellij.httpClient.postman.converter.PostmanCollectionConverterKt;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0001\u001a\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"COLLECTION_SUFFIX", "", "ENVIRONMENT_SUFFIX", "GIST_VERSION", "", "POSTMAN_CONVERTER_GIST_KEY", "externalizer", "Lcom/intellij/util/io/DataExternalizer;", "Lcom/intellij/httpClient/postman/converter/FileType;", "gist", "Lcom/intellij/util/gist/VirtualFileGist;", "isPostmanCollectionFile", "", "tree", "Lcom/fasterxml/jackson/databind/JsonNode;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isPostmanEnvironmentFile", "isPostmanFile", "parseToTree", "virtualFile", "retrieveType", "intellij.restClient"})
public final class PostmanFileCheckerKt {
    @NotNull
    public static final String COLLECTION_SUFFIX = ".postman_collection";
    @NotNull
    public static final String ENVIRONMENT_SUFFIX = ".postman_environment";
    @NotNull
    private static final String POSTMAN_CONVERTER_GIST_KEY = "com.intellij.httpClient.postman.converter.gist.key";
    private static final int GIST_VERSION = 2;
    @NotNull
    private static final DataExternalizer<FileType> externalizer = (DataExternalizer)new DataExternalizer<FileType>(){

        public void save(@NotNull DataOutput dataOutput, @Nullable FileType fileType) {
            Intrinsics.checkNotNullParameter((Object)dataOutput, (String)"dataOutput");
            String string = PostmanMapperKt.getPostmanMapper().writeValueAsString((Object)((Object)fileType));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            dataOutput.write(byArray);
        }

        @NotNull
        public FileType read(@NotNull DataInput dataInput) {
            Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
            Object object = PostmanMapperKt.getPostmanMapper().readValue(dataInput, FileType.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            return (FileType)((Object)object);
        }
    };
    @NotNull
    private static final VirtualFileGist<FileType> gist;

    private static final FileType retrieveType(VirtualFile file) {
        JsonNode jsonNode = PostmanFileCheckerKt.parseToTree(file);
        if (jsonNode == null) {
            return FileType.OTHER;
        }
        JsonNode tree = jsonNode;
        JsonNode jsonNode2 = tree.get("_postman_variable_scope");
        return Intrinsics.areEqual((Object)(jsonNode2 != null ? jsonNode2.textValue() : null), (Object)"environment") ? FileType.POSTMAN_ENVIRONMENT : (PostmanFileCheckerKt.isPostmanCollectionFile(tree) ? FileType.POSTMAN_COLLECTION : FileType.OTHER);
    }

    private static final boolean isPostmanCollectionFile(JsonNode tree) {
        JsonNode jsonNode = tree.get("info");
        if (jsonNode == null) {
            return false;
        }
        JsonNode info = jsonNode;
        if (info.get("_postman_id") != null) {
            return true;
        }
        JsonNode jsonNode2 = info.get("schema");
        String string = jsonNode2 != null ? jsonNode2.textValue() : null;
        if (string == null) {
            return false;
        }
        String schema = string;
        return StringsKt.contains((CharSequence)schema, (CharSequence)"postman", (boolean)true);
    }

    @RequiresReadLock
    public static final boolean isPostmanCollectionFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)COLLECTION_SUFFIX, (boolean)false, (int)2, null)) {
            return true;
        }
        return gist.getFileData(project, file) == FileType.POSTMAN_COLLECTION;
    }

    public static final boolean isPostmanEnvironmentFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)ENVIRONMENT_SUFFIX, (boolean)false, (int)2, null)) {
            return true;
        }
        return gist.getFileData(project, file) == FileType.POSTMAN_ENVIRONMENT;
    }

    private static final JsonNode parseToTree(VirtualFile virtualFile) {
        JsonNode jsonNode;
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile)) {
            PostmanCollectionConverterKt.getPostmanConverterLogger().warning("File size is too big " + virtualFile.getName() + ", could not parse to json");
            return null;
        }
        try {
            jsonNode = PostmanMapperKt.getPostmanMapper().readTree(VfsUtil.loadText((VirtualFile)virtualFile));
        }
        catch (Exception e) {
            PostmanCollectionConverterKt.getPostmanConverterLogger().warning("Could not parse file " + virtualFile.getName() + " to tree: " + e);
            jsonNode = null;
        }
        return jsonNode;
    }

    public static final boolean isPostmanFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return PostmanFileCheckerKt.isPostmanCollectionFile(project, file) || PostmanFileCheckerKt.isPostmanEnvironmentFile(project, file);
    }

    private static final FileType gist$lambda$0(Project project, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)JsonFileType.INSTANCE)) {
            return null;
        }
        return PostmanFileCheckerKt.retrieveType(file);
    }

    static {
        VirtualFileGist virtualFileGist = GistManager.getInstance().newVirtualFileGist(POSTMAN_CONVERTER_GIST_KEY, 2, externalizer, PostmanFileCheckerKt::gist$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileGist, (String)"newVirtualFileGist(...)");
        gist = virtualFileGist;
    }
}

