/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.variables;

import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.psi.HttpFileVariable;
import com.intellij.httpClient.http.request.variables.HttpClientFileVariableStorage;
import com.intellij.psi.PsiFile;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0003\f\r\u000eJ\b\u0010\u0002\u001a\u00020\u0000H&J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nH&\u0082\u0001\u0002\u000f\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider;", "", "clone", "getFileVariableValue", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "name", "", "unambiguous", "", "valueComputer", "Lkotlin/Function1;", "Lcom/intellij/httpClient/http/request/psi/HttpFileVariable;", "Empty", "FileBased", "Value", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Empty;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$FileBased;", "intellij.httpClient.executor"})
public interface HttpFileVariablesProvider {
    @NotNull
    public Value getFileVariableValue(@NotNull String var1, boolean var2, @NotNull Function1<? super HttpFileVariable, String> var3);

    @NotNull
    public HttpFileVariablesProvider clone();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0001H\u0016J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Empty;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider;", "()V", "clone", "getFileVariableValue", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "name", "", "unambiguous", "", "valueComputer", "Lkotlin/Function1;", "Lcom/intellij/httpClient/http/request/psi/HttpFileVariable;", "intellij.httpClient.executor"})
    public static final class Empty
    implements HttpFileVariablesProvider {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        @NotNull
        public Value getFileVariableValue(@NotNull String name, boolean unambiguous, @NotNull Function1<? super HttpFileVariable, String> valueComputer) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(valueComputer, (String)"valueComputer");
            return Value.None.INSTANCE;
        }

        @Override
        @NotNull
        public HttpFileVariablesProvider clone() {
            return INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0001H\u0016J,\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$FileBased;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider;", "file", "Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;", "(Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;)V", "computedValues", "", "", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "clone", "getFileVariableValue", "name", "unambiguous", "", "valueComputer", "Lkotlin/Function1;", "Lcom/intellij/httpClient/http/request/psi/HttpFileVariable;", "intellij.httpClient.executor"})
    public static final class FileBased
    implements HttpFileVariablesProvider {
        @NotNull
        private final HttpRequestPsiFile file;
        @NotNull
        private final Map<String, Value> computedValues;

        public FileBased(@NotNull HttpRequestPsiFile file) {
            Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
            this.file = file;
            this.computedValues = new LinkedHashMap();
        }

        @Override
        @NotNull
        public Value getFileVariableValue(@NotNull String name, boolean unambiguous, @NotNull Function1<? super HttpFileVariable, String> valueComputer) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(valueComputer, (String)"valueComputer");
            if (this.computedValues.containsKey(name)) {
                Value value = this.computedValues.get(name);
                Intrinsics.checkNotNull((Object)value);
                return value;
            }
            List<HttpFileVariable> variables2 = HttpClientFileVariableStorage.Companion.findVariableIn((PsiFile)this.file, name);
            if (variables2.size() > 1 && unambiguous) {
                this.computedValues.put(name, Value.Ambiguous.INSTANCE);
                return Value.Ambiguous.INSTANCE;
            }
            HttpFileVariable variable2 = (HttpFileVariable)CollectionsKt.firstOrNull(variables2);
            if (variable2 == null) {
                this.computedValues.put(name, Value.None.INSTANCE);
                return Value.None.INSTANCE;
            }
            this.computedValues.put(name, Value.InProgress.INSTANCE);
            Value.Computed value = new Value.Computed((String)valueComputer.invoke((Object)variable2));
            this.computedValues.put(name, value);
            return value;
        }

        @Override
        @NotNull
        public HttpFileVariablesProvider clone() {
            return new FileBased(this.file);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "", "Ambiguous", "Computed", "InProgress", "None", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$Ambiguous;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$Computed;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$InProgress;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$None;", "intellij.httpClient.executor"})
    public static interface Value {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$Ambiguous;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "()V", "intellij.httpClient.executor"})
        public static final class Ambiguous
        implements Value {
            @NotNull
            public static final Ambiguous INSTANCE = new Ambiguous();

            private Ambiguous() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$Computed;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "intellij.httpClient.executor"})
        public static final class Computed
        implements Value {
            @NotNull
            private final String value;

            public Computed(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$InProgress;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "()V", "intellij.httpClient.executor"})
        public static final class InProgress
        implements Value {
            @NotNull
            public static final InProgress INSTANCE = new InProgress();

            private InProgress() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$None;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "()V", "intellij.httpClient.executor"})
        public static final class None
        implements Value {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
            }
        }
    }
}

