/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.test;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.authentication.AuthFlowLogEntry;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.httpClient.http.request.run.HttpRequestResponseFileResult;
import com.intellij.httpClient.http.request.run.console.HttpRequestErrorFileFilter;
import com.intellij.httpClient.http.request.run.console.HttpRequestErrorFixFilter;
import com.intellij.httpClient.http.request.run.console.HttpResponseConsole;
import com.intellij.httpClient.http.request.run.console.HttpResponseFileFilter;
import com.intellij.httpClient.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.httpClient.http.request.run.console.HttpResponsePresentation;
import com.intellij.httpClient.http.request.run.test.HttpClientTestLocations;
import com.intellij.httpClient.http.request.run.test.HttpClientTestLocator;
import com.intellij.httpClient.http.request.run.test.HttpClientTestUtil;
import com.intellij.httpClient.http.request.run.test.HttpClientTestViewInfo;
import com.intellij.httpClient.http.request.run.test.HttpMultipleResponseAuthPrintingKt;
import com.intellij.httpClient.http.request.run.test.HttpResponseTestAdapter;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpMultiResponseConsole
implements HttpResponseConsole {
    private static final String RESPONSE_GROUP_NAME = "Response";
    private static final Predicate<FileType> ALWAYS_TRUE = type -> true;
    static final BooleanProperty SHOW_REQUEST_METHOD = new BooleanProperty("showRequestMethod", true);
    private final Project myProject;
    private final HttpClientRequestProcessHandler myHandler;
    private final SMTRunnerConsoleView myConsole;
    private final HttpResponseOutputAdapter myResponsePrinter;
    private final Map<String, HttpResponsePresentation> myRequestResults;
    @Nullable
    private Runnable myOnFinishedRunnable;
    private final boolean myShowRequestMethods;
    private final RequestFinishedQueue myRequestFinishedQueue;

    public HttpMultiResponseConsole(@NotNull Project project, final @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpClientRequestProcessHandler handler) {
        if (project == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(2);
        }
        this.myRequestResults = new HashMap<String, HttpResponsePresentation>();
        this.myRequestFinishedQueue = new RequestFinishedQueue();
        this.myProject = project;
        this.myHandler = handler;
        class MyProperties
        extends SMTRunnerConsoleProperties
        implements SMCustomMessagesParsing {
            MyProperties() {
                super(sMTRunnerConsoleProperties.getProject(), sMTRunnerConsoleProperties.getConfiguration(), sMTRunnerConsoleProperties.getTestFrameworkName(), sMTRunnerConsoleProperties.getExecutor());
            }

            public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
                if (testFrameworkName == null) {
                    MyProperties.$$$reportNull$$$0(0);
                }
                if (consoleProperties == null) {
                    MyProperties.$$$reportNull$$$0(1);
                }
                return new OutputToGeneralTestEventsConverter(testFrameworkName, true, false, !this.isIdBasedTestTree());
            }

            public void appendAdditionalActions(DefaultActionGroup actionGroup, JComponent parent, TestConsoleProperties target) {
                super.appendAdditionalActions(actionGroup, parent, target);
                actionGroup.add((AnAction)new Separator());
                actionGroup.add((AnAction)new ToggleAction(RestClientBundle.message("http.request.show.request.methods.toggle.text", new Object[0])){

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                        if (actionUpdateThread == null) {
                            1MyProperties.1.$$$reportNull$$$0(0);
                        }
                        return actionUpdateThread;
                    }

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1MyProperties.1.$$$reportNull$$$0(1);
                        }
                        return SHOW_REQUEST_METHOD.value((AbstractProperty.AbstractPropertyContainer)this);
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        if (e == null) {
                            1MyProperties.1.$$$reportNull$$$0(2);
                        }
                        SHOW_REQUEST_METHOD.set((AbstractProperty.AbstractPropertyContainer)this, (Object)state);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 1, 2 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/httpClient/http/request/run/test/HttpMultiResponseConsole$1MyProperties$1";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getActionUpdateThread";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/httpClient/http/request/run/test/HttpMultiResponseConsole$1MyProperties$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "isSelected";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "setSelected";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 1, 2 -> new IllegalArgumentException(string);
                        };
                    }
                });
            }

            @Nullable
            public SMTestLocator getTestLocator() {
                return new HttpClientTestLocator();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "testFrameworkName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "consoleProperties";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/httpClient/http/request/run/test/HttpMultiResponseConsole$1MyProperties";
                objectArray[2] = "createTestEventsConverter";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        MyProperties myProperties = new MyProperties();
        TestConsoleProperties.HIDE_PASSED_TESTS.set((AbstractProperty.AbstractPropertyContainer)myProperties, (Object)false);
        this.myConsole = SMTestRunnerConnectionUtil.createConsole((SMTRunnerConsoleProperties)myProperties);
        this.myConsole.attachToProcess((ProcessHandler)handler);
        this.myConsole.getResultsViewer().getTestsRootNode().setPresentation(RestClientBundle.message("rest.client.request.run.test.console.root", new Object[0]));
        this.myResponsePrinter = HttpResponseOutputAdapter.createTest(handler, HttpClientTestViewInfo.create(this.myConsole.getResultsViewer(), this.myConsole.getConsole()));
        this.myResponsePrinter.print("\n");
        this.myShowRequestMethods = SHOW_REQUEST_METHOD.value((AbstractProperty.AbstractPropertyContainer)myProperties);
        this.myHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                HttpMultiResponseConsole.this.myConsole.getResultsViewer().selectAndNotify(HttpMultiResponseConsole.this.myConsole.getResultsViewer().getRoot());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/httpClient/http/request/run/test/HttpMultiResponseConsole$1", "processTerminated"));
            }
        });
    }

    @Override
    public void lateInitialize() {
        HttpRequestHistoryManager.getInstance(this.myProject).ensureLogFileExists();
        this.myConsole.addMessageFilter((Filter)new HttpResponseFileFilter(this.myProject));
        this.myConsole.addMessageFilter((Filter)HttpRequestErrorFileFilter.getInstance(this.myProject));
        this.myConsole.addMessageFilter((Filter)new HttpRequestErrorFixFilter());
    }

    @Override
    public void notifyAboutAuthorization(@NotNull List<AuthFlowLogEntry> authFlowLogEntries) {
        if (authFlowLogEntries == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(3);
        }
        HttpMultipleResponseAuthPrintingKt.printAuthLogAsTests(this.myProject, this.myResponsePrinter, authFlowLogEntries);
    }

    @Override
    public void onRequestStart(@NotNull String id, int size, @NotNull SmartPsiElementPointer<HttpRequest> request2) {
        if (id == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(4);
        }
        if (request2 == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(5);
        }
        this.assertStarted();
        String location = HttpClientTestLocations.getRequestLocationHint(request2);
        this.myRequestFinishedQueue.clear();
        HttpClientTestUtil.printSuiteStart(this.myResponsePrinter, id, size, location);
    }

    @Override
    public void onRequestEnd(@NotNull String id) {
        if (id == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(6);
        }
        this.myResponsePrinter.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        this.myRequestFinishedQueue.flush();
        this.myResponsePrinter.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        HttpClientTestUtil.printSuiteEnd(this.myResponsePrinter, id);
    }

    @Override
    public void onRequestIgnored(@NotNull String id, @Nullable String message2) {
        if (id == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(7);
        }
        this.assertStarted();
        this.myResponsePrinter.printStart(id);
        HttpClientTestUtil.printTestIgnored(this.myResponsePrinter, id, message2);
        this.myResponsePrinter.printEnd(id, 0L);
    }

    private void assertStarted() {
        HttpResponseTestAdapter.LOG.assertTrue(this.myHandler.isStartNotified(), (Object)"This method must be used only for started process. Use `HttpClientRequestProcessHandler.getStartDeferred`");
    }

    @Override
    public void setOnFinishPrintingCallback(@Nullable Runnable onFinishedPrinting) {
        this.myOnFinishedRunnable = onFinishedPrinting;
    }

    @Override
    public void setResponse(@NotNull String id, @NotNull HttpResponsePresentation response2, @Nullable FileType fileType) {
        if (id == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(8);
        }
        if (response2 == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(9);
        }
        this.myRequestResults.put(id, response2);
        this.myResponsePrinter.printStart(HttpMultiResponseConsole.toRequestTestName(id));
    }

    @Override
    public void setErrorResponse(@Nullable String id, @NotNull HttpResponsePresentation response2) {
        if (response2 == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(10);
        }
        if (StringUtil.isNotEmpty((String)id)) {
            this.setResponse(id, response2, (FileType)PlainTextFileType.INSTANCE);
        }
        response2.print(this.myProject, this.myResponsePrinter, null, (FileType)PlainTextFileType.INSTANCE, ALWAYS_TRUE, null, this.myOnFinishedRunnable);
        if (id != null) {
            this.myResponsePrinter.printEnd(HttpMultiResponseConsole.toRequestTestName(id), 0L);
        }
    }

    @Override
    public void onResponseFileCreated(@NotNull String id, @Nullable HttpRequestResponseFileResult responseFile) {
        if (id == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(11);
        }
        if (this.myRequestResults.containsKey(id)) {
            HttpResponsePresentation presentation2 = this.myRequestResults.remove(id);
            presentation2.print(this.myProject, this.myResponsePrinter, responseFile, (FileType)PlainTextFileType.INSTANCE, ALWAYS_TRUE, null, () -> {
                this.myResponsePrinter.printEnd(HttpMultiResponseConsole.toRequestTestName(id), presentation2.getExecutionTime());
                if (this.myOnFinishedRunnable != null) {
                    this.myOnFinishedRunnable.run();
                }
            });
            this.myResponsePrinter.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    private static String toRequestTestName(@NotNull String url) {
        if (url == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(12);
        }
        return StringUtil.notNullize((String)url) + ".Response";
    }

    @Override
    @NotNull
    public ConsoleView getConsole() {
        SMTRunnerConsoleView sMTRunnerConsoleView = this.myConsole;
        if (sMTRunnerConsoleView == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(13);
        }
        return sMTRunnerConsoleView;
    }

    @Override
    public HttpResponseOutputAdapter getResponseHandlerPrinter() {
        return this.myResponsePrinter.delayedIfNeeded(this.myRequestFinishedQueue::add);
    }

    @Override
    @NotNull
    public HttpResponseOutputAdapter getPreRequestHandlerPrinter() {
        HttpResponseOutputAdapter httpResponseOutputAdapter = this.myResponsePrinter;
        if (httpResponseOutputAdapter == null) {
            HttpMultiResponseConsole.$$$reportNull$$$0(14);
        }
        return httpResponseOutputAdapter;
    }

    @Override
    public HttpResponseOutputAdapter getResponseHandlerTestPrinter() {
        return this.myResponsePrinter.delayedIfNeeded(this.myRequestFinishedQueue::add);
    }

    @Override
    public boolean showRequestMethod() {
        return this.myShowRequestMethods;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authFlowLogEntries";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/test/HttpMultiResponseConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/test/HttpMultiResponseConsole";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreRequestHandlerPrinter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyAboutAuthorization";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStart";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onRequestEnd";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onRequestIgnored";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setResponse";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setErrorResponse";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onResponseFileCreated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toRequestTestName";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14 -> new IllegalStateException(string);
        };
    }

    private static class RequestFinishedQueue {
        private final ArrayList<Runnable> myQueue = new ArrayList();

        private RequestFinishedQueue() {
        }

        void add(@NotNull Runnable action2) {
            if (action2 == null) {
                RequestFinishedQueue.$$$reportNull$$$0(0);
            }
            this.myQueue.add(action2);
        }

        void flush() {
            for (Runnable action2 : this.myQueue) {
                action2.run();
            }
            this.clear();
        }

        void clear() {
            this.myQueue.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/httpClient/http/request/run/test/HttpMultiResponseConsole$RequestFinishedQueue", "add"));
        }
    }
}

