/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.statistics;

import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/httpClient/http/request/run/statistics/HttpClientMethodValidationRule;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "()V", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "getRuleId", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientMethodValidationRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientMethodValidationRule.kt\ncom/intellij/httpClient/http/request/run/statistics/HttpClientMethodValidationRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,20:1\n1747#2,3:21\n*S KotlinDebug\n*F\n+ 1 HttpClientMethodValidationRule.kt\ncom/intellij/httpClient/http/request/run/statistics/HttpClientMethodValidationRule\n*L\n16#1:21,3\n*E\n"})
public final class HttpClientMethodValidationRule
extends CustomValidationRule {
    @NotNull
    public String getRuleId() {
        return "http_client_valid_method_rule";
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        ValidationResultType validationResultType;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<RequestExecutionSupport<?>> executionSupports = RequestExecutionSupport.All.forMethod(data);
        if (executionSupports.isEmpty()) {
            validationResultType = ValidationResultType.REJECTED;
        } else {
            boolean bl;
            block5: {
                Iterable $this$any$iv = executionSupports;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RequestExecutionSupport it = (RequestExecutionSupport)element$iv;
                        boolean bl2 = false;
                        if (!PluginInfoDetectorKt.getPluginInfo(it.getClass()).isSafeToReport()) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            validationResultType = bl ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
        }
        return validationResultType;
    }
}

