/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.httpClient.examples.server.HttpClientExampleServerManager;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.http.request.authentication.AuthFlowLogEntry;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.httpClient.http.request.run.HttpRequestResponseFileResult;
import com.intellij.httpClient.http.request.run.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.run.console.HttpClientConsolePrinter;
import com.intellij.httpClient.http.request.run.console.HttpClientMessagePrinter;
import com.intellij.httpClient.http.request.run.console.HttpRequestErrorFileFilter;
import com.intellij.httpClient.http.request.run.console.HttpRequestErrorFixFilter;
import com.intellij.httpClient.http.request.run.console.HttpResponseConsole;
import com.intellij.httpClient.http.request.run.console.HttpResponseConsoleBottomComponent;
import com.intellij.httpClient.http.request.run.console.HttpResponseFileFilter;
import com.intellij.httpClient.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.httpClient.http.request.run.console.HttpResponsePresentation;
import com.intellij.httpClient.http.request.run.console.HttpSingleRequestConsoleAuthLogTabHolder;
import com.intellij.httpClient.http.request.run.console.HttpSingleRequestConsoleRequestTabHolder;
import com.intellij.httpClient.http.request.run.console.HttpSingleResponseConsoleSettings;
import com.intellij.httpClient.http.request.run.console.editor.HtmlPreviewFileEditor;
import com.intellij.httpClient.http.request.run.console.presentations.DisappearOnClickButton;
import com.intellij.httpClient.http.request.run.console.presentations.inPlace.HttpInplacePdfResponsePresentation;
import com.intellij.httpClient.http.request.run.statistics.HttpClientExecutionUsageCollector;
import com.intellij.httpClient.http.request.run.test.HttpClientTestLocator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.json.JsonFileType;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ValueKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.content.Content;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.AncestorListener;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpSingleResponseConsole
implements HttpResponseConsole {
    private static final Logger LOG = Logger.getInstance(HttpSingleResponseConsole.class);
    private static final DataKey<HttpResponsePresentation> HTTP_RESPONSE_DATA_KEY = DataKey.create((String)"http.request.response.view.response.content");
    public static final Key<HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile> HTTP_PREVIEW_FILE_DATA_KEY = Key.create((String)"http.request.response.view.response.preview.file");
    private static final DataKey<FileType> HTTP_RESPONSE_SELECTED_FILE_TYPE = DataKey.create((String)"http.request.response.view.selected.file.type");
    private final Project myProject;
    private final HttpResponseConsoleView myConsole;
    private final HttpClientMessagePrinter myPrinter;
    private final Ref<FileType> mySelectedFileType;
    private final Predicate<FileType> myIsValidFileType;
    private ConsoleView myResponseHandlerConsole;
    private HttpResponseOutputAdapter myResponseHandlerPrinter;
    private ConsoleView myPreRequestHandlerConsole;
    private HttpResponseOutputAdapter myPreRequestHandlerPrinter;
    private final ProcessHandler myTestsProcessHandler;
    private BaseTestsOutputConsoleView myResponseHandlerTestConsole;
    private HttpResponseOutputAdapter myResponseHandlerTestPrinter;
    private final String myTargetRequestLine;
    private HttpResponsePresentation myResponse;
    private Runnable myOnFinishPrinting;
    private final HttpSingleRequestConsoleRequestTabHolder myRequestTabHolder;
    private final HttpSingleRequestConsoleAuthLogTabHolder myAuthLogTabHolder;

    public HttpSingleResponseConsole(final @NotNull Project project, final @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpClientRequestProcessHandler processHandler, boolean showTarget, @NotNull HttpRunRequestInfo info) {
        if (project == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(2);
        }
        if (info == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(3);
        }
        this.mySelectedFileType = new Ref((Object)PlainTextFileType.INSTANCE);
        this.myIsValidFileType = fileType -> this.mySelectedFileType.get() == fileType;
        this.myResponseHandlerConsole = null;
        this.myResponseHandlerPrinter = null;
        this.myPreRequestHandlerConsole = null;
        this.myPreRequestHandlerPrinter = null;
        this.myResponseHandlerTestConsole = null;
        this.myResponseHandlerTestPrinter = null;
        this.myResponse = null;
        String targetRequestLinePrefix = this.showRequestMethod() ? info.getRequestMethod() + " " : "";
        this.myTargetRequestLine = targetRequestLinePrefix + HttpClientExampleServerManager.hideExampleServerAddress(StringUtil.notNullize((String)info.getRequestURL(), (String)"<unknown>")) + "\n\n";
        this.myProject = project;
        this.myConsole = new HttpResponseConsoleView(project);
        this.myConsole.attachToProcess(processHandler);
        this.myRequestTabHolder = new HttpSingleRequestConsoleRequestTabHolder(project, info.getVariableSubstitutor());
        Disposer.register((Disposable)this.myConsole, (Disposable)this.myRequestTabHolder);
        this.myAuthLogTabHolder = new HttpSingleRequestConsoleAuthLogTabHolder(project);
        Disposer.register((Disposable)this.myConsole, (Disposable)this.myAuthLogTabHolder);
        this.myPrinter = new HttpClientConsolePrinter((ConsoleView)this.myConsole){

            @Override
            public void flush() {
                HttpSingleResponseConsole.this.myConsole.flush();
            }

            public Inlay<?> addInlineEmbeddedComponent(@NotNull JComponent component2, @Nullable Disposable componentDisposable) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.flush();
                int lastOffset = HttpSingleResponseConsole.this.myConsole.getEditor().getDocument().getTextLength();
                int line = Math.max(0, HttpSingleResponseConsole.this.myConsole.getEditor().offsetToLogicalPosition((int)lastOffset).line - 1);
                int offset = HttpSingleResponseConsole.this.myConsole.getEditor().getDocument().getLineStartOffset(line);
                Inlay inlay2 = EditorEmbeddedComponentManager.getInstance().addComponent((EditorEx)HttpSingleResponseConsole.this.myConsole.getEditor(), component2, new EditorEmbeddedComponentManager.Properties(EditorEmbeddedComponentManager.ResizePolicy.none(), null, false, false, 100, offset));
                if (componentDisposable != null) {
                    if (inlay2 != null) {
                        Disposer.register((Disposable)inlay2, (Disposable)componentDisposable);
                    }
                    Disposer.register((Disposable)HttpSingleResponseConsole.this.myConsole, (Disposable)componentDisposable);
                }
                return inlay2;
            }

            @Override
            public void addInlineElementOnCurrentPosition(int aboveOffset, @NotNull Function<Editor, EditorCustomElementRenderer> rendererProvider) {
                if (rendererProvider == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.flush();
                int lastOffset = HttpSingleResponseConsole.this.myConsole.getEditor().getDocument().getTextLength();
                HttpSingleResponseConsole.this.myConsole.getEditor().getInlayModel().addInlineElement(lastOffset - aboveOffset, false, 10, rendererProvider.apply(HttpSingleResponseConsole.this.myConsole.getEditor()));
            }

            @Override
            public void addBlockElementOnCurrentPosition(boolean above, @NotNull Function<Editor, EditorCustomElementRenderer> rendererProvider) {
                if (rendererProvider == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.flush();
                int lastOffset = HttpSingleResponseConsole.this.myConsole.getEditor().getDocument().getTextLength();
                EditorCustomElementRenderer elementRenderer = rendererProvider.apply(HttpSingleResponseConsole.this.myConsole.getEditor());
                Inlay inlay2 = HttpSingleResponseConsole.this.myConsole.getEditor().getInlayModel().addBlockElement(lastOffset, false, above, 10, elementRenderer);
                if (inlay2 != null && elementRenderer instanceof HttpClientMessagePrinter.ParentDisposableProvider) {
                    HttpClientMessagePrinter.ParentDisposableProvider disposableProvider = (HttpClientMessagePrinter.ParentDisposableProvider)elementRenderer;
                    Disposable parentDisposable = disposableProvider.getParentDisposable();
                    Disposer.register((Disposable)parentDisposable, (Disposable)inlay2);
                    Disposer.register((Disposable)HttpSingleResponseConsole.this.myConsole, (Disposable)parentDisposable);
                }
            }

            @Override
            public boolean isPreviewSupported() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rendererProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addInlineEmbeddedComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addInlineElementOnCurrentPosition";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addBlockElementOnCurrentPosition";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProcessHandler processHandler2 = this.myTestsProcessHandler = info.getResponseHandler() != null ? processHandler.getPostProcessorHandler() : null;
        if (this.myTestsProcessHandler != null) {
            try {
                this.myResponseHandlerConsole = new ConsoleViewImpl(project, true);
                this.myResponseHandlerConsole.print(RestClientBundle.message("rest.client.request.response.handler.console", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
                this.myResponseHandlerPrinter = HttpResponseOutputAdapter.create(this.myResponseHandlerConsole);
                Disposer.register((Disposable)this.myConsole, (Disposable)this.myResponseHandlerConsole);
                class MyProperties
                extends SMTRunnerConsoleProperties {
                    MyProperties() {
                        super(project2, sMTRunnerConsoleProperties.getConfiguration(), sMTRunnerConsoleProperties.getTestFrameworkName(), sMTRunnerConsoleProperties.getExecutor());
                    }

                    @Nullable
                    public SMTestLocator getTestLocator() {
                        return new HttpClientTestLocator();
                    }
                }
                this.myResponseHandlerTestConsole = SMTestRunnerConnectionUtil.createAndAttachConsole((String)properties.getTestFrameworkName(), (ProcessHandler)this.myTestsProcessHandler, (TestConsoleProperties)new MyProperties());
                this.myResponseHandlerTestPrinter = HttpResponseOutputAdapter.createTest(this.myTestsProcessHandler, null);
                Disposer.register((Disposable)this.myConsole, (Disposable)this.myResponseHandlerTestConsole);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        if (info.getPreRequestHandler() != null) {
            this.myPreRequestHandlerConsole = new ConsoleViewImpl(project, true);
            this.myPreRequestHandlerPrinter = HttpResponseOutputAdapter.create(this.myPreRequestHandlerConsole);
            Disposer.register((Disposable)this.myConsole, (Disposable)this.myPreRequestHandlerConsole);
        }
        if (showTarget) {
            if (this.myResponseHandlerConsole == null && this.myPreRequestHandlerConsole == null) {
                this.myPrinter.addBlockElementOnCurrentPosition(false, editor2 -> new DisappearOnClickButton(new PresentationFactory(editor2), RestClientBundle.message("rest.client.show.request.button.text", new Object[0]), (Function0<Unit>)((Function0)() -> {
                    this.myConsole.createAndOpenRequestTab();
                    return Unit.INSTANCE;
                })).getEditorCustomElementRenderer());
            }
            this.myPrinter.print(this.myTargetRequestLine, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    @Override
    public void lateInitialize() {
        HttpRequestHistoryManager.getInstance(this.myProject).ensureLogFileExists();
        this.myConsole.addMessageFilter((Filter)new HttpResponseFileFilter(this.myProject));
        this.myConsole.addMessageFilter((Filter)HttpRequestErrorFileFilter.getInstance(this.myProject));
        this.myConsole.addMessageFilter(new HttpRequestErrorFixFilter());
    }

    @Override
    public void onRequestStart(@NotNull String id, int size, @NotNull SmartPsiElementPointer<HttpRequest> request2) {
        if (id == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(4);
        }
        if (request2 == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(5);
        }
    }

    @Override
    public void onRequestEnd(@NotNull String id) {
        if (id == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(6);
        }
        this.myConsole.hideInput();
    }

    @Override
    public void onRequestIgnored(@NotNull String id, @Nullable String message2) {
        if (id == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(7);
        }
    }

    @Override
    public void setOnFinishPrintingCallback(@Nullable Runnable onFinishPrinting) {
        this.myOnFinishPrinting = onFinishPrinting;
    }

    @Override
    public void setResponse(@NotNull String id, @NotNull HttpResponsePresentation response2, @Nullable FileType fileType) {
        if (id == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(8);
        }
        if (response2 == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(9);
        }
        this.myResponse = response2;
        if (fileType != null) {
            this.mySelectedFileType.set((Object)fileType);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            HttpResponseConsoleBottomComponent bottomComponent = response2.provideResponseViewBottomComponent(this.myProject);
            if (bottomComponent != null) {
                this.myConsole.showInput(bottomComponent);
            }
        });
    }

    @Override
    public void setErrorResponse(@Nullable String id, @NotNull HttpResponsePresentation response2) {
        if (response2 == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(10);
        }
        this.setResponse(StringUtil.notNullize((String)id), response2, (FileType)PlainTextFileType.INSTANCE);
        this.myResponse.print(this.myProject, this.myPrinter, null, (FileType)this.mySelectedFileType.get(), this.myIsValidFileType, null, this.myOnFinishPrinting);
        if (this.myTestsProcessHandler != null) {
            this.myTestsProcessHandler.destroyProcess();
        }
    }

    @Override
    public void onResponseFileCreated(@NotNull String id, @Nullable HttpRequestResponseFileResult responseFile) {
        if (id == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(11);
        }
        if (this.myResponse != null) {
            this.myResponse.print(this.myProject, this.myPrinter, responseFile, (FileType)this.mySelectedFileType.get(), this.myIsValidFileType, this.getResponseFoldingModelFactory(this.myConsole.getEditor()), () -> {
                if (this.myOnFinishPrinting != null) {
                    this.myOnFinishPrinting.run();
                }
            });
            if (this.myResponse.previewCanBeOpened()) {
                String fileName;
                FileType fileType = (FileType)this.mySelectedFileType.get();
                String content2 = this.myResponse.getStringToCopy(this.myProject, fileType);
                if (content2 == null || content2.isEmpty()) {
                    return;
                }
                if (responseFile instanceof HttpRequestResponseFileResult.ExactFile) {
                    HttpRequestResponseFileResult.ExactFile exactFile = (HttpRequestResponseFileResult.ExactFile)responseFile;
                    v0 = exactFile.getFileName();
                } else {
                    v0 = fileName = null;
                }
                if (fileName != null) {
                    HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile file = new HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile("preview." + fileName, content2);
                    this.myConsole.getEditor().putUserData(HTTP_PREVIEW_FILE_DATA_KEY, (Object)file);
                }
            }
        }
    }

    @Override
    public boolean showRequestMethod() {
        return HttpSingleResponseConsoleSettings.getInstance().isMethodShown();
    }

    @Override
    public void addToHistory(@NotNull CommonClientRequest request2) {
        if (request2 == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(12);
        }
        this.myRequestTabHolder.init(request2);
    }

    @Override
    public void notifyAboutAuthorization(@NotNull List<AuthFlowLogEntry> authFlowLogEntries) {
        if (authFlowLogEntries == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(13);
        }
        this.myAuthLogTabHolder.init(authFlowLogEntries, null);
        if (this.myResponseHandlerConsole == null && this.myPreRequestHandlerConsole == null) {
            this.myPrinter.addBlockElementOnCurrentPosition(false, editor2 -> new DisappearOnClickButton(new PresentationFactory(editor2), RestClientBundle.message("http.client.show.auth.button", new Object[0]), (Function0<Unit>)((Function0)() -> {
                HttpClientExecutionUsageCollector.AUTH_LOG_FROM_CONSOLE_OPENED_EVENT_ID.log(this.myProject);
                this.myConsole.createAndOpenAuthLogTab();
                return Unit.INSTANCE;
            })).getEditorCustomElementRenderer());
        } else {
            this.myConsole.addAuthLogTab();
        }
        this.myPrinter.print(RestClientBundle.message("http.client.auth.message.in.tab", new Object[0]) + "\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @NotNull
    private HttpResponsePresentation.HttpResponseFoldingModelFactory getResponseFoldingModelFactory(final @NotNull Editor editor2) {
        if (editor2 == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(14);
        }
        return new HttpResponsePresentation.HttpResponseFoldingModelFactory(){

            @Override
            public HttpResponsePresentation.HttpResponseFoldingModelFactory.FileFoldingModel createFileModel() {
                HttpSingleResponseConsole.this.myConsole.flush();
                int startOffset = HttpSingleResponseConsole.this.myConsole.getEditor().getDocument().getTextLength();
                return file -> ReadAction.nonBlocking(() -> {
                    String fileText = file.getText();
                    Document document = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)fileText));
                    FoldingBuilder builder2 = LanguageFolding.INSTANCE.forLanguage(file.getLanguage());
                    FoldingDescriptor[] foldingDescriptors = LanguageFolding.buildFoldingDescriptors((FoldingBuilder)builder2, (PsiElement)file, (Document)document, (boolean)false);
                    int fileLength = fileText.length();
                    return new FileFoldingResult(fileLength, document.getLineCount(), foldingDescriptors);
                }).expireWith((Disposable)HttpSingleResponseConsole.this.myConsole).finishOnUiThread(ModalityState.defaultModalityState(), foldingResult -> {
                    int fileLength = foldingResult.fileLength;
                    FoldingDescriptor[] foldingDescriptors = foldingResult.foldingDescriptors;
                    if (fileLength >= editor2.getDocument().getTextLength()) {
                        HttpSingleResponseConsole.this.myConsole.notifyAboutTruncatedResponse();
                        return;
                    }
                    HttpClientExecutionUsageCollector.RESPONSE_PRESENTED_EVENT_ID.log((Object)foldingResult.fileLinesCount);
                    FoldingModelEx foldingModel = (FoldingModelEx)editor2.getFoldingModel();
                    foldingModel.runBatchFoldingOperation(() -> {
                        for (FoldingDescriptor descriptor : foldingDescriptors) {
                            TextRange range = descriptor.getRange().shiftRight(startOffset);
                            String placeholderText = descriptor.getPlaceholderText();
                            if (placeholderText == null) continue;
                            foldingModel.createFoldRegion(range.getStartOffset(), range.getEndOffset(), placeholderText, descriptor.getGroup(), descriptor.isNonExpandable());
                        }
                    });
                }).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }

            @Override
            public HttpResponsePresentation.HttpResponseFoldingModelFactory.PlainFoldingModel createPlainModel() {
                HttpSingleResponseConsole.this.myConsole.flush();
                int startOffset = HttpSingleResponseConsole.this.myConsole.getEditor().getDocument().getTextLength();
                return (range, placeholder, id, preferFolded) -> {
                    HttpSingleResponseConsole.this.myConsole.flush();
                    FoldingModelEx foldingModel = (FoldingModelEx)editor2.getFoldingModel();
                    foldingModel.runBatchFoldingOperation(() -> {
                        TextRange newRange = range.shiftRight(startOffset);
                        FoldRegion folding = foldingModel.createFoldRegion(newRange.getStartOffset(), newRange.getEndOffset(), placeholder, null, false);
                        if (folding != null && id != null) {
                            folding.putUserData(HttpResponsePresentation.HttpResponseFoldingModelFactory.PlainFoldingModel.ID_KEY, (Object)id);
                            if (preferFolded) {
                                folding.setExpanded(id == HttpResponsePresentation.HEADERS_ID && !HttpSingleResponseConsoleSettings.getInstance().isFoldHeadersByDefault());
                            }
                        }
                    });
                };
            }

            record FileFoldingResult(int fileLength, int fileLinesCount, FoldingDescriptor[] foldingDescriptors) {
            }
        };
    }

    @Override
    @NotNull
    public ConsoleView getConsole() {
        HttpResponseConsoleView httpResponseConsoleView = this.myConsole;
        if (httpResponseConsoleView == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(15);
        }
        return httpResponseConsoleView;
    }

    @Override
    @Nullable
    public HttpResponseOutputAdapter getResponseHandlerPrinter() {
        return this.myResponseHandlerPrinter;
    }

    @Override
    @Nullable
    public HttpResponseOutputAdapter getPreRequestHandlerPrinter() {
        return this.myPreRequestHandlerPrinter;
    }

    @Override
    @Nullable
    public HttpResponseOutputAdapter getResponseHandlerTestPrinter() {
        return this.myResponseHandlerTestPrinter;
    }

    @Nullable
    private static HttpResponsePresentation getResponse(@NotNull AnActionEvent e) {
        if (e == null) {
            HttpSingleResponseConsole.$$$reportNull$$$0(16);
        }
        return (HttpResponsePresentation)e.getData(HTTP_RESPONSE_DATA_KEY);
    }

    public static void openHtmlPreview(HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile file, Project project) {
        HttpClientExecutionUsageCollector.HTML_PREVIEW_OPENED_EVENT_ID.log(project);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authFlowLogEntries";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStart";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onRequestEnd";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onRequestIgnored";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setResponse";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setErrorResponse";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onResponseFileCreated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notifyAboutAuthorization";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResponseFoldingModelFactory";
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getResponse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15 -> new IllegalStateException(string);
        };
    }

    private final class HttpResponseConsoleView
    extends ConsoleViewWrapperBase {
        private static final String RESPONSE_HANDLER_ID = "HTTP_RESPONSE_HANDLER_SCRIPT";
        private static final String RESPONSE_TESTS_ID = "HTTP_RESPONSE_HANDLER_TESTS";
        private static final String PRE_REQUEST_HANDLER_ID = "HTTP_PRE_REQUEST_HANDLER_SCRIPT";
        private static final String REQUEST_ID = "HTTP_REQUEST_TAB";
        private static final String AUTH_ID = "HTTP_AUTH_TAB";
        private final JBSplitter mySplitter;
        @Nullable
        private HttpResponseConsoleBottomComponent myBottomComponent;
        @Nullable
        private RunnerLayoutUi myUi;
        private boolean myIsRequestTabInitialized;
        private boolean myIsAuthTabInitialized;

        private HttpResponseConsoleView(Project project) {
            if (project == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(0);
            }
            super((ConsoleView)new ConsoleViewImpl(project, false){

                public Object getData(@NotNull String dataId) {
                    if (dataId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Object result2 = ValueKey.match((String)dataId).ifEq(HTTP_RESPONSE_DATA_KEY).thenGet(() -> HttpSingleResponseConsole.this.myResponse).ifEq(HTTP_RESPONSE_SELECTED_FILE_TYPE).thenGet(() -> HttpSingleResponseConsole.this.mySelectedFileType.get()).ifEq((ValueKey)PlatformDataKeys.UI_DISPOSABLE).thenGet(() -> this).orNull();
                    return result2 != null ? result2 : super.getData(dataId);
                }

                public void rehighlightHyperlinksAndFoldings() {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpResponseConsoleView$1", "getData"));
                }
            });
            this.myIsRequestTabInitialized = false;
            this.myIsAuthTabInitialized = false;
            ConsoleViewImpl delegate = (ConsoleViewImpl)this.getDelegate();
            for (AncestorListener listener2 : delegate.getAncestorListeners()) {
                delegate.removeAncestorListener(listener2);
            }
            this.mySplitter = new JBSplitter(true, 0.7f, 0.4f, 1.0f);
            this.mySplitter.setFirstComponent(this.getDelegate().getComponent());
            if (this.getDelegate().getComponent() instanceof DataProvider) {
                DataManager.registerDataProvider((JComponent)this.mySplitter, (DataProvider)((DataProvider)this.getDelegate().getComponent()));
            }
        }

        @NotNull
        public JComponent getComponent() {
            JBSplitter jBSplitter = this.mySplitter;
            if (jBSplitter == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(1);
            }
            return jBSplitter;
        }

        public void buildUi(RunnerLayoutUi ui) {
            super.buildUi(ui);
            this.myUi = ui;
            if (HttpSingleResponseConsole.this.myPreRequestHandlerConsole != null || HttpSingleResponseConsole.this.myResponseHandlerConsole != null) {
                this.addRequestTab(ui);
            }
            if (HttpSingleResponseConsole.this.myPreRequestHandlerConsole != null) {
                HttpResponseConsoleView.addTab(ui, PRE_REQUEST_HANDLER_ID, HttpSingleResponseConsole.this.myPreRequestHandlerConsole.getComponent(), RestClientBundle.message("rest.client.request.pre.request.handler.tab.name", new Object[0]));
            }
            if (HttpSingleResponseConsole.this.myResponseHandlerConsole != null) {
                HttpResponseConsoleView.addTab(ui, RESPONSE_HANDLER_ID, HttpSingleResponseConsole.this.myResponseHandlerConsole.getComponent(), RestClientBundle.message("rest.client.request.response.handler.tab.name", new Object[0]));
            }
            if (HttpSingleResponseConsole.this.myResponseHandlerTestConsole != null) {
                HttpResponseConsoleView.addTab(ui, RESPONSE_TESTS_ID, HttpSingleResponseConsole.this.myResponseHandlerTestConsole.getComponent(), RestClientBundle.message("rest.client.request.test.tab.name", new Object[0]));
            }
        }

        private void addRequestTab(RunnerLayoutUi ui) {
            this.myIsRequestTabInitialized = true;
            HttpResponseConsoleView.addTab(ui, REQUEST_ID, HttpSingleResponseConsole.this.myRequestTabHolder.getComponent(), RestClientBundle.message("rest.client.request.tab.name", new Object[0]));
        }

        void addAuthLogTab() {
            if (this.myUi != null) {
                this.myIsAuthTabInitialized = true;
                HttpResponseConsoleView.addTab(this.myUi, AUTH_ID, HttpSingleResponseConsole.this.myAuthLogTabHolder.getComponent(), RestClientBundle.message("http.client.auth.log.tab.title", new Object[0]));
            }
        }

        private static void addTab(@NotNull RunnerLayoutUi ui, @NotNull String contentId, @NotNull JComponent component2, @NotNull @Nls String name) {
            if (ui == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(2);
            }
            if (contentId == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(3);
            }
            if (component2 == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(4);
            }
            if (name == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(5);
            }
            Content content2 = ui.createContent(contentId, component2, name, null, null);
            content2.setCloseable(false);
            if (ui instanceof RunnerLayoutUiImpl) {
                RunnerLayoutUiImpl uiImpl = (RunnerLayoutUiImpl)ui;
                uiImpl.getLayout().clearStateFor(content2);
            }
            ui.addContent(content2);
        }

        public AnAction @NotNull [] createConsoleActions() {
            AnAction[] oldActions = super.createConsoleActions();
            ArrayList<Object> newActions = new ArrayList<Object>(oldActions.length);
            ActionManager actionManager = ActionManager.getInstance();
            ViewSettingsActionGroup group = new ViewSettingsActionGroup();
            group.add((AnAction)new MyEditorToggleShowLineNumbers());
            group.add((AnAction)new MyShowRequestMethodToggle());
            group.add((AnAction)new MyFoldHeadersToggle());
            group.add(actionManager.getAction("HTTPClient.Preview.InlinePdf"));
            group.add((AnAction)new Separator(RestClientBundle.messagePointer("http.request.reformat.response.action.group.title", new Object[0])));
            group.add((AnAction)new HttpResponseReformatAction(HttpSingleResponseConsole.this, RestClientBundle.message("http.request.reformat.response.action.view.as.raw.text", new Object[0]), RestClientBundle.message("http.request.reformat.response.action.view.as.raw.description", new Object[0]), (FileType)PlainTextFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpSingleResponseConsole.this, (FileType)JsonFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpSingleResponseConsole.this, (FileType)XmlFileType.INSTANCE));
            group.add((AnAction)new HttpResponseReformatAction(HttpSingleResponseConsole.this, (FileType)HtmlFileType.INSTANCE));
            group.addSeparator();
            newActions.add((Object)group);
            ScrollToTheEndToolbarAction scrollToEndAction = null;
            ToggleUseSoftWrapsToolbarAction softWrapsToolbarAction = null;
            for (AnAction action2 : oldActions) {
                if (action2 instanceof ScrollToTheEndToolbarAction) {
                    scrollToEndAction = (ScrollToTheEndToolbarAction)action2;
                }
                if (!(action2 instanceof ToggleUseSoftWrapsToolbarAction)) continue;
                softWrapsToolbarAction = (ToggleUseSoftWrapsToolbarAction)action2;
            }
            newActions.add(softWrapsToolbarAction);
            newActions.add((Object)new MyScrollToTopAction((ToggleAction)scrollToEndAction));
            newActions.add(scrollToEndAction);
            newActions.add(actionManager.getAction("HTTPClient.CopyResponseBody"));
            newActions.add(actionManager.getAction("HTTPClient.Preview"));
            AnAction[] anActionArray = newActions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(6);
            }
            return anActionArray;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor2 = ((ConsoleViewImpl)this.getDelegate()).getEditor();
            if (editor2 == null) {
                HttpResponseConsoleView.$$$reportNull$$$0(7);
            }
            return editor2;
        }

        public void flush() {
            ((ConsoleViewImpl)this.getDelegate()).flushDeferredText();
        }

        public void showInput(HttpResponseConsoleBottomComponent bottomComponent) {
            Disposer.register((Disposable)this, (Disposable)bottomComponent);
            this.myBottomComponent = bottomComponent;
            ApplicationManager.getApplication().invokeLater(() -> {
                this.mySplitter.setSecondComponent(bottomComponent.getComponent());
                this.mySplitter.invalidate();
            });
        }

        public void notifyAboutTruncatedResponse() {
            EditorNotificationPanel panel2 = new EditorNotificationPanel(EditorNotificationPanel.Status.Info);
            panel2.setText(RestClientBundle.message("rest.client.request.response.truncated.label", new Object[0]));
            panel2.createActionLabel(RestClientBundle.message("rest.client.request.change.console.settings.label", new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(HttpSingleResponseConsole.this.myProject, CommonBundle.message((String)"title.console", (Object[])new Object[0])));
            ((ConsoleViewImpl)this.getDelegate()).addNotificationComponent((JComponent)panel2);
        }

        public void hideInput() {
            if (this.myBottomComponent != null) {
                HttpResponseConsoleBottomComponent component2 = this.myBottomComponent;
                this.myBottomComponent = null;
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.mySplitter.setSecondComponent(null);
                    Disposer.dispose((Disposable)component2);
                });
            }
        }

        public void createAndOpenRequestTab() {
            if (this.myUi != null && !this.myIsRequestTabInitialized) {
                this.addRequestTab(this.myUi);
                ApplicationManager.getApplication().invokeLater(() -> this.myUi.selectAndFocus(this.myUi.findContent(REQUEST_ID), true, true));
            }
        }

        public void createAndOpenAuthLogTab() {
            if (this.myUi != null && !this.myIsAuthTabInitialized) {
                this.addAuthLogTab();
                ApplicationManager.getApplication().invokeLater(() -> this.myUi.selectAndFocus(this.myUi.findContent(AUTH_ID), true, true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpResponseConsoleView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentId";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpResponseConsoleView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConsoleActions";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addTab";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static final class HtmlPreviewFileEditorProvider
    extends WeighedFileEditorProvider {
        public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                HtmlPreviewFileEditorProvider.$$$reportNull$$$0(0);
            }
            if (file == null) {
                HtmlPreviewFileEditorProvider.$$$reportNull$$$0(1);
            }
            return file instanceof HtmlPreviewVirtualFile;
        }

        public boolean acceptRequiresReadAction() {
            return false;
        }

        @NotNull
        public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                HtmlPreviewFileEditorProvider.$$$reportNull$$$0(2);
            }
            if (file == null) {
                HtmlPreviewFileEditorProvider.$$$reportNull$$$0(3);
            }
            return new HtmlPreviewFileEditor(file);
        }

        @NotNull
        public String getEditorTypeId() {
            return "html-preview-editor-provider";
        }

        @NotNull
        public FileEditorPolicy getPolicy() {
            FileEditorPolicy fileEditorPolicy = FileEditorPolicy.NONE;
            if (fileEditorPolicy == null) {
                HtmlPreviewFileEditorProvider.$$$reportNull$$$0(4);
            }
            return fileEditorPolicy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HtmlPreviewFileEditorProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HtmlPreviewFileEditorProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPolicy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditor";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }

        public static class HtmlPreviewVirtualFile
        extends LightVirtualFile {
            public HtmlPreviewVirtualFile(@NotNull String name, @NotNull CharSequence text2) {
                if (name == null) {
                    HtmlPreviewVirtualFile.$$$reportNull$$$0(0);
                }
                if (text2 == null) {
                    HtmlPreviewVirtualFile.$$$reportNull$$$0(1);
                }
                super(name, (FileType)HtmlFileType.INSTANCE, text2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HtmlPreviewFileEditorProvider$HtmlPreviewVirtualFile";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    static class HttpRequestPreviewAction
    extends AnAction
    implements DumbAware {
        HttpRequestPreviewAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                HttpRequestPreviewAction.$$$reportNull$$$0(0);
            }
            Presentation presentation2 = e.getPresentation();
            HttpResponsePresentation response2 = HttpSingleResponseConsole.getResponse(e);
            boolean bl = enabled = response2 != null && response2.previewCanBeOpened();
            if ("RunnerToolbar".equals(e.getPlace())) {
                presentation2.setEnabled(enabled);
            } else {
                presentation2.setEnabledAndVisible(enabled);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                HttpRequestPreviewAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                HttpRequestPreviewAction.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            HttpResponsePresentation response2 = HttpSingleResponseConsole.getResponse(e);
            if (response2 == null) {
                return;
            }
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor2 == null) {
                return;
            }
            HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile previewFile = (HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile)((Object)editor2.getUserData(HTTP_PREVIEW_FILE_DATA_KEY));
            if (previewFile == null) {
                return;
            }
            HttpSingleResponseConsole.openHtmlPreview(previewFile, project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpRequestPreviewAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpRequestPreviewAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static class HttpRequestCopyResponseBodyAction
    extends AnAction
    implements DumbAware {
        HttpRequestCopyResponseBodyAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                HttpRequestCopyResponseBodyAction.$$$reportNull$$$0(0);
            }
            Presentation presentation2 = e.getPresentation();
            HttpResponsePresentation response2 = HttpSingleResponseConsole.getResponse(e);
            boolean bl = enabled = response2 != null && response2.canBeCopied();
            if ("RunnerToolbar".equals(e.getPlace())) {
                presentation2.setEnabled(enabled);
            } else {
                presentation2.setEnabledAndVisible(enabled);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                HttpRequestCopyResponseBodyAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                HttpRequestCopyResponseBodyAction.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            HttpResponsePresentation response2 = HttpSingleResponseConsole.getResponse(e);
            if (response2 == null) {
                return;
            }
            FileType selectedFileType = (FileType)e.getData(HTTP_RESPONSE_SELECTED_FILE_TYPE);
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(response2.getStringToCopy(project, selectedFileType)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpRequestCopyResponseBodyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpRequestCopyResponseBodyAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyFoldHeadersToggle
    extends ToggleAction
    implements DumbAware {
        MyFoldHeadersToggle() {
            super(RestClientBundle.message("http.request.fold.headers.default.toggle.text", new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFoldHeadersToggle.$$$reportNull$$$0(0);
            }
            return HttpSingleResponseConsoleSettings.getInstance().isFoldHeadersByDefault();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyFoldHeadersToggle.$$$reportNull$$$0(1);
            }
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            HttpResponsePresentation response2 = (HttpResponsePresentation)e.getData(HTTP_RESPONSE_DATA_KEY);
            if (editor2 != null && response2 != null && !response2.isEmpty()) {
                editor2.getFoldingModel().runBatchFoldingOperation(() -> {
                    for (FoldRegion region : editor2.getFoldingModel().getAllFoldRegions()) {
                        if (region.getUserData(HttpResponsePresentation.HttpResponseFoldingModelFactory.PlainFoldingModel.ID_KEY) != HttpResponsePresentation.HEADERS_ID) continue;
                        region.setExpanded(!state);
                    }
                });
            }
            HttpSingleResponseConsoleSettings.getInstance().setFoldHeadersByDefault(state);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyFoldHeadersToggle.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyFoldHeadersToggle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyFoldHeadersToggle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyShowRequestMethodToggle
    extends ToggleAction
    implements DumbAware {
        MyShowRequestMethodToggle() {
            super(RestClientBundle.message("http.request.show.request.method.single.toggle.text", new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowRequestMethodToggle.$$$reportNull$$$0(0);
            }
            return HttpSingleResponseConsoleSettings.getInstance().isMethodShown();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyShowRequestMethodToggle.$$$reportNull$$$0(1);
            }
            HttpSingleResponseConsoleSettings.getInstance().setMethodShown(state);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyShowRequestMethodToggle.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyShowRequestMethodToggle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyShowRequestMethodToggle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static class MyEditorToggleInlinePdfAction
    extends ToggleAction
    implements DumbAware {
        MyEditorToggleInlinePdfAction() {
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEditorToggleInlinePdfAction.$$$reportNull$$$0(0);
            }
            return HttpSingleResponseConsoleSettings.getInstance().getPdfPreviewInlineIsEnabled();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            HttpResponsePresentation response2;
            if (e == null) {
                MyEditorToggleInlinePdfAction.$$$reportNull$$$0(1);
            }
            HttpSingleResponseConsoleSettings.getInstance().setPdfPreviewInlineIsEnabled(state);
            if (!this.isSelected(e) && (response2 = HttpSingleResponseConsole.getResponse(e)) instanceof HttpInplacePdfResponsePresentation) {
                HttpInplacePdfResponsePresentation responsePresentation = (HttpInplacePdfResponsePresentation)response2;
                responsePresentation.removePreviewInlay();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEditorToggleInlinePdfAction.$$$reportNull$$$0(2);
            }
            Presentation presentation2 = e.getPresentation();
            HttpResponsePresentation response2 = HttpSingleResponseConsole.getResponse(e);
            boolean isEnabled = response2 instanceof HttpInplacePdfResponsePresentation;
            presentation2.setEnabledAndVisible(isEnabled);
            super.update(e);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyEditorToggleInlinePdfAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyEditorToggleInlinePdfAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyEditorToggleInlinePdfAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyEditorToggleShowLineNumbers
    extends ToggleAction
    implements DumbAware {
        private static final String ACTION_ID = "EditorToggleShowLineNumbers";

        private MyEditorToggleShowLineNumbers() {
            ActionUtil.copyFrom((AnAction)this, (String)ACTION_ID);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyEditorToggleShowLineNumbers.$$$reportNull$$$0(0);
            }
            return MyEditorToggleShowLineNumbers.getOriginalAction().isSelected(e);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyEditorToggleShowLineNumbers.$$$reportNull$$$0(1);
            }
            MyEditorToggleShowLineNumbers.getOriginalAction().setSelected(e, state);
            HttpSingleResponseConsoleSettings.getInstance().setAreLineNumbersShown(state);
        }

        private static ToggleAction getOriginalAction() {
            return (ToggleAction)ActionManager.getInstance().getAction(ACTION_ID);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyEditorToggleShowLineNumbers.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyEditorToggleShowLineNumbers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyEditorToggleShowLineNumbers";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyScrollToTopAction
    extends DumbAwareAction {
        private static final String ACTION_ID = "EditorScrollTop";
        private final ToggleAction myActionToDisable;

        private MyScrollToTopAction(@Nullable ToggleAction actionToDisable) {
            this.myActionToDisable = actionToDisable;
            ActionUtil.copyFrom((AnAction)this, (String)ACTION_ID);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyScrollToTopAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyScrollToTopAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setIcon(AllIcons.RunConfigurations.Scroll_up);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyScrollToTopAction.$$$reportNull$$$0(2);
            }
            AnAction action2 = ActionManager.getInstance().getAction(ACTION_ID);
            action2.actionPerformed(e);
            if (this.myActionToDisable != null) {
                this.myActionToDisable.setSelected(e, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyScrollToTopAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$MyScrollToTopAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ViewSettingsActionGroup
    extends DefaultActionGroup
    implements DumbAware {
        private ViewSettingsActionGroup() {
            super(RestClientBundle.messagePointer("http.request.response.view.settings.action.popup.text", new Object[0]), true);
            this.getTemplatePresentation().setIcon(AllIcons.General.InspectionsEye);
            this.getTemplatePresentation().setPopupGroup(true);
        }
    }

    private abstract class HttpResponseReformatBaseAction
    extends ToggleAction
    implements DumbAware {
        private HttpResponseReformatBaseAction(@Nullable @NlsActions.ActionDescription String text2, @Nullable String description, Icon icon) {
            super(text2, description, icon);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                HttpResponseReformatBaseAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HttpResponseReformatBaseAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setEnabled(HttpSingleResponseConsole.this.myResponse != null && HttpSingleResponseConsole.this.myResponse.canBeReformatted());
        }

        @Nullable
        public abstract FileType getFileType();

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                HttpResponseReformatBaseAction.$$$reportNull$$$0(2);
            }
            return HttpSingleResponseConsole.this.mySelectedFileType.get() == this.getFileType();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            FileType type;
            if (e == null) {
                HttpResponseReformatBaseAction.$$$reportNull$$$0(3);
            }
            if (state && HttpSingleResponseConsole.this.myResponse != null && (type = this.getFileType()) != null && HttpSingleResponseConsole.this.mySelectedFileType.get() != type) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reformat response body as " + type.getName());
                }
                HttpSingleResponseConsole.this.mySelectedFileType.set((Object)type);
                final Runnable responsePrinter = () -> {
                    HttpSingleResponseConsole.this.myConsole.print(HttpSingleResponseConsole.this.myTargetRequestLine, ConsoleViewContentType.SYSTEM_OUTPUT);
                    HttpSingleResponseConsole.this.myResponse.print(HttpSingleResponseConsole.this.myProject, HttpSingleResponseConsole.this.myPrinter, null, type, HttpSingleResponseConsole.this.myIsValidFileType, HttpSingleResponseConsole.this.getResponseFoldingModelFactory(HttpSingleResponseConsole.this.myConsole.getEditor()), null);
                };
                final Document document = HttpSingleResponseConsole.this.myConsole.getEditor().getDocument();
                document.addDocumentListener(new DocumentListener(){

                    public void beforeDocumentChange(@NotNull DocumentEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (event.getNewLength() == 0) {
                            document.removeDocumentListener((DocumentListener)this);
                            ApplicationManager.getApplication().invokeLater(responsePrinter);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpResponseReformatBaseAction$1", "beforeDocumentChange"));
                    }
                });
                HttpSingleResponseConsole.this.myConsole.clear();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpResponseReformatBaseAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpResponseReformatBaseAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class HttpResponseReformatAction
    extends HttpResponseReformatBaseAction {
        private final FileType myFileType;
        final /* synthetic */ HttpSingleResponseConsole this$0;

        private HttpResponseReformatAction(@NotNull HttpSingleResponseConsole httpSingleResponseConsole, FileType fileType) {
            if (fileType == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(0);
            }
            this(httpSingleResponseConsole, fileType.getName(), RestClientBundle.message("http.request.reformat.response.action.view.as.description", fileType.getName()), fileType);
        }

        private HttpResponseReformatAction(@NotNull @NlsSafe HttpSingleResponseConsole httpSingleResponseConsole, @NotNull @NlsActions.ActionDescription String text2, @NotNull String description, FileType fileType) {
            if (text2 == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(1);
            }
            if (description == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(2);
            }
            if (fileType == null) {
                HttpResponseReformatAction.$$$reportNull$$$0(3);
            }
            this.this$0 = httpSingleResponseConsole;
            super(text2, description, fileType.getIcon());
            this.myFileType = fileType;
        }

        @Override
        @Nullable
        public FileType getFileType() {
            return this.myFileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HttpResponseReformatAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

