/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpEnvironmentComboBox
extends ComboBox<HttpEnvironmentItem> {
    private static final HttpEnvironmentItem EMPTY = new HttpRegularEnvironmentItem(HttpRequestEnvironment.EMPTY_NAME, true);
    private final Disposable myParentDisposable;

    public HttpEnvironmentComboBox(Disposable disposable2) {
        this.myParentDisposable = disposable2;
        this.setEditable(false);
        this.setToolTipText(RestClientBundle.message("http.request.run.configuration.env.combo.box.tooltip", new Object[0]));
    }

    public void reset(@NotNull Project project, @Nullable PsiFile file, @Nullable String selectEnv) {
        if (project == null) {
            HttpEnvironmentComboBox.$$$reportNull$$$0(0);
        }
        this.setEnabled(false);
        ReadAction.nonBlocking(() -> {
            ArrayList<HttpEnvironmentItem> items = new ArrayList<HttpEnvironmentItem>();
            if (file != null) {
                items.add(new HttpDefaultEnvironmentItem(project, file));
            }
            if (file != null) {
                HttpClientEnvironmentsProvider.EnvironmentsSearchResult environments2 = HttpClientEnvironmentsProvider.INSTANCE.provideEnvironments(file);
                for (String envName : environments2.asListOfNames()) {
                    items.add(new HttpRegularEnvironmentItem(envName, true));
                }
            }
            items.add(EMPTY);
            return items;
        }).inSmartMode(project).expireWith(this.myParentDisposable).finishOnUiThread(ModalityState.any(), items -> {
            HttpEnvironmentItem toSelect = HttpEnvironmentComboBox.findItemByName(items, selectEnv);
            if (toSelect == null && StringUtil.isNotEmpty((String)selectEnv)) {
                toSelect = new HttpRegularEnvironmentItem(selectEnv, false);
            }
            this.setModel((ComboBoxModel)new CollectionComboBoxModel(items));
            this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<HttpEnvironmentItem>(){

                protected void customizeCellRenderer(@NotNull JList<? extends HttpEnvironmentItem> list2, HttpEnvironmentItem value, int index, boolean selected, boolean hasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value == null) {
                        return;
                    }
                    boolean isValid = value.isValid();
                    String name = value.getName();
                    this.append(name, isValid ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
                    if (value instanceof HttpDefaultEnvironmentItem) {
                        HttpDefaultEnvironmentItem defaultEnv = (HttpDefaultEnvironmentItem)value;
                        String defaultEnvName = defaultEnv.getRegularEnvironmentName();
                        SimpleTextAttributes attributes = isValid ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES;
                        this.append(" (" + StringUtil.notNullize((String)defaultEnvName, (String)RestClientBundle.message("http.request.run.configuration.no.env.name", new Object[0])) + ")", attributes);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/httpClient/http/request/run/config/HttpEnvironmentComboBox$1", "customizeCellRenderer"));
                }
            });
            if (toSelect != null) {
                this.getModel().setSelectedItem(toSelect);
            }
            this.setEnabled(this.getModel().getSize() > 1);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    private static HttpEnvironmentItem findItemByName(@NotNull List<HttpEnvironmentItem> items, @Nullable String name) {
        if (items == null) {
            HttpEnvironmentComboBox.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)name)) {
            for (HttpEnvironmentItem item : items) {
                if (!StringUtil.equals((CharSequence)item.getName(), (CharSequence)name)) continue;
                return item;
            }
        }
        return null;
    }

    @Nullable
    public HttpEnvironmentItem getSelectedItem() {
        return (HttpEnvironmentItem)super.getSelectedItem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpEnvironmentComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findItemByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface HttpEnvironmentItem {
        @NotNull
        @NlsSafe
        public String getName();

        public boolean isValid();
    }

    private static final class HttpRegularEnvironmentItem
    implements HttpEnvironmentItem {
        private final String myName;
        private final boolean myValid;

        private HttpRegularEnvironmentItem(@NotNull String name, boolean valid) {
            if (name == null) {
                HttpRegularEnvironmentItem.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myValid = valid;
        }

        @Override
        @NotNull
        @NlsSafe
        public String getName() {
            String string = this.myName;
            if (string == null) {
                HttpRegularEnvironmentItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isValid() {
            return this.myValid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/config/HttpEnvironmentComboBox$HttpRegularEnvironmentItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpEnvironmentComboBox$HttpRegularEnvironmentItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class HttpDefaultEnvironmentItem
    implements HttpEnvironmentItem {
        private final boolean myValid;
        @Nls
        private final String myRegularEnvironmentName;

        @RequiresBackgroundThread
        private HttpDefaultEnvironmentItem(@NotNull Project project, @NotNull PsiFile file) {
            if (project == null) {
                HttpDefaultEnvironmentItem.$$$reportNull$$$0(0);
            }
            if (file == null) {
                HttpDefaultEnvironmentItem.$$$reportNull$$$0(1);
            }
            ThreadingAssertions.assertBackgroundThread();
            this.myValid = HttpRequestEnvironment.isDefaultEnvironmentValid(project, file);
            this.myRegularEnvironmentName = this.myValid ? HttpRequestEnvironment.getDefaultEnvName(project, file) : null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = HttpRequestEnvironment.DEFAULT_NAME;
            if (string == null) {
                HttpDefaultEnvironmentItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean isValid() {
            return this.myValid;
        }

        @Nullable
        @Nls
        public String getRegularEnvironmentName() {
            return this.myRegularEnvironmentName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/config/HttpEnvironmentComboBox$HttpDefaultEnvironmentItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpEnvironmentComboBox$HttpDefaultEnvironmentItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

