/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutorImpl;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.HttpRequestNotifications;
import com.intellij.httpClient.http.request.run.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.console.HttpResponseConsole;
import com.intellij.httpClient.http.request.run.console.HttpResponsePresentation;
import com.intellij.httpClient.http.request.run.console.HttpSingleResponseConsole;
import com.intellij.httpClient.http.request.run.controller.HttpClientExecutionController;
import com.intellij.httpClient.http.request.run.test.HttpMultiResponseConsole;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RunHttpRequestProfileState
implements RunProfileState {
    private final Project myProject;
    private final HttpRequestExecutionConfig myConfig;
    private final SMTRunnerConsoleProperties myProperties;
    private final HttpRequestVariableSubstitutorImpl mySubstitutor;
    @NotNull
    protected final HttpRequestRunConfiguration.Settings mySettings;

    public RunHttpRequestProfileState(@NotNull Project project, @NotNull HttpRequestRunConfiguration.Settings settings, @NotNull HttpRequestExecutionConfig config, @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpRequestVariableSubstitutorImpl substitutor2) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(1);
        }
        if (config == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(3);
        }
        if (substitutor2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myConfig = config;
        this.myProperties = properties;
        this.mySubstitutor = substitutor2;
        this.mySettings = settings;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (runner == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(5);
        }
        return this.execute();
    }

    @ApiStatus.Internal
    @Nullable
    public ExecutionResult execute() throws ExecutionException {
        HttpRequestEnvironment.clearForcingToUseStored(this.myProject);
        boolean hasResponseHandler = ContainerUtil.exists(this.myConfig.getRequests(), request2 -> request2.getResponseHandler() != null);
        HttpClientRequestProcessHandler processHandler = new HttpClientRequestProcessHandler(hasResponseHandler);
        ArrayList<HttpRunRequestInfo> infos = new ArrayList<HttpRunRequestInfo>();
        for (HttpRequest request3 : this.myConfig.getRequests()) {
            infos.add(HttpRunRequestInfo.create(request3, (SmartPsiElementPointer<HttpRequest>)SmartPointerManager.createPointer((PsiElement)request3), this.mySubstitutor));
        }
        final HttpResponseConsole console2 = this.createConsole(processHandler, infos);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((exitCode = event.getExitCode()) != 0) {
                    String message2 = exitCode == 1 ? RestClientBundle.message("rest.client.request.execute.cancel", new Object[0]) : RestClientBundle.message("rest.client.request.execute.cancel.post.process", new Object[0]);
                    console2.setErrorResponse(null, HttpResponsePresentation.createErrorResponse(message2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/httpClient/http/request/run/RunHttpRequestProfileState$1", "processTerminated"));
            }
        });
        this.executeHttpRequest(this.myProject, infos.iterator(), processHandler, console2, infos.size() == 1);
        return new DefaultExecutionResult((ExecutionConsole)console2.getConsole(), (ProcessHandler)processHandler);
    }

    @NotNull
    private HttpResponseConsole createConsole(@NotNull HttpClientRequestProcessHandler processHandler, @NotNull List<HttpRunRequestInfo> requests2) throws ExecutionException {
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(6);
        }
        if (requests2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(7);
        }
        if (requests2.isEmpty()) {
            throw new ExecutionException(RestClientBundle.message("http.request.no.requests.to.execute.error", new Object[0]));
        }
        if (requests2.size() == 1) {
            HttpRunRequestInfo info = requests2.get(0);
            return new HttpSingleResponseConsole(this.myProject, this.myProperties, processHandler, this.myConfig.isShowInformationAboutRequest(), info);
        }
        return new HttpMultiResponseConsole(this.myProject, this.myProperties, processHandler);
    }

    private void executeHttpRequest(@NotNull Project project, @NotNull Iterator<HttpRunRequestInfo> requests2, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console2, boolean showResponseInplace) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(8);
        }
        if (requests2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(10);
        }
        if (console2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(11);
        }
        if (!requests2.hasNext()) {
            return;
        }
        try {
            this.createExecutionController(project, requests2, processHandler, console2, showResponseInplace).execute();
        }
        catch (ExecutionException e) {
            HttpRequestNotifications.showErrorBalloon(project, RestClientBundle.message("rest.client.request.execute.notification", new Object[0]), e.getMessage());
            processHandler.onRunFinished();
        }
    }

    @NotNull
    protected HttpClientExecutionController createExecutionController(@NotNull Project project, @NotNull Iterator<HttpRunRequestInfo> requests2, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console2, boolean showResponseInplace) throws ExecutionException {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(12);
        }
        if (requests2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(13);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(14);
        }
        if (console2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(15);
        }
        Runnable onRequestFinished = this.createOnFinished(project, console2, processHandler, requests2, showResponseInplace);
        HttpClientExecutionController httpClientExecutionController = HttpClientExecutionController.create(project, requests2.next(), processHandler, console2, onRequestFinished, showResponseInplace, this.mySettings, false);
        if (httpClientExecutionController == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(16);
        }
        return httpClientExecutionController;
    }

    @NotNull
    protected Runnable createOnFinished(@NotNull Project project, @NotNull HttpResponseConsole console2, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull Iterator<HttpRunRequestInfo> requests2, boolean showResponseInplace) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(17);
        }
        if (console2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(18);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(19);
        }
        if (requests2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(20);
        }
        Runnable runnable = () -> {
            if (requests2.hasNext()) {
                this.executeHttpRequest(project, requests2, processHandler, console2, showResponseInplace);
            } else {
                processHandler.onRunFinished();
            }
        };
        if (runnable == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(21);
        }
        return runnable;
    }

    @TestOnly
    public HttpRequestVariableSubstitutorImpl getSubstitutor() {
        return this.mySubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/RunHttpRequestProfileState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestProfileState";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionController";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createOnFinished";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeHttpRequest";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionController";
                break;
            }
            case 16: 
            case 21: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createOnFinished";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 21 -> new IllegalStateException(string);
        };
    }
}

