/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.httpClient.http.request.actions.HttpRequestBaseAction;
import com.intellij.httpClient.http.request.debug.HttpRequestDebugExecutorExtension;
import com.intellij.httpClient.http.request.debug.HttpRequestDebugger;
import com.intellij.httpClient.http.request.debug.HttpRequestDebuggerUtils;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestExecutorExtension;
import com.intellij.httpClient.http.request.run.HttpRequestExecutorExtensionFactory;
import com.intellij.httpClient.http.request.run.HttpRequestRunConfigurationExecutor;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.config.HttpRequestRuntimeConfigurationProducer;
import com.intellij.httpClient.http.request.run.config.HttpSingleRequestExecutionConfig;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class RunHttpRequestAction
extends HttpRequestBaseAction {
    private static final Logger LOG = Logger.getInstance(RunHttpRequestAction.class);
    private HttpRequestRunConfigurationExecutor myExecutor;
    private final HttpRequestExecutorExtension myExtension;
    protected final HttpRequestExecutionConfig myConfig;

    public RunHttpRequestAction(@NotNull HttpRequestExecutionConfig config, @Nullable String initialEnv, @Nullable HttpRequestExecutorExtension extension) {
        if (config == null) {
            RunHttpRequestAction.$$$reportNull$$$0(0);
        }
        this.myConfig = config;
        this.myExecutor = HttpRequestRunConfigurationExecutor.getInstance();
        this.myExtension = extension != null ? extension : HttpRequestExecutorExtensionFactory.getRunExtension();
        this.getTemplatePresentation().setText(this.getRunWithEnvironmentText(initialEnv), true);
        this.getTemplatePresentation().setIcon(this.myExtension.getIcon());
    }

    public void update(@NotNull AnActionEvent e) {
        String text2;
        if (e == null) {
            RunHttpRequestAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        if ("IntentionMenu".equals(e.getPlace())) {
            e.getPresentation().setPerformGroup(true);
        }
        if (StringUtil.isNotEmpty((String)(text2 = this.getPresentationText(e.getProject())))) {
            e.getPresentation().setText(text2, true);
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public boolean isDumbAware() {
        return this.myExtension == HttpRequestExecutorExtensionFactory.getRunExtension();
    }

    @Nullable
    @NlsActions.ActionText
    protected abstract String getPresentationText(Project var1);

    @NotNull
    @NlsActions.ActionText
    protected String getRunWithEnvironmentText(@Nullable String initialEnv) {
        String string = this.myConfig.getActionDescription(this.myExtension.getActionName(), initialEnv);
        if (string == null) {
            RunHttpRequestAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @TestOnly
    protected void setExecutor(@NotNull HttpRequestRunConfigurationExecutor executor) {
        if (executor == null) {
            RunHttpRequestAction.$$$reportNull$$$0(3);
        }
        this.myExecutor = executor;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        RunnerAndConfigurationSettings runner;
        Project project;
        if (event == null) {
            RunHttpRequestAction.$$$reportNull$$$0(4);
        }
        if ((project = event.getProject()) == null) {
            return;
        }
        String environment = this.getSelectedEnvironment(project);
        HttpRequestEnvironment.setDefaultEnvName(project, environment);
        if (Boolean.TRUE.equals(event.getData(HttpClientDataKeys.FORCE_USING_STORED_ENVIRONMENT))) {
            HttpRequestEnvironment.forceNextUsingStored(project);
        }
        HttpRequestRuntimeConfigurationProducer producer = this.myConfig.getRuntimeConfigurationProducer();
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)event.getDataContext(), (String)"unknown");
        if (context.getLocation() == null) {
            return;
        }
        boolean wasCreated = false;
        String customDebuggerName = RunHttpRequestAction.getNotDefaultDebuggerName(this.myExtension);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runner = StringUtil.isEmpty((String)customDebuggerName) ? producer.findExistingConfigurationWithDefaultEnv(context) : null;
        if (runner == null) {
            ConfigurationFromContext fromContext = producer.createConfigurationFromContext(context);
            if (fromContext == null) {
                return;
            }
            wasCreated = true;
            runner = fromContext.getConfigurationSettings();
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        if (wasCreated) {
            RunConfiguration configuration = runner.getConfiguration();
            HttpRequestRunConfiguration.Settings settings = ((HttpRequestRunConfiguration)configuration).getSettings();
            if (!settings.isDefaultEnvironment()) {
                RunHttpRequestAction.updateEnvironment(settings, environment);
            }
            RunHttpRequestAction.updateDebugger(settings, this.myExtension);
            runManager.setUniqueNameIfNeeded(configuration);
            runner.setTemporary(true);
            runManager.addConfiguration(runner);
        }
        RunHttpRequestAction.updateSelectedRunConfiguration(runManager, runner);
        this.myExecutor.execute(project, runner, this.myExtension.getExecutor());
    }

    private static void updateEnvironment(@NotNull HttpRequestRunConfiguration.Settings settings, @Nullable String environment) {
        if (settings == null) {
            RunHttpRequestAction.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)environment)) {
            settings.setEnvironment(environment);
        } else {
            settings.setNoEnvironment();
        }
    }

    private static void updateDebugger(@NotNull HttpRequestRunConfiguration.Settings settings, @NotNull HttpRequestExecutorExtension debug) {
        if (settings == null) {
            RunHttpRequestAction.$$$reportNull$$$0(6);
        }
        if (debug == null) {
            RunHttpRequestAction.$$$reportNull$$$0(7);
        }
        if (debug instanceof HttpRequestDebugExecutorExtension) {
            settings.setDebugger(((HttpRequestDebugExecutorExtension)debug).getDebuggerName());
        }
    }

    @Nullable
    private static String getNotDefaultDebuggerName(@NotNull HttpRequestExecutorExtension debug) {
        if (debug == null) {
            RunHttpRequestAction.$$$reportNull$$$0(8);
        }
        if (debug instanceof HttpRequestDebugExecutorExtension) {
            boolean isDefaultDebugger;
            String name = ((HttpRequestDebugExecutorExtension)debug).getDebuggerName();
            List<HttpRequestDebugger> allExtensions = HttpRequestDebuggerUtils.getAvailableDebuggerExtension();
            boolean bl = isDefaultDebugger = allExtensions.size() == 1 && name.equals(allExtensions.get(0).getPresentableName());
            if (!isDefaultDebugger) {
                return name;
            }
        }
        return null;
    }

    private static void updateSelectedRunConfiguration(@NotNull RunManager runManager, @NotNull RunnerAndConfigurationSettings runner) {
        RunnerAndConfigurationSettings selectedRunner;
        if (runManager == null) {
            RunHttpRequestAction.$$$reportNull$$$0(9);
        }
        if (runner == null) {
            RunHttpRequestAction.$$$reportNull$$$0(10);
        }
        if (((selectedRunner = runManager.getSelectedConfiguration()) == null || selectedRunner.isTemporary()) && runManager.shouldSetRunConfigurationFromContext()) {
            runManager.setSelectedConfiguration(runner);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunHttpRequestAction.$$$reportNull$$$0(11);
        }
        return actionUpdateThread;
    }

    @Nullable
    public abstract String getSelectedEnvironment(@NotNull Project var1);

    public HttpRequestExecutionConfig getConfig() {
        return this.myConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debug";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunWithEnvironmentText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateEnvironment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateDebugger";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNotDefaultDebuggerName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedRunConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11 -> new IllegalStateException(string);
        };
    }

    public static class RunRequestWithoutEnvAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithoutEnv";

        public RunRequestWithoutEnvAction(@NotNull HttpRequestExecutionConfig config, @Nullable HttpRequestExecutorExtension extension, @NlsActions.ActionDescription @Nullable String newDescription) {
            if (config == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(0);
            }
            super(config, null, extension);
            if (newDescription != null) {
                this.getTemplatePresentation().setDescription(newDescription);
            }
        }

        public RunRequestWithoutEnvAction(@NotNull HttpRequestExecutionConfig config, @Nullable HttpRequestExecutorExtension extension) {
            if (config == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(1);
            }
            this(config, extension, null);
        }

        public String getId() {
            return ID;
        }

        @Override
        protected String getPresentationText(Project project) {
            return this.getTemplatePresentation().getText();
        }

        @Override
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction$RunRequestWithoutEnvAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RunRequestWithDefaultEnvAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithDefaultEnv";

        public RunRequestWithDefaultEnvAction(@NotNull HttpRequest request2) {
            if (request2 == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(0);
            }
            super(new HttpSingleRequestExecutionConfig(request2), null, null);
        }

        public RunRequestWithDefaultEnvAction(@NotNull HttpRequestExecutionConfig config, @Nullable HttpRequestExecutorExtension extension) {
            if (config == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(1);
            }
            super(config, null, extension);
        }

        public String getId() {
            return ID;
        }

        @Override
        protected String getPresentationText(Project project) {
            String defaultEnv = project != null ? HttpRequestEnvironment.getDefaultEnvName(project) : null;
            return this.getRunWithEnvironmentText(defaultEnv);
        }

        @Override
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(2);
            }
            return HttpRequestEnvironment.getDefaultEnvName(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction$RunRequestWithDefaultEnvAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RunRequestWithEnvForFileAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithEnvForFile";
        private final AnAction mySelectBeforeRunAction;

        public RunRequestWithEnvForFileAction(@NotNull Project project, @NotNull HttpRequestExecutionConfig config, @Nullable HttpRequestExecutorExtension extension, @NotNull AnAction selectBeforeRunAction) {
            if (project == null) {
                RunRequestWithEnvForFileAction.$$$reportNull$$$0(0);
            }
            if (config == null) {
                RunRequestWithEnvForFileAction.$$$reportNull$$$0(1);
            }
            if (selectBeforeRunAction == null) {
                RunRequestWithEnvForFileAction.$$$reportNull$$$0(2);
            }
            super(config, RunRequestWithEnvForFileAction.getSelectedEnv(project, config.getContext().getVirtualFile()), extension);
            this.mySelectBeforeRunAction = selectBeforeRunAction;
        }

        public String getId() {
            return ID;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent event) {
            Project project;
            if (event == null) {
                RunRequestWithEnvForFileAction.$$$reportNull$$$0(3);
            }
            if ((project = event.getProject()) == null) {
                return;
            }
            try {
                String selectedEnv = RunRequestWithEnvForFileAction.getSelectedEnv(project, this.myConfig.getContext().getVirtualFile());
                if (HttpClientSelectedEnvironments.isSelectBeforeRun(selectedEnv)) {
                    this.mySelectBeforeRunAction.actionPerformed(event);
                    return;
                }
                super.actionPerformed(event);
            }
            catch (HttpRequestExecutionConfig.InvalidConfigException e) {
                LOG.debug((Throwable)e);
            }
        }

        @Override
        @Nullable
        protected String getPresentationText(Project project) {
            try {
                String selectedEnv = RunRequestWithEnvForFileAction.getSelectedEnv(project, this.myConfig.getContext().getVirtualFile());
                if (HttpClientSelectedEnvironments.isSelectBeforeRun(selectedEnv)) {
                    return this.mySelectBeforeRunAction.getTemplateText();
                }
                return this.getRunWithEnvironmentText(selectedEnv);
            }
            catch (HttpRequestExecutionConfig.InvalidConfigException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }

        @Override
        @Nullable
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithEnvForFileAction.$$$reportNull$$$0(4);
            }
            return RunRequestWithEnvForFileAction.getSelectedEnv(project, this.myConfig.getContext().getVirtualFile());
        }

        @Nullable
        private static String getSelectedEnv(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                RunRequestWithEnvForFileAction.$$$reportNull$$$0(5);
            }
            if (file == null) {
                RunRequestWithEnvForFileAction.$$$reportNull$$$0(6);
            }
            return HttpClientSelectedEnvironments.getInstance(project).get(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectBeforeRunAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction$RunRequestWithEnvForFileAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnv";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RunRequestWithEnvAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithSelectedEnv";
        private final String myEnvironment;

        public RunRequestWithEnvAction(@NotNull HttpRequestExecutionConfig config, @Nullable String environment, @Nullable HttpRequestExecutorExtension extension) {
            if (config == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(0);
            }
            super(config, environment, extension);
            this.myEnvironment = environment;
        }

        @Override
        protected String getPresentationText(Project project) {
            return this.getTemplatePresentation().getText();
        }

        public String getId() {
            return ID;
        }

        @Override
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(1);
            }
            return this.myEnvironment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction$RunRequestWithEnvAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

