/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.ExecutionException;
import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.RestClientResponseListener;
import com.intellij.httpClient.execution.ssl.HttpRequestSslConfigurationException;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.net.URISyntaxException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RestClientResponseErrorHandlerListener
implements RestClientResponseListener {
    private static final String AUTHORITY_ERROR_MESSAGE = "Illegal character in authority";
    private static final Logger LOG = Logger.getInstance(RestClientResponseErrorHandlerListener.class);

    @Override
    public void onErrorResponse(@Nullable Throwable throwable) {
        if (throwable == null) {
            this.onErrorResponse("");
        } else if (throwable instanceof NoClassDefFoundError || throwable instanceof ExceptionWithAttachments || throwable instanceof NullPointerException || throwable instanceof IllegalStateException) {
            this.onErrorResponse(HttpClientExecutorBundle.message("http.client.internal.error", new Object[0]));
            LOG.error(throwable);
        } else if (throwable instanceof URISyntaxException) {
            URISyntaxException uriSyntaxException = (URISyntaxException)throwable;
            this.onErrorResponseURISyntaxException(uriSyntaxException);
        } else {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof URISyntaxException) {
                URISyntaxException uriSyntaxException = (URISyntaxException)throwable2;
                this.onErrorResponseURISyntaxException(uriSyntaxException);
            } else if (throwable.getCause() != null && (throwable2 = throwable.getCause().getCause()) instanceof URISyntaxException) {
                URISyntaxException uriSyntaxException = (URISyntaxException)throwable2;
                this.onErrorResponseURISyntaxException(uriSyntaxException);
            } else if (throwable instanceof HttpRequestSslConfigurationException) {
                this.onErrorResponse(HttpClientExecutorBundle.message("http.request.ssl.error.response", throwable.getMessage()));
            } else if (throwable instanceof HttpRequestValidationException) {
                this.onErrorResponse(throwable.getMessage());
            } else if (throwable instanceof ExecutionException) {
                this.onErrorResponse(throwable.getMessage());
            } else {
                this.onErrorResponse(throwable.toString());
            }
        }
    }

    private void onErrorResponseURISyntaxException(@NotNull URISyntaxException throwable) {
        HttpVariable variable2;
        if (throwable == null) {
            RestClientResponseErrorHandlerListener.$$$reportNull$$$0(0);
        }
        if ((variable2 = RestClientResponseErrorHandlerListener.getVariableFromException(this.getRequestPointer(), throwable)) == null) {
            this.onErrorResponse(throwable.toString());
            return;
        }
        String variableName = variable2.getName();
        LogicalPosition variablePosition = RestClientResponseErrorHandlerListener.findVariablePosition(variable2);
        VirtualFile file = variable2.getContainingFile().getOriginalFile().getVirtualFile();
        if (variablePosition != null && file != null) {
            String message2 = HttpClientExecutorBundle.message("http.client.request.error.message.description", variableName);
            String path2 = String.format("%s:%d:%d", file.getPresentableUrl(), variablePosition.line + 1, variablePosition.column + 1);
            String response2 = HttpClientExecutorBundle.message("http.client.request.error.message.begin", message2, path2) + "\n" + HttpClientExecutorBundle.message("http.client.request.error.message.quickfixes.title", new Object[0]) + "\n1. " + HttpClientExecutorBundle.message("http.client.request.error.message.add.env.file.quickfix", new Object[0]) + "\n2. " + HttpClientExecutorBundle.message("http.client.request.error.message.add.to.env.quickfix", new Object[0]) + "\n3. " + HttpClientExecutorBundle.message("http.client.request.error.message.run.with.env.quickfix", new Object[0]);
            this.onErrorResponse(response2);
        } else {
            this.onErrorResponse(throwable.toString());
        }
    }

    @NotNull
    protected abstract SmartPsiElementPointer<HttpRequest> getRequestPointer();

    @Nullable
    public static HttpVariable getVariableFromException(@NotNull SmartPsiElementPointer<? extends HttpRequest> requestPointer, @NotNull URISyntaxException e) {
        HttpRequestTarget requestTarget;
        if (requestPointer == null) {
            RestClientResponseErrorHandlerListener.$$$reportNull$$$0(1);
        }
        if (e == null) {
            RestClientResponseErrorHandlerListener.$$$reportNull$$$0(2);
        }
        if ((requestTarget = (HttpRequestTarget)ObjectUtils.doIfNotNull((Object)((HttpRequest)requestPointer.getElement()), HttpRequest::getRequestTarget)) == null) {
            return null;
        }
        Collection variables2 = PsiTreeUtil.findChildrenOfType((PsiElement)requestTarget, HttpVariable.class);
        if (variables2.isEmpty()) {
            return null;
        }
        int errorIndex = e.getMessage().startsWith(AUTHORITY_ERROR_MESSAGE) ? e.getInput().indexOf(123, e.getIndex()) : e.getIndex();
        String variableName = RestClientResponseErrorHandlerListener.getVariableNameByIndex(e.getInput(), errorIndex);
        if (variableName == null) {
            return null;
        }
        return (HttpVariable)ContainerUtil.find((Iterable)variables2, httpVariable -> variableName.equals(httpVariable.getName()));
    }

    @Nullable
    private static String getVariableNameByIndex(@NotNull String url, int index) {
        if (url == null) {
            RestClientResponseErrorHandlerListener.$$$reportNull$$$0(3);
        }
        if (index < 0) {
            return null;
        }
        if (url.charAt(index) != '{' || !RestClientResponseErrorHandlerListener.isNextSymbolIs(url, index, '{')) {
            return null;
        }
        int indexOfFirstBrace = url.indexOf(125, index);
        if (indexOfFirstBrace == -1 || !RestClientResponseErrorHandlerListener.isNextSymbolIs(url, indexOfFirstBrace, '}')) {
            return null;
        }
        return url.substring(index + 2, indexOfFirstBrace);
    }

    private static boolean isNextSymbolIs(@NotNull String url, int index, char c) {
        if (url == null) {
            RestClientResponseErrorHandlerListener.$$$reportNull$$$0(4);
        }
        return index + 1 < url.length() && url.charAt(index + 1) == c;
    }

    @Nullable
    private static LogicalPosition findVariablePosition(@NotNull HttpVariable variable2) {
        Document document;
        if (variable2 == null) {
            RestClientResponseErrorHandlerListener.$$$reportNull$$$0(5);
        }
        if ((document = PsiDocumentManager.getInstance((Project)variable2.getProject()).getDocument(variable2.getContainingFile().getOriginalFile())) == null) {
            return null;
        }
        int offset = variable2.getTextOffset();
        int lineNumber = document.getLineNumber(offset);
        int columnNumber = offset - document.getLineStartOffset(lineNumber);
        return new LogicalPosition(lineNumber, columnNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPointer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/RestClientResponseErrorHandlerListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onErrorResponseURISyntaxException";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariableFromException";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariableNameByIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isNextSymbolIs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findVariablePosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record LogicalPosition(int line, int column) {
    }
}

