/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.actions.HttpClientActionsUsage;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpDifferenceFile;
import com.intellij.httpClient.http.request.psi.HttpFilePath;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.run.HttpClientResponseFileManager;
import com.intellij.httpClient.http.request.run.HttpRequestInvalidLogFileException;
import com.intellij.httpClient.http.request.run.HttpRequestUpdateManager;
import com.intellij.httpClient.http.request.run.HttpScratchRequestPostProcessor;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Plow;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class HttpRequestHistoryManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(HttpRequestHistoryManager.class);
    private static final String DEFAULT_HTTP_REQUESTS_ROOT = "httpRequests";
    private static final String DEFAULT_LOG_FILE_NAME = PathUtil.makeFileName((String)"http-requests-log", (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
    private static final int MAX_CAPACITY = 10000;
    private static final String CAPACITY_SETTING = "http.client.history.size";
    @NotNull
    private final Project myProject;
    private final @NotNull AtomicReference<@Nullable SmartPsiElementPointer<HttpRequestPsiFile>> myLogFilePointer;

    public HttpRequestHistoryManager(@NotNull Project project) {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(0);
        }
        this.myLogFilePointer = new AtomicReference<Object>(null);
        this.myProject = project;
    }

    public void dispose() {
    }

    public static HttpRequestHistoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(1);
        }
        return (HttpRequestHistoryManager)project.getService(HttpRequestHistoryManager.class);
    }

    @RequiresReadLock
    @NotNull
    public String getLogDirectoryPath() {
        ThreadingAssertions.softAssertReadAccess();
        SmartPsiElementPointer<HttpRequestPsiFile> logFilePointer = this.myLogFilePointer.get();
        if (logFilePointer != null) {
            String directory;
            HttpRequestPsiFile file = (HttpRequestPsiFile)logFilePointer.getElement();
            String string = directory = file != null ? PathUtil.getParentPath((String)file.getVirtualFile().getPath()) : null;
            if (StringUtil.isNotEmpty((String)directory)) {
                String string2 = directory;
                if (string2 == null) {
                    HttpRequestHistoryManager.$$$reportNull$$$0(2);
                }
                return string2;
            }
        }
        String string = HttpRequestHistoryManager.getDefaultDirectoryPath(this.myProject).toString().replace(File.separatorChar, '/');
        if (string == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static Path getDefaultDirectoryPath(@NotNull Project project) {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(4);
        }
        Path path2 = ProjectKt.getStateStore((Project)project).getProjectFilePath().getParent().resolve(DEFAULT_HTTP_REQUESTS_ROOT);
        if (path2 == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(5);
        }
        return path2;
    }

    @Contract(value="_, _, true -> !null")
    @Nullable
    public static VirtualFile findFile(@NotNull Project project, @NotNull String fileName, boolean waitCreation) throws IOException {
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(7);
        }
        Path rootPath = HttpRequestHistoryManager.getDefaultDirectoryPath(project);
        VirtualFile file = LocalFileSystem.getInstance().findFileByNioFile(rootPath.resolve(fileName));
        if (file != null && !file.isDirectory()) {
            return file;
        }
        if (waitCreation) {
            return (VirtualFile)HttpRequestUpdateManager.computeUpdateAwareAction(project, IOException.class, () -> (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile dir = VfsUtil.createDirectoryIfMissing((String)rootPath.resolve(fileName).getParent().toString());
                return Objects.requireNonNull(dir).findOrCreateChildData((Object)LocalFileSystem.getInstance(), fileName);
            }));
        }
        ApplicationManager.getApplication().invokeLater(() -> HttpRequestUpdateManager.runUpdateAwareAction(project, () -> {
            try {
                WriteAction.compute(() -> {
                    VirtualFile dir = VfsUtil.createDirectoryIfMissing((String)rootPath.resolve(fileName).getParent().toString());
                    return Objects.requireNonNull(dir).findOrCreateChildData((Object)LocalFileSystem.getInstance(), fileName);
                });
            }
            catch (IOException e) {
                LOG.warn("Cannot create file " + fileName, (Throwable)e);
            }
        }), project.getDisposed());
        return null;
    }

    public void addToHistory(@NotNull CommonClientRequest request2, @Nullable String fileName) {
        if (request2 == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(8);
        }
        if (!request2.isLogResponse()) {
            return;
        }
        Runnable commandRunnable = () -> {
            HttpRequestPsiFile logFile;
            try {
                logFile = this.getLogFile();
            }
            catch (HttpRequestInvalidLogFileException e) {
                LOG.warn("Cannot save HTTP request because log file doesn't exists", (Throwable)e);
                HttpClientActionsUsage.REQUEST_ADDING_TO_HISTORY_FAILED_EVENT_ID.log((Object)e.getProblemType());
                return;
            }
            VirtualFile logDirectory2 = this.getDefaultResponseFilesDirectory((PsiFile)logFile);
            if (LOG.isDebugEnabled() && StringUtil.isNotEmpty((String)fileName)) {
                LOG.debug("Saved response output in '" + fileName + "'");
            }
            Runnable writeActionRunnable = () -> {
                PsiDocumentManager manager;
                Document document;
                String method = StringUtil.notNullize((String)request2.getHttpMethod());
                RequestExecutionSupport<?> executionSupport = RequestExecutionSupport.All.forContext(new RequestContext(method, false, request2.getScheme()));
                if (executionSupport == null) {
                    return;
                }
                boolean isForceOutputRedirect = request2.getOutputFilePath() != null && request2.getOutputFilePath().isForce();
                String text2 = executionSupport.getRequestConverter().toExternalForm(request2, !isForceOutputRedirect ? fileName : null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Saving: '" + text2 + "'");
                }
                if ((document = (manager = PsiDocumentManager.getInstance((Project)logFile.getProject())).getDocument((PsiFile)logFile)) != null) {
                    HttpRequestBlock[] requests2 = HttpRequestPsiUtils.getRequestBlocks((PsiFile)logFile);
                    if (requests2.length >= this.getMaxHistorySize()) {
                        if (logDirectory2 != null) {
                            HttpRequestUpdateManager.runUpdateAwareAction(this.myProject, () -> this.deleteHistoryFiles(logDirectory2, requests2[this.getMaxHistorySize() - 1]));
                        }
                        TextRange range = HttpRequestPsiUtils.getRequestsRange(requests2[this.getMaxHistorySize() - 1], requests2[requests2.length - 1]);
                        boolean hasNextElement = HttpRequestPsiUtils.getNextSiblingIgnoreWhitespace((PsiElement)requests2[requests2.length - 1], true) != null;
                        int endOffset = hasNextElement ? range.getEndOffset() : document.getTextLength();
                        document.deleteString(range.getStartOffset(), endOffset);
                    }
                    document.insertString(0, (CharSequence)text2);
                    HttpClientActionsUsage.REQUEST_ADDED_TO_HISTORY_EVENT_ID.log((Object)text2.length());
                    HttpRequestUpdateManager.runUpdateAwareAction(this.myProject, () -> manager.commitDocument(document));
                }
            };
            ApplicationManager.getApplication().runWriteAction(writeActionRunnable);
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, commandRunnable, HttpRequestHistoryManager.getActionTitle(), null, UndoConfirmationPolicy.DEFAULT, false);
    }

    @RequiresReadLock
    @Nullable
    protected VirtualFile getDefaultResponseFilesDirectory(@NotNull PsiFile logFile) {
        if (logFile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.softAssertReadAccess();
        return logFile.getParent() != null ? logFile.getParent().getVirtualFile() : null;
    }

    private void deleteHistoryFiles(@NotNull VirtualFile directory, @Nullable HttpRequestBlock request2) {
        if (directory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(10);
        }
        List<String> toDelete = HttpRequestHistoryManager.collectFilesToDelete(directory, request2);
        for (String path2 : toDelete) {
            try {
                VirtualFile response2 = directory.getFileSystem().findFileByPath(path2);
                if (response2 == null) {
                    LOG.debug("File with response output doesn't exists ('" + path2 + "')");
                    continue;
                }
                HttpClientResponseFileManager.getInstance(this.myProject).getFilesHolder$intellij_restClient().finishFormatting(response2);
                response2.delete((Object)this);
                LOG.debug("Deleted " + path2);
                if (request2 == null) continue;
                HttpRequestHistoryManager.deleteReferencesToFile(directory, response2, request2.getProject());
            }
            catch (Exception e) {
                LOG.warn("Cannot delete response output file ('" + path2 + "')", (Throwable)e);
            }
        }
    }

    private static void deleteReferencesToFile(@NotNull VirtualFile directory, @NotNull VirtualFile response2, @NotNull Project project) {
        if (directory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(11);
        }
        if (response2 == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(12);
        }
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(13);
        }
        LOG.debug("Want to delete references to " + response2.getName());
        ReadAction.nonBlocking(() -> HttpRequestHistoryManager.getHttpDifferenceFilePlow(directory, project, response2).map(SmartPointerManager::createPointer).toList()).inSmartMode(project).finishOnUiThread(ModalityState.defaultModalityState(), differenceFileReferences -> {
            if (differenceFileReferences.isEmpty()) {
                return;
            }
            WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                for (SmartPsiElementPointer differenceFilePointer : differenceFileReferences) {
                    HttpDifferenceFile differenceFile = (HttpDifferenceFile)differenceFilePointer.getElement();
                    if (differenceFile != null) {
                        differenceFile.delete();
                        continue;
                    }
                    LOG.warn("Lost element between actions" + differenceFilePointer);
                }
            });
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static Plow<HttpDifferenceFile> getHttpDifferenceFilePlow(@NotNull VirtualFile directory, @NotNull Project project, @NotNull VirtualFile response2) {
        if (directory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(14);
        }
        if (project == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(15);
        }
        if (response2 == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(16);
        }
        Plow plow = Plow.of(p -> SearchService.getInstance().searchWord(project, response2.getName()).inContexts(SearchContext.IN_CODE, new SearchContext[0]).inScope((SearchScope)HttpScratchRequestPostProcessor.getResponseReferencesSearchScope(project)).caseSensitive(false).buildLeafOccurrenceQuery().forEach(p)).filter(textOccurrence -> textOccurrence.getElement().getContainingFile() instanceof HttpRequestPsiFile).mapNotNull(textOccurence -> (HttpDifferenceFile)PsiTreeUtil.getParentOfType((PsiElement)textOccurence.getElement(), HttpDifferenceFile.class, (boolean)false)).filter(differenceFile -> {
            if (differenceFile.getFilePath() == null) {
                return false;
            }
            return FileUtil.pathsEqual((String)response2.getPath(), (String)HttpRequestHistoryManager.getAbsolutePath(directory, differenceFile.getFilePath()));
        });
        if (plow == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(17);
        }
        return plow;
    }

    @NotNull
    private static List<String> collectFilesToDelete(@NotNull VirtualFile directory, @Nullable HttpRequestBlock request2) {
        if (directory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(18);
        }
        SmartList paths2 = new SmartList();
        while (request2 != null) {
            List<HttpDifferenceFile> diffFiles = request2.getRequest().getDifferenceFileList();
            for (HttpDifferenceFile diffFile : diffFiles) {
                HttpFilePath filePath2 = diffFile.getFilePath();
                if (filePath2 == null || OSAgnosticPathUtil.isAbsolute((String)filePath2.getPresentablePath())) continue;
                String absolutePath = HttpRequestHistoryManager.getAbsolutePath(directory, filePath2);
                if (!FileUtil.isAncestor((String)directory.getPath(), (String)absolutePath, (boolean)false)) continue;
                paths2.add(absolutePath);
            }
            request2 = (HttpRequestBlock)PsiTreeUtil.getNextSiblingOfType((PsiElement)request2, HttpRequestBlock.class);
        }
        SmartList smartList = paths2;
        if (smartList == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    @NotNull
    private static String getAbsolutePath(@NotNull VirtualFile directory, @NotNull HttpFilePath filePath2) {
        if (directory == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(20);
        }
        if (filePath2 == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(21);
        }
        String presentablePath = PathUtil.toSystemIndependentName((String)filePath2.getPresentablePath());
        String string = FileUtil.toCanonicalPath((String)(directory.getPath() + "/" + presentablePath), (char)'/');
        if (string == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    protected int getMaxHistorySize() {
        return MathUtil.clamp((int)AdvancedSettings.getInt((String)CAPACITY_SETTING), (int)1, (int)10000);
    }

    @NotNull
    @RequiresReadLock
    public HttpRequestPsiFile getLogFile() throws HttpRequestInvalidLogFileException {
        HttpRequestPsiFile file2;
        SmartPsiElementPointer logFilePointer;
        ThreadingAssertions.softAssertReadAccess();
        while ((logFilePointer = this.myLogFilePointer.get()) == null || logFilePointer.getElement() == null) {
            try {
                VirtualFile parent;
                VirtualFile log = this.getLogFileInternal();
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(log);
                if (psiFile instanceof HttpRequestPsiFile) {
                    SmartPsiElementPointer newPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)((HttpRequestPsiFile)psiFile));
                    if (!this.myLogFilePointer.compareAndSet(logFilePointer, (SmartPsiElementPointer<HttpRequestPsiFile>)newPointer)) continue;
                    logFilePointer = newPointer;
                    break;
                }
                if (FileIndexFacade.getInstance((Project)this.myProject).isUnderIgnored(log)) {
                    parent = HttpRequestHistoryManager.getParentByCondition(log, (Condition<VirtualFile>)((Condition)file -> FileIndexFacade.getInstance((Project)this.myProject).isUnderIgnored(file)));
                    throw HttpRequestInvalidLogFileException.createIgnoredLogException(this.myProject, parent.getPath());
                }
                if (Registry.is((String)"ide.hide.excluded.files") && FileIndexFacade.getInstance((Project)this.myProject).isExcludedFile(log)) {
                    parent = HttpRequestHistoryManager.getParentByCondition(log, (Condition<VirtualFile>)((Condition)file -> FileIndexFacade.getInstance((Project)this.myProject).isExcludedFile(file)));
                    throw HttpRequestInvalidLogFileException.createExcludedLogException(parent.getPath());
                }
                if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)log)) {
                    throw HttpRequestInvalidLogFileException.createTooLargeLogFileException(this.myProject);
                }
                if (psiFile != null && log.isValid() && !log.isDirectory() && !this.myProject.isDefault()) {
                    throw HttpRequestInvalidLogFileException.createInvalidTypeException(this.myProject, psiFile.getFileType());
                }
                LOG.error("HTTP Requests Log file is invalid: " + psiFile + ". Path: '" + log.getPresentableUrl() + "', valid: " + log.isValid() + ", dir: " + log.isDirectory() + ", default project: " + this.myProject.isDefault());
                break;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                break;
            }
        }
        HttpRequestPsiFile httpRequestPsiFile = file2 = logFilePointer != null ? (HttpRequestPsiFile)logFilePointer.getElement() : null;
        if (file2 == null) {
            throw new HttpRequestInvalidLogFileException();
        }
        HttpRequestPsiFile httpRequestPsiFile2 = file2;
        if (httpRequestPsiFile2 == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(23);
        }
        return httpRequestPsiFile2;
    }

    @ApiStatus.Internal
    @Nullable
    public VirtualFile findLogFile() {
        Path rootPath = HttpRequestHistoryManager.getDefaultDirectoryPath(this.myProject);
        return LocalFileSystem.getInstance().findFileByNioFile(rootPath.resolve(DEFAULT_LOG_FILE_NAME));
    }

    @NotNull
    private VirtualFile getLogFileInternal() throws IOException {
        VirtualFile virtualFile = HttpRequestHistoryManager.findFile(this.myProject, DEFAULT_LOG_FILE_NAME, true);
        if (virtualFile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(24);
        }
        return virtualFile;
    }

    @ApiStatus.Internal
    public void ensureLogFileExists() {
        try {
            this.getLogFileInternal();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static VirtualFile getParentByCondition(@NotNull VirtualFile file, @NotNull Condition<VirtualFile> condition) {
        if (file == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(25);
        }
        if (condition == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(26);
        }
        VirtualFile target = file;
        while (file != null && condition.value((Object)file)) {
            target = file;
            file = file.getParent();
        }
        VirtualFile virtualFile = target;
        if (virtualFile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(27);
        }
        return virtualFile;
    }

    @TestOnly
    public void setLogFile(@NotNull HttpRequestPsiFile logfile) {
        if (logfile == null) {
            HttpRequestHistoryManager.$$$reportNull$$$0(28);
        }
        this.myLogFilePointer.set((SmartPsiElementPointer<HttpRequestPsiFile>)SmartPointerManager.getInstance((Project)logfile.getProject()).createSmartPsiElementPointer((PsiElement)logfile));
    }

    @NlsContexts.Command
    private static String getActionTitle() {
        return RestClientBundle.message("http.request.save.log.file.action.title", new Object[0]);
    }

    void cleanupLogFile() {
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName(RestClientBundle.message("http.request.clean.log.file.command.name", new Object[0])).run(() -> {
            VirtualFile logFile = this.findLogFile();
            if (logFile != null) {
                try {
                    logFile.delete((Object)this);
                }
                catch (IOException e) {
                    LOG.warn("Failed to delete log file", (Throwable)e);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 17, 19, 22, 23, 24, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestHistoryManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFile";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestHistoryManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDirectoryPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDirectoryPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpDifferenceFilePlow";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesToDelete";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFileInternal";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentByCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDirectoryPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResponseFilesDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteHistoryFiles";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteReferencesToFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getHttpDifferenceFilePlow";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesToDelete";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getParentByCondition";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setLogFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 17, 19, 22, 23, 24, 27 -> new IllegalStateException(string);
        };
    }
}

