/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestGlobalContext {
    private static final Logger LOG = Logger.getInstance(HttpRequestGlobalContext.class);
    private static final Map<String, HttpRequestGlobalContext> ourContexts = new HashMap<String, HttpRequestGlobalContext>();
    private final HttpClientVariables myGlobal = new HttpClientVariables();

    @NotNull
    public static synchronized HttpRequestGlobalContext getInstance(@NotNull Project project) {
        String projectName;
        if (project == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(0);
        }
        if (!ourContexts.containsKey(projectName = HttpRequestGlobalContext.getProjectNameKey(project))) {
            ourContexts.put(projectName, new HttpRequestGlobalContext());
            LOG.info("Global request context for '" + project.getName() + "' was created.");
        }
        HttpRequestGlobalContext httpRequestGlobalContext = ourContexts.get(projectName);
        if (httpRequestGlobalContext == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(1);
        }
        return httpRequestGlobalContext;
    }

    @NotNull
    private static String getProjectNameKey(@NotNull Project project) {
        HttpRequestExecutionHelperService service;
        if (project == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(2);
        }
        return (service = HttpRequestExecutionHelperService.getInstance()) != null ? service.getProjectNameKey(project) : "";
    }

    public boolean isEmpty() {
        return this.myGlobal.isEmpty();
    }

    @Nullable
    public String getValue(@NotNull String name) {
        if (name == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(3);
        }
        return this.myGlobal.get(name);
    }

    @NotNull
    public Collection<String> getAllVariables() {
        Set<String> set2 = this.myGlobal.myVariables.keySet();
        if (set2 == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @NotNull
    public HttpClientVariables getGlobal() {
        HttpClientVariables httpClientVariables = this.myGlobal;
        if (httpClientVariables == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(5);
        }
        return httpClientVariables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVariables";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectNameKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static class HttpClientVariables {
        private final ConcurrentMap<String, String> myVariables = new ConcurrentHashMap<String, String>();

        public boolean isEmpty() {
            return this.myVariables.isEmpty();
        }

        public void set(@NotNull String name, @NotNull String value) {
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(0);
            }
            if (value == null) {
                HttpClientVariables.$$$reportNull$$$0(1);
            }
            this.myVariables.put(name, value);
        }

        public String get(@NotNull String name) {
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(2);
            }
            return (String)this.myVariables.get(name);
        }

        public Map<String, String> getAllVars() {
            return this.myVariables;
        }

        public void clear(@NotNull String name) {
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(3);
            }
            this.myVariables.remove(name);
        }

        public void clearAll() {
            this.myVariables.clear();
        }

        public String toString() {
            return this.myVariables.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext$HttpClientVariables";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "set";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clear";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class HttpRequestGlobalContextProjectListener
    implements ProjectCloseListener {
        HttpRequestGlobalContextProjectListener() {
        }

        public void projectClosing(@NotNull Project project) {
            String closedProjectName;
            if (project == null) {
                HttpRequestGlobalContextProjectListener.$$$reportNull$$$0(0);
            }
            if (ourContexts.containsKey(closedProjectName = HttpRequestGlobalContext.getProjectNameKey(project))) {
                LOG.info("Global request context for '" + project.getName() + "' was disposed.");
                ourContexts.remove(closedProjectName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext$HttpRequestGlobalContextProjectListener", "projectClosing"));
        }
    }
}

