/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.lexer;

import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.lexer.HttpClientExtensionLexemesDefaultManager;
import com.intellij.httpClient.http.request.lexer.HttpClientExtensionLexemesManager;
import com.intellij.httpClient.http.request.lexer.HttpRequestLexerDistributionDetailsService;
import com.intellij.httpClient.http.request.lexer._HttpRequestFileLexer;
import com.intellij.httpClient.http.request.psi.HttpRequestStubElements;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsServiceImpl;", "Lcom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsService;", "()V", "fileVariablesAvailable", "", "(Z)V", "allSupportedMethods", "", "", "getDefaultMethod", "scheme", "getDefaultScheme", "method", "isAcceptedMethod", "tokenText", "provideExtensionsLexemesManager", "Lcom/intellij/httpClient/http/request/lexer/HttpClientExtensionLexemesManager;", "HttpClientExtensionLexemesManagerImpl", "intellij.httpClient.executor"})
@ApiStatus.Internal
public final class HttpRequestLexerDistributionDetailsServiceImpl
implements HttpRequestLexerDistributionDetailsService {
    private final boolean fileVariablesAvailable;

    public HttpRequestLexerDistributionDetailsServiceImpl(boolean fileVariablesAvailable) {
        this.fileVariablesAvailable = fileVariablesAvailable;
    }

    public HttpRequestLexerDistributionDetailsServiceImpl() {
        this(Registry.is((String)"http.client.file.variables.available"));
    }

    @Override
    @NotNull
    public HttpClientExtensionLexemesManager provideExtensionsLexemesManager() {
        return new HttpClientExtensionLexemesManagerImpl(this.fileVariablesAvailable);
    }

    @Override
    public boolean isAcceptedMethod(@Nullable String tokenText) {
        if (tokenText == null) {
            return false;
        }
        if (!ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(RequestExecutionSupport.All.getEP_NAME().getName())) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return HttpClientExtensionLexemesDefaultManager.getMethods().contains(tokenText);
            }
            return false;
        }
        return RequestExecutionSupport.All.allSupportedMethods().contains(tokenText);
    }

    @Override
    @NotNull
    public Collection<String> allSupportedMethods() {
        return RequestExecutionSupport.All.allSupportedMethods();
    }

    @Override
    @Nullable
    public String getDefaultScheme(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return RequestExecutionSupport.All.getDefaultScheme(method);
    }

    @Override
    @Nullable
    public String getDefaultMethod(@NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return RequestExecutionSupport.All.getDefaultMethod(scheme);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsServiceImpl$HttpClientExtensionLexemesManagerImpl;", "Lcom/intellij/httpClient/http/request/lexer/HttpClientExtensionLexemesManager;", "isFileVariablesAvailable", "", "(Z)V", "currentExecutionSupport", "", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "()Z", "getSchemeType", "Lcom/intellij/httpClient/http/request/lexer/HttpClientExtensionLexemesManager$SchemeType;", "lexer", "Lcom/intellij/httpClient/http/request/lexer/_HttpRequestFileLexer;", "isMethod", "reset", "", "tryFindAndRememberExecutorsForSchema", "schema", "", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestLexerDistributionDetailsServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestLexerDistributionDetailsServiceImpl.kt\ncom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsServiceImpl$HttpClientExtensionLexemesManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1360#2:87\n1446#2,5:88\n*S KotlinDebug\n*F\n+ 1 HttpRequestLexerDistributionDetailsServiceImpl.kt\ncom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsServiceImpl$HttpClientExtensionLexemesManagerImpl\n*L\n70#1:87\n70#1:88,5\n*E\n"})
    private static final class HttpClientExtensionLexemesManagerImpl
    implements HttpClientExtensionLexemesManager {
        private final boolean isFileVariablesAvailable;
        @NotNull
        private List<? extends RequestExecutionSupport<?>> currentExecutionSupport;

        public HttpClientExtensionLexemesManagerImpl(boolean isFileVariablesAvailable) {
            this.isFileVariablesAvailable = isFileVariablesAvailable;
            this.currentExecutionSupport = CollectionsKt.emptyList();
        }

        @Override
        public boolean isFileVariablesAvailable() {
            return this.isFileVariablesAvailable;
        }

        @Override
        public void reset() {
            this.currentExecutionSupport = CollectionsKt.emptyList();
        }

        @Override
        public boolean isMethod(@NotNull _HttpRequestFileLexer lexer) {
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            CharSequence method = lexer.yytext();
            if (HttpRequestStubElements.isAcceptedMethod(method)) {
                this.currentExecutionSupport = RequestExecutionSupport.All.forMethod(method);
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HttpClientExtensionLexemesManager.SchemeType getSchemeType(@NotNull _HttpRequestFileLexer lexer) {
            CharSequence text2;
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            CharSequence charSequence = text2 = lexer.yytext();
            String strText = charSequence != null ? ((Object)charSequence).toString() : null;
            this.tryFindAndRememberExecutorsForSchema(strText);
            List<? extends RequestExecutionSupport<?>> support = this.currentExecutionSupport;
            if (!((Collection)support).isEmpty()) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = support;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    RequestExecutionSupport it = (RequestExecutionSupport)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getSupportedSchemes();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                if (CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)strText)) {
                    HttpClientExtensionLexemesManager.SchemeType schemeType = HttpClientExtensionLexemesManager.Companion.httpScheme(strText);
                    if (schemeType == null) {
                        schemeType = HttpClientExtensionLexemesManager.SchemeType.CUSTOM;
                    }
                    return schemeType;
                }
            } else {
                HttpClientExtensionLexemesManager.SchemeType schemeType = HttpClientExtensionLexemesManager.Companion.httpScheme(strText);
                if (schemeType == null) {
                    schemeType = HttpClientExtensionLexemesManager.SchemeType.NONE;
                }
                return schemeType;
            }
            return HttpClientExtensionLexemesManager.SchemeType.NONE;
        }

        private final void tryFindAndRememberExecutorsForSchema(String schema) {
            if (this.currentExecutionSupport.isEmpty() && schema != null) {
                this.currentExecutionSupport = RequestExecutionSupport.All.forSchema(schema);
            }
        }
    }
}

