/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.UsedColors;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.highlighting.HttpRequestRainbowVisitor;
import com.intellij.httpClient.http.request.highlighting.HttpRequestSyntaxHighlighter;
import com.intellij.httpClient.http.request.psi.HttpFileVariable;
import com.intellij.httpClient.http.request.psi.HttpKeyValueElement;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.psi.references.HttpVariableInMessageBodyReferenceProvider;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J2\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/http/request/highlighting/HttpRequestRainbowVisitor;", "Lcom/intellij/codeInsight/daemon/RainbowVisitor;", "()V", "clone", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "getInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "context", "Lcom/intellij/psi/PsiElement;", "rainbowElement", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "name", "", "colorKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "suitableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "visit", "", "element", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestRainbowVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestRainbowVisitor.kt\ncom/intellij/httpClient/http/request/highlighting/HttpRequestRainbowVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n4098#2,11:101\n*S KotlinDebug\n*F\n+ 1 HttpRequestRainbowVisitor.kt\ncom/intellij/httpClient/http/request/highlighting/HttpRequestRainbowVisitor\n*L\n55#1:101,11\n*E\n"})
public final class HttpRequestRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof HttpRequestPsiFile;
    }

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull PsiElement element) {
        Object identifier;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof HttpFileVariable) {
            identifier = ((HttpFileVariable)element).getNameIdentifier();
            if (((HttpFileVariable)element).getName() == null || identifier == null) {
                return;
            }
            PsiElement psiElement = (PsiElement)((HttpFileVariable)element).getContainingFile();
            String string = ((HttpFileVariable)element).getName();
            Intrinsics.checkNotNull((Object)string);
            this.addInfo(this.getInfo(psiElement, (PsiElement)identifier, string, HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_NAME));
        }
        if (element instanceof HttpVariable) {
            identifier = ((HttpVariable)element).getNameIdentifier();
            if (identifier == null) {
                return;
            }
            ResolveResult[] resolveResultArray = ((HttpVariable)element).multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            ResolveResult[] elements = resolveResultArray;
            if (elements.length != 1) {
                return;
            }
            PsiElement resolved = elements[0].getElement();
            if (!(resolved instanceof HttpFileVariable) || ((HttpFileVariable)resolved).getName() == null) {
                return;
            }
            PsiElement psiElement = (PsiElement)((HttpVariable)element).getContainingFile();
            String string = ((HttpFileVariable)resolved).getName();
            Intrinsics.checkNotNull((Object)string);
            this.addInfo(this.getInfo(psiElement, (PsiElement)identifier, string, HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_NAME));
        }
        if (element instanceof HttpMessageBody) {
            void $this$filterIsInstanceTo$iv$iv;
            PsiReference[] psiReferenceArray = ((HttpMessageBody)element).getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            Object[] $this$filterIsInstance$iv = psiReferenceArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof HttpVariableInMessageBodyReferenceProvider.HttpVariableInMessageBodyReference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (HttpVariableInMessageBodyReferenceProvider.HttpVariableInMessageBodyReference variableReference : (List)destination$iv$iv) {
                String name;
                ResolveResult[] resolveResultArray = variableReference.multiResolve(false);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                ResolveResult resolveResult = (ResolveResult)ArraysKt.singleOrNull((Object[])resolveResultArray);
                Object resolved = resolveResult != null ? resolveResult.getElement() : null;
                if (!(resolved instanceof HttpFileVariable) || ((HttpFileVariable)resolved).getName() == null) continue;
                PsiFile psiFile = ((HttpMessageBody)element).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                PsiElement psiElement = (PsiElement)psiFile;
                TextRange textRange = variableReference.getRangeInElement();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
                TextAttributesKey textAttributesKey = HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"HTTP_REQUEST_FILE_VARIABLE_NAME");
                this.addInfo(this.getInfo(psiElement, element, textRange, name, textAttributesKey));
            }
        }
        HttpKeyValueElement httpKeyValueElement = element instanceof HttpKeyValueElement ? (HttpKeyValueElement)element : null;
        if (httpKeyValueElement == null) {
            return;
        }
        HttpKeyValueElement keyValueElement = httpKeyValueElement;
        PsiElement context = ((HttpKeyValueElement)element).getParent();
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.empty();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"empty(...)");
        String key2 = keyValueElement.getKey(httpRequestVariableSubstitutor);
        PsiElement psiElement = keyValueElement.getKeyElement().getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        Sequence elementsToHighlight2 = SequencesKt.filter((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null), (Function1)visit.elementsToHighlight.1.INSTANCE);
        for (PsiElement elementToHighlight : elementsToHighlight2) {
            this.addInfo(this.getInfo(context, elementToHighlight, key2, HttpRequestSyntaxHighlighter.HTTP_REQUEST_PARAMETER_NAME));
        }
    }

    @NotNull
    public HighlightVisitor clone() {
        return (HighlightVisitor)new HttpRequestRainbowVisitor();
    }

    private final HighlightInfo getInfo(PsiElement context, PsiElement rainbowElement, TextRange rangeInElement, String name, TextAttributesKey colorKey) {
        UserDataHolderEx userDataHolderEx = (UserDataHolderEx)context;
        Intrinsics.checkNotNull((Object)userDataHolderEx);
        int colorIndex = UsedColors.getOrAddColorIndex((UserDataHolderEx)userDataHolderEx, (String)name, (int)this.getHighlighter().getColorsCount());
        TextRange textRange = rangeInElement.shiftRight(rainbowElement.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        TextRange rangeToHighlight = textRange;
        return this.getHighlighter().getInfo(colorIndex, rangeToHighlight.getStartOffset(), rangeToHighlight.getEndOffset(), colorKey);
    }
}

