/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.highlighting;

import com.intellij.httpClient.RestClientIcons;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.httpClient.http.request.highlighting.HttpRequestSyntaxHighlighter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class HttpRequestColorSettingsPage
implements RainbowColorSettingsPage {
    private static final AttributesDescriptor @NotNull [] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.request.port", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_PORT), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.request.parameter.name", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_PARAMETER_NAME), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.request.parameter.value", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_PARAMETER_VALUE), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.header.field.key", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_HEADER_FIELD_NAME), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.header.field.value", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_HEADER_FIELD_VALUE), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.comment", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_COMMENT), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.doc.comment.tag", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_DOC_COMMENT_TAG), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.requests.separator", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_SEPARATOR), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.request.name", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_NAME), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.method.type", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_METHOD_TYPE), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.header.message.body", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_BODY), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.header.input.file.sign", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_INPUT_SIGN), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.header.input.file.path", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_INPUT_FILE), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.header.difference.file.sign", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_DIFFERENCE_SIGN), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.header.difference.file.path", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_DIFFERENCE_FILE), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.multipart.boundary", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_MULTIPART_BOUNDARY), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.environment.variable", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_ENVIRONMENT_VARIABLE), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.variable.braces", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_VARIABLE_BRACES), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.escaped.value", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_ESCAPED_VALUE), new AttributesDescriptor(RestClientBundle.message("http.request.highlighting.scripts", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_SCRIPT), new AttributesDescriptor(RestClientBundle.messagePointer("http.request.highlighting.file.variable.begin", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_BEGIN), new AttributesDescriptor(RestClientBundle.messagePointer("http.request.highlighting.file.variable.name", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_NAME), new AttributesDescriptor(RestClientBundle.messagePointer("http.request.highlighting.file.variable.value", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_VALUE), new AttributesDescriptor(RestClientBundle.messagePointer("http.request.highlighting.dynamic.variable.number", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_DYNAMIC_VARIABLE_NUMBER), new AttributesDescriptor(RestClientBundle.messagePointer("http.request.highlighting.dynamic.variable.string", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_DYNAMIC_VARIABLE_STRING), new AttributesDescriptor(RestClientBundle.messagePointer("http.request.highlighting.protocol", new Object[0]), HttpRequestSyntaxHighlighter.HTTP_REQUEST_PROTOCOL)};

    HttpRequestColorSettingsPage() {
    }

    @NotNull
    public String getDisplayName() {
        String string = RestClientBundle.message("http.request.action.name", new Object[0]);
        if (string == null) {
            HttpRequestColorSettingsPage.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return RestClientIcons.Http_requests_filetype;
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATTRS == null) {
            HttpRequestColorSettingsPage.$$$reportNull$$$0(1);
        }
        return ATTRS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            HttpRequestColorSettingsPage.$$$reportNull$$$0(2);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new HttpRequestSyntaxHighlighter();
    }

    @NotNull
    public String getDemoText() {
        String string = "@<vname>variable_name</vname> = 123 variable value 456\\u2026\n###\n<comment># Line comments started with hash symbol are allowed</comment>\n<comment>// As well as comments started with two slashes\n</comment>POST http://127.0.0.1:8080/add-value\nContent-Type: application/json\n\n{\n  \"name-key\": \"new-name\",\n  \"content-key\": \"content\"\n}\n\n### <name>First separator's content is treaded as request name</name>\n### Other request separators can contain comments\nPOST http://{{host}}:8080/update-value?<param>id</param>={{item-id}} HTTP/2\nContent-Type: application/json\nX-Request-Id: {{$random.integer(10, 1000)}}\n\n< ./input-file.json\n\n###\n<comment># <comment_tag>@name</comment_tag> <name>Also request name can be provided by 'name' doc comment</name></comment>\nGET http://example.site.com/show-value?<param>name-key</param>=new-name\nFrom: user@example.com\nAuthentication: Bearer {{$auth.token(\"my-auth\")}}\n\n>> myFolder/response.txt\n\n<> response-output-history.200.json\n\n###\n<comment># There are another doc comments</comment>\n<comment>#<comment_tag>@no-cookie-jar</comment_tag></comment>\n<comment>#<comment_tag>@no-log</comment_tag></comment>\nPOST http://127.0.0.1:8080/upload\nContent-Type: multipart/form-data; boundary=WebAppBoundary\n\n--WebAppBoundary\nContent-Disposition: form-data; name=\"file\"; filename=\"inputfile.txt\"\n\n< ./real-file-to-upload.txt\n--WebAppBoundary\n\n###\nPOST http://example.site.com/prove-equation\nContent-Type: application/x-www-form-urlencoded\n\n<body><param>equation</param> = <pvalue>10</pvalue><esc>%%</esc> <esc>%+</esc> <pvalue>12</pvalue><esc>%%</esc> <esc>%=</esc> <pvalue>22</pvalue><esc>%%</esc>&\n<param>proveMethod</param>=<pvalue>full</pvalue><esc>+</esc><pvalue>substitutor</pvalue></body>\n\n###\nGET http://{{host}}/get-response\n\n> {%" + HttpRequestColorSettingsPage.wrapJsTokens("\n", "    ", "client", ".", "log", "(", "\"Hello, World\"", ")", "\n") + "%}";
        if (string == null) {
            HttpRequestColorSettingsPage.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return Map.of("name", HttpRequestSyntaxHighlighter.HTTP_REQUEST_NAME, "comment", HttpRequestSyntaxHighlighter.HTTP_REQUEST_COMMENT, "comment_tag", HttpRequestSyntaxHighlighter.HTTP_REQUEST_DOC_COMMENT_TAG, "body", HttpRequestSyntaxHighlighter.HTTP_REQUEST_BODY, "param", HttpRequestSyntaxHighlighter.HTTP_REQUEST_PARAMETER_NAME, "esc", HttpRequestSyntaxHighlighter.HTTP_REQUEST_ESCAPED_VALUE, "pvalue", HttpRequestSyntaxHighlighter.HTTP_REQUEST_PARAMETER_VALUE, "script", HttpRequestSyntaxHighlighter.HTTP_REQUEST_SCRIPT, "vname", HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_NAME);
    }

    public boolean isRainbowType(TextAttributesKey type) {
        return HttpRequestSyntaxHighlighter.HTTP_REQUEST_PARAMETER_NAME.equals((Object)type);
    }

    @NotNull
    public Language getLanguage() {
        HttpRequestLanguage httpRequestLanguage = HttpRequestLanguage.INSTANCE;
        if (httpRequestLanguage == null) {
            HttpRequestColorSettingsPage.$$$reportNull$$$0(4);
        }
        return httpRequestLanguage;
    }

    @NotNull
    private static String wrapJsTokens(String ... tokens) {
        if (tokens == null) {
            HttpRequestColorSettingsPage.$$$reportNull$$$0(5);
        }
        String string = Arrays.stream(tokens).map(token -> "<script>" + token + "</script>").collect(Collectors.joining());
        if (string == null) {
            HttpRequestColorSettingsPage.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/highlighting/HttpRequestColorSettingsPage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDemoText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/highlighting/HttpRequestColorSettingsPage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapJsTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapJsTokens";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

