/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment.secrets;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.environment.HttpRequestIndex;
import com.intellij.httpClient.http.request.environment.secrets.HttpClientSecrets;
import com.intellij.httpClient.http.request.environment.secrets.HttpRequestEnvironmentPasswordSafeSecretsManager;
import com.intellij.httpClient.http.request.environment.secrets.HttpRequestEnvironmentSecretsManager;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J:\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0018J2\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0013H\u0002J0\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/httpClient/http/request/environment/secrets/HttpRequestEnvironmentPasswordSafeSecretsManager;", "Lcom/intellij/httpClient/http/request/environment/secrets/HttpRequestEnvironmentSecretsManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "listener", "Lkotlin/Function0;", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "cleanFromNonExistentEnvironments", "secretsObject", "Lcom/intellij/httpClient/http/request/environment/secrets/HttpClientSecrets;", "isScratch", "", "(Lcom/intellij/httpClient/http/request/environment/secrets/HttpClientSecrets;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "credentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "getOrCreateSecret", "", "envName", "valueName", "presentableName", "forceAsk", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSecret", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSecretObject", "secrets", "setSecret", "testingMode", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestEnvironmentPasswordSafeSecretsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestEnvironmentPasswordSafeSecretsManager.kt\ncom/intellij/httpClient/http/request/environment/secrets/HttpRequestEnvironmentPasswordSafeSecretsManager\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n50#2:142\n43#2:143\n9#3:144\n766#4:145\n857#4,2:146\n*S KotlinDebug\n*F\n+ 1 HttpRequestEnvironmentPasswordSafeSecretsManager.kt\ncom/intellij/httpClient/http/request/environment/secrets/HttpRequestEnvironmentPasswordSafeSecretsManager\n*L\n92#1:142\n92#1:143\n95#1:144\n107#1:145\n107#1:146,2\n*E\n"})
public final class HttpRequestEnvironmentPasswordSafeSecretsManager
implements HttpRequestEnvironmentSecretsManager {
    @NotNull
    private final Project project;
    @Nullable
    private Function0<Unit> listener;
    @NotNull
    private final ObjectMapper objectMapper;

    public HttpRequestEnvironmentPasswordSafeSecretsManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
    }

    @Override
    @Nullable
    public Object getSecret(@NotNull String envName, @NotNull String valueName, @Nls @NotNull String presentableName, boolean isScratch, @NotNull Continuation<? super String> $completion) {
        return this.getOrCreateSecret(envName, valueName, presentableName, isScratch, false, $completion);
    }

    @Override
    @Nullable
    public Object setSecret(@NotNull String envName, @NotNull String valueName, @Nls @NotNull String presentableName, boolean isScratch, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.getOrCreateSecret(envName, valueName, presentableName, isScratch, true, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @TestOnly
    public final void testingMode(@NotNull Disposable parentDisposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Disposer.register((Disposable)parentDisposable, () -> HttpRequestEnvironmentPasswordSafeSecretsManager.testingMode$lambda$0(this));
        this.listener = listener2;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getOrCreateSecret(String var1_1, String var2_2, @Nls String var3_3, boolean var4_4, boolean var5_5, Continuation<? super String> var6_6) {
        if (!(var6_6 instanceof getOrCreateSecret.1)) ** GOTO lbl-1000
        var13_7 = var6_6;
        if ((var13_7.label & -2147483648) != 0) {
            var13_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ HttpRequestEnvironmentPasswordSafeSecretsManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpRequestEnvironmentPasswordSafeSecretsManager.access$getOrCreateSecret(this.this$0, null, null, null, false, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                attributes = this.credentialAttributes(isScratch != false);
                secrets = PasswordSafe.Companion.getInstance().getPassword(attributes);
                httpClientSecrets = this.getSecretObject(secrets);
                requestedSecret = httpClientSecrets.get(envName, valueName);
                if (requestedSecret != null && forceAsk == false) {
                    return requestedSecret;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = envName;
                $continuation.L$2 = valueName;
                $continuation.L$3 = attributes;
                $continuation.L$4 = httpClientSecrets;
                $continuation.Z$0 = isScratch;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>((String)presentableName, null){
                    int label;
                    final /* synthetic */ String $presentableName;
                    {
                        this.$presentableName = $presentableName;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Object[] objectArray = new Object[]{this.$presentableName};
                                return Messages.showPasswordDialog((String)RestClientBundle.message("http.request.secrets.dialog.message", objectArray), (String)RestClientBundle.message("http.request.secrets.dialog.title", new Object[0]));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var14_9) {
                    return var14_9;
                }
                ** GOTO lbl38
            }
            case 1: {
                isScratch = $continuation.Z$0;
                httpClientSecrets = (HttpClientSecrets)$continuation.L$4;
                attributes = (CredentialAttributes)$continuation.L$3;
                valueName = (String)$continuation.L$2;
                envName = (String)$continuation.L$1;
                this = (HttpRequestEnvironmentPasswordSafeSecretsManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                if ((newSecretValue = (String)v0) == null) ** GOTO lbl62
                httpClientSecrets.set(envName, valueName, newSecretValue);
                $continuation.L$0 = this;
                $continuation.L$1 = attributes;
                $continuation.L$2 = httpClientSecrets;
                $continuation.L$3 = newSecretValue;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v1 = this.cleanFromNonExistentEnvironments(httpClientSecrets, isScratch != false, (Continuation<? super Unit>)$continuation);
                if (v1 == var14_9) {
                    return var14_9;
                }
                ** GOTO lbl57
            }
            case 2: {
                newSecretValue = (String)$continuation.L$3;
                httpClientSecrets = (HttpClientSecrets)$continuation.L$2;
                attributes = (CredentialAttributes)$continuation.L$1;
                this = (HttpRequestEnvironmentPasswordSafeSecretsManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl57:
                // 2 sources

                PasswordSafe.Companion.getInstance().setPassword(attributes, this.objectMapper.writeValueAsString((Object)httpClientSecrets));
                v2 = this.listener;
                if (v2 != null) {
                    v2.invoke();
                }
lbl62:
                // 4 sources

                return newSecretValue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CredentialAttributes credentialAttributes(boolean isScratch) {
        String string;
        if (!isScratch) {
            string = ProjectUtil.guessProjectDir((Project)this.project);
            if (string == null || (string = string.getPresentableUrl()) == null) {
                string = this.project.getName();
            }
        } else {
            string = "Scratches";
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String projectId = string2;
        String serviceName = CredentialAttributesKt.generateServiceName((String)"HTTP Client", (String)projectId);
        return new CredentialAttributes(serviceName, null, null, false, 14, null);
    }

    private final HttpClientSecrets getSecretObject(String secrets) {
        HttpClientSecrets httpClientSecrets;
        if (secrets != null) {
            HttpClientSecrets httpClientSecrets2;
            try {
                ObjectMapper $this$readValue$iv = this.objectMapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                httpClientSecrets2 = (HttpClientSecrets)$this$readValue$iv.readValue(secrets, (TypeReference)new TypeReference<HttpClientSecrets>(){});
            }
            catch (JsonProcessingException jsonProcessingException) {
                HttpRequestEnvironmentPasswordSafeSecretsManager $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(HttpRequestEnvironmentPasswordSafeSecretsManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Invalid secrets are stored. Cleaning them");
                httpClientSecrets2 = new HttpClientSecrets(new LinkedHashMap());
            }
            httpClientSecrets = httpClientSecrets2;
        } else {
            httpClientSecrets = new HttpClientSecrets(new LinkedHashMap());
        }
        return httpClientSecrets;
    }

    /*
     * Unable to fully structure code
     */
    private final Object cleanFromNonExistentEnvironments(HttpClientSecrets var1_1, boolean var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof cleanFromNonExistentEnvironments.1)) ** GOTO lbl-1000
        var17_4 = var3_3;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ HttpRequestEnvironmentPasswordSafeSecretsManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpRequestEnvironmentPasswordSafeSecretsManager.access$cleanFromNonExistentEnvironments(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = isScratch != false ? ScratchesSearchScope.getScratchesScope((Project)this.project) : GlobalSearchScope.projectScope((Project)this.project);
                Intrinsics.checkNotNull((Object)var5_7);
                scope = var5_7;
                $continuation.L$0 = secretsObject;
                $continuation.label = 1;
                v0 = CoroutinesKt.smartReadAction((Project)this.project, (Function0)((Function0)new Function0<Collection<String>>(this, scope){
                    final /* synthetic */ HttpRequestEnvironmentPasswordSafeSecretsManager this$0;
                    final /* synthetic */ GlobalSearchScope $scope;
                    {
                        this.this$0 = $receiver;
                        this.$scope = $scope;
                        super(0);
                    }

                    @NotNull
                    public final Collection<String> invoke() {
                        return HttpRequestIndex.getAllEnvironments(HttpRequestEnvironmentPasswordSafeSecretsManager.access$getProject$p(this.this$0), this.$scope);
                    }
                }), (Continuation)$continuation);
                if (v0 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                secretsObject = (HttpClientSecrets)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"smartReadAction(...)");
                existingEnvs = CollectionsKt.toSet((Iterable)((Iterable)v0));
                $this$filter$iv = secretsObject.getEnvironments().keySet();
                $i$f$filter = false;
                var9_11 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-filter-HttpRequestEnvironmentPasswordSafeSecretsManager$cleanFromNonExistentEnvironments$2 = false;
                    if (!(existingEnvs.contains(it) == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (String invalidEnv : (List)destination$iv$iv) {
                    secretsObject.getEnvironments().remove(invalidEnv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void testingMode$lambda$0(HttpRequestEnvironmentPasswordSafeSecretsManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.listener = null;
    }

    public static final /* synthetic */ Object access$getOrCreateSecret(HttpRequestEnvironmentPasswordSafeSecretsManager $this, String envName, String valueName, String presentableName, boolean isScratch, boolean forceAsk, Continuation $completion) {
        return $this.getOrCreateSecret(envName, valueName, presentableName, isScratch, forceAsk, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$cleanFromNonExistentEnvironments(HttpRequestEnvironmentPasswordSafeSecretsManager $this, HttpClientSecrets secretsObject, boolean isScratch, Continuation $completion) {
        return $this.cleanFromNonExistentEnvironments(secretsObject, isScratch, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(HttpRequestEnvironmentPasswordSafeSecretsManager $this) {
        return $this.project;
    }
}

