/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.httpClient.http.request.HttpClientCoroutinesService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="HttpClientSelectedEnvironments", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0001\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0002J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u001b\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0086\u0002R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/httpClient/http/request/environment/HttpClientSelectedEnvironments;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "pointers", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerContainer;", "Lorg/jetbrains/annotations/NotNull;", "selectedEnvironments", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "", "dispose", "", "get", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getState", "hasFileAnySelection", "", "hasFileAnySelection$intellij_restClient", "loadState", "state", "set", "env", "Companion", "intellij.restClient"})
public final class HttpClientSelectedEnvironments
implements PersistentStateComponent<Element>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFilePointer, String> selectedEnvironments;
    @NotNull
    private final VirtualFilePointerContainer pointers;
    @NotNull
    public static final String SELECT_BEFORE_RUN = "";

    public HttpClientSelectedEnvironments(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.selectedEnvironments = new LinkedHashMap();
        VirtualFilePointerContainer virtualFilePointerContainer = VirtualFilePointerManager.getInstance().createContainer((Disposable)this, new VirtualFilePointerListener(this){
            final /* synthetic */ HttpClientSelectedEnvironments this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void validityChanged(@NotNull VirtualFilePointer[] pointers2) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)pointers2, (String)"pointers");
                VirtualFilePointer[] $this$filter$iv = pointers2;
                boolean $i$f$filter = false;
                VirtualFilePointer[] virtualFilePointerArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!(!it.isValid())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (VirtualFilePointer pointer : (List)destination$iv$iv) {
                    HttpClientSelectedEnvironments.access$getSelectedEnvironments$p(this.this$0).remove(pointer);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointerContainer, (String)"createContainer(...)");
        this.pointers = virtualFilePointerContainer;
    }

    public final boolean hasFileAnySelection$intellij_restClient(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.pointers.findByUrl(file.getUrl()) != null;
    }

    @Nullable
    public final String get(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFilePointer virtualFilePointer = this.pointers.findByUrl(file.getUrl());
        if (virtualFilePointer == null) {
            return null;
        }
        VirtualFilePointer pointer = virtualFilePointer;
        return this.selectedEnvironments.get(pointer);
    }

    public final void set(@NotNull VirtualFile file, @Nullable String env) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.pointers.add(file);
            VirtualFilePointer virtualFilePointer = this.pointers.findByUrl(file.getUrl());
            if (virtualFilePointer == null) {
                return;
            }
            VirtualFilePointer pointer = virtualFilePointer;
            this.selectedEnvironments.put(pointer, env);
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file);
            if (psiFile == null) break block1;
            PsiFile it = psiFile;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)HttpClientCoroutinesService.scope$default(HttpClientCoroutinesService.Companion.getInstance(this.project), null, 1, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, it, null){
                int label;
                final /* synthetic */ HttpClientSelectedEnvironments this$0;
                final /* synthetic */ PsiFile $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = CoroutinesKt.readAction((Function0)((Function0)new Function0<Unit>(this.this$0, this.$it){
                                final /* synthetic */ HttpClientSelectedEnvironments this$0;
                                final /* synthetic */ PsiFile $it;
                                {
                                    this.this$0 = $receiver;
                                    this.$it = $it;
                                    super(0);
                                }

                                public final void invoke() {
                                    DaemonCodeAnalyzer.getInstance((Project)HttpClientSelectedEnvironments.access$getProject$p(this.this$0)).restart(this.$it);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public void dispose() {
    }

    @NotNull
    public Element getState() {
        Element element = new Element("files");
        for (Map.Entry<VirtualFilePointer, String> entry : this.selectedEnvironments.entrySet()) {
            VirtualFilePointer file = entry.getKey();
            String env = entry.getValue();
            Element fileElement = new Element("file");
            fileElement.setAttribute("url", file.getUrl());
            if (env != null) {
                fileElement.setAttribute("environment", env);
            }
            element.addContent(fileElement);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map selectedEnvironments = new LinkedHashMap();
        for (Element child : state.getChildren("file")) {
            VirtualFilePointer pointer;
            String url;
            Attribute attribute = child.getAttribute("url");
            if ((attribute != null ? attribute.getValue() : null) == null) continue;
            url = url;
            Attribute attribute2 = child.getAttribute("environment");
            String env = attribute2 != null ? attribute2.getValue() : null;
            this.pointers.add(url);
            if (this.pointers.findByUrl(url) == null) continue;
            selectedEnvironments.put(pointer, env);
        }
        this.selectedEnvironments.putAll(selectedEnvironments);
    }

    @JvmStatic
    public static final boolean isSelectBeforeRun(@Nullable String env) {
        return Companion.isSelectBeforeRun(env);
    }

    @JvmStatic
    @NotNull
    public static final HttpClientSelectedEnvironments getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject$p(HttpClientSelectedEnvironments $this) {
        return $this.project;
    }

    public static final /* synthetic */ Map access$getSelectedEnvironments$p(HttpClientSelectedEnvironments $this) {
        return $this.selectedEnvironments;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0007J\u001b\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/http/request/environment/HttpClientSelectedEnvironments$Companion;", "", "()V", "SELECT_BEFORE_RUN", "", "get", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getInstance", "Lcom/intellij/httpClient/http/request/environment/HttpClientSelectedEnvironments;", "project", "Lcom/intellij/openapi/project/Project;", "isSelectBeforeRun", "", "env", "set", "", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpClientSelectedEnvironments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientSelectedEnvironments.kt\ncom/intellij/httpClient/http/request/environment/HttpClientSelectedEnvironments$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n31#2,2:112\n1#3:114\n*S KotlinDebug\n*F\n+ 1 HttpClientSelectedEnvironments.kt\ncom/intellij/httpClient/http/request/environment/HttpClientSelectedEnvironments$Companion\n*L\n65#1:112,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isSelectBeforeRun(@Nullable String env) {
            return Intrinsics.areEqual((Object)env, (Object)HttpClientSelectedEnvironments.SELECT_BEFORE_RUN);
        }

        @JvmStatic
        @NotNull
        public final HttpClientSelectedEnvironments getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<HttpClientSelectedEnvironments> serviceClass$iv = HttpClientSelectedEnvironments.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (HttpClientSelectedEnvironments)object;
        }

        @Nullable
        public final String get(@NotNull AnActionEvent e) {
            Object object;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    object = e.getProject();
                    if (object == null) break block4;
                    Project it = object;
                    boolean bl = false;
                    HttpClientSelectedEnvironments httpClientSelectedEnvironments = Companion.getInstance(it);
                    object = httpClientSelectedEnvironments;
                    if (httpClientSelectedEnvironments != null) break block5;
                }
                return null;
            }
            Object service = object;
            VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            return ((HttpClientSelectedEnvironments)service).get(file);
        }

        public final void set(@NotNull AnActionEvent e, @Nullable String env) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                boolean $i$a$-requireNotNull-HttpClientSelectedEnvironments$Companion$set$32 = false;
                String $i$a$-requireNotNull-HttpClientSelectedEnvironments$Companion$set$32 = "Event must have a project";
                throw new IllegalArgumentException($i$a$-requireNotNull-HttpClientSelectedEnvironments$Companion$set$32.toString());
            }
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (file == null) {
                boolean bl = false;
                String string = "Event must have a VirtualFile";
                throw new IllegalArgumentException(string.toString());
            }
            this.getInstance(project).set(file, env);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

