/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.httpClient.http.request.completion.HttpSuffixInsertHandler;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariableDescription;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariableValue;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariables;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.psi.HttpOutputFilePath;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.run.HttpRequestGlobalContext;
import com.intellij.httpClient.http.request.variables.HttpClientFileVariableStorage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class HttpVariableCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final HttpSuffixInsertHandler CLOSING_BRACES = new HttpSuffixInsertHandler("}}");
    private static final String DYNAMIC_SIGN = HttpRequestElementTypes.DYNAMIC_SIGN.toString();

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement element;
        if (parameters == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((element = parameters.getOriginalPosition()) != null) {
            this.addCompletions(parameters, result2, element, 0);
        }
    }

    protected abstract void fillVariables(@NotNull CompletionParameters var1, @NotNull CompletionResultSet var2, @NotNull PsiElement var3);

    void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull PsiElement element, int variableNameOffset) {
        TextRange range;
        if (parameters == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(5);
        }
        if ((range = element.getTextRange()).contains(parameters.getOffset()) || range.getEndOffset() == parameters.getOffset()) {
            int endOffset = parameters.getOffset() - range.getStartOffset();
            result2 = result2.withPrefixMatcher(endOffset != 0 ? element.getText().substring(variableNameOffset, endOffset) : "");
        }
        this.fillVariables(parameters, result2, element);
    }

    @NotNull
    @Contract(value="_ -> new")
    static HttpVariableCompletionProvider getProvider(@NotNull ProviderType providerType) {
        if (providerType == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(6);
        }
        return switch (providerType) {
            default -> throw new IncompatibleClassChangeError();
            case ProviderType.ENVIRONMENT_VARIABLE -> new HttpEnvironmentVariableCompletionProvider();
            case ProviderType.DYNAMIC_VARIABLE -> new HttpDynamicVariableCompletionProvider();
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpVariableCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum ProviderType {
        ENVIRONMENT_VARIABLE,
        DYNAMIC_VARIABLE;

    }

    private static class HttpEnvironmentVariableCompletionProvider
    extends HttpVariableCompletionProvider {
        private HttpEnvironmentVariableCompletionProvider() {
        }

        @Override
        protected void fillVariables(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull PsiElement element) {
            if (parameters == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (result2 == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (element == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            Project project = element.getProject();
            Set variables2 = StreamEx.of(HttpClientEnvironmentsProvider.INSTANCE.provideEnvironments(element.getContainingFile()).asList()).flatCollection(env -> env.getVariables()).toSet();
            List<String> fileVariables = HttpClientFileVariableStorage.Companion.listVariables(element.getContainingFile().getOriginalFile());
            HashSet<String> declaredVariable = new HashSet<String>(variables2);
            declaredVariable.addAll(fileVariables);
            HttpEnvironmentVariableCompletionProvider.fillEnvironmentVariables(result2, declaredVariable);
            HttpEnvironmentVariableCompletionProvider.fillEnvironmentVariables(result2, HttpRequestGlobalContext.getInstance(project).getAllVariables());
            HttpDynamicVariableCompletionProvider.fillDynamicVariables(result2, HttpClientDynamicVariableDescription.Position.ALL, true);
            if (PsiTreeUtil.getParentOfType((PsiElement)element, HttpOutputFilePath.class, (boolean)false) != null) {
                HttpDynamicVariableCompletionProvider.fillDynamicVariables(result2, HttpClientDynamicVariableDescription.Position.IN_FILE_PATH, true);
            }
        }

        private static void fillEnvironmentVariables(@NotNull CompletionResultSet result2, @NotNull Collection<String> variables2) {
            if (result2 == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(3);
            }
            if (variables2 == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(4);
            }
            for (String var : variables2) {
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)var).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable)).withInsertHandler((InsertHandler)CLOSING_BRACES), (double)20.0));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpVariableCompletionProvider$HttpEnvironmentVariableCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillVariables";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillEnvironmentVariables";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpDynamicVariableCompletionProvider
    extends HttpVariableCompletionProvider {
        private HttpDynamicVariableCompletionProvider() {
        }

        @Override
        protected void fillVariables(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull PsiElement element) {
            if (parameters == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (result2 == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (element == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            HttpDynamicVariableCompletionProvider.fillDynamicVariables(result2, HttpClientDynamicVariableDescription.Position.ALL, false);
            if (PsiTreeUtil.getParentOfType((PsiElement)element, HttpOutputFilePath.class, (boolean)false) != null) {
                HttpDynamicVariableCompletionProvider.fillDynamicVariables(result2, HttpClientDynamicVariableDescription.Position.IN_FILE_PATH, false);
            }
        }

        @NotNull
        private static InsertHandler<LookupElement> addParensIfNeeded(@NotNull HttpClientDynamicVariableValue value) {
            if (value == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(3);
            }
            if (!(value instanceof HttpClientDynamicVariableValue.FunctionValue)) {
                HttpSuffixInsertHandler httpSuffixInsertHandler = CLOSING_BRACES;
                if (httpSuffixInsertHandler == null) {
                    HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(4);
                }
                return httpSuffixInsertHandler;
            }
            InsertHandler insertHandler = (context, item) -> {
                CLOSING_BRACES.handleInsert(context, item);
                Editor editor2 = context.getEditor();
                int offset = editor2.getCaretModel().getOffset();
                if (offset < CLOSING_BRACES.getSuffix().length()) {
                    return;
                }
                editor2.getCaretModel().moveToOffset(offset - CLOSING_BRACES.getSuffix().length());
                editor2.getDocument().insertString(offset -= CLOSING_BRACES.getSuffix().length(), (CharSequence)"()");
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor2.getDocument());
                editor2.getCaretModel().moveToOffset(offset + 1);
            };
            if (insertHandler == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(5);
            }
            return insertHandler;
        }

        private static void fillDynamicVariables(@NotNull CompletionResultSet resultSet, @NotNull HttpClientDynamicVariableDescription.Position position, boolean withSign) {
            if (resultSet == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(6);
            }
            if (position == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(7);
            }
            List<HttpClientDynamicVariableDescription> variables2 = HttpClientDynamicVariables.getInstance().getVariablesCollection().allVariablesIn(position);
            for (HttpClientDynamicVariableDescription var : variables2) {
                resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)(withSign ? HttpDynamicVariableCompletionProvider.addDynamicSign(var.getName()) : var.getName())).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Function)).withPresentableText(HttpDynamicVariableCompletionProvider.addDynamicSign(var.getName())).withInsertHandler(HttpDynamicVariableCompletionProvider.addParensIfNeeded(var.getValue())), (double)20.0));
            }
        }

        @NotNull
        private static String addDynamicSign(@NotNull String name) {
            if (name == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(8);
            }
            Object object = name.startsWith(DYNAMIC_SIGN) ? name : DYNAMIC_SIGN + name;
            if (object == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(9);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/completion/HttpVariableCompletionProvider$HttpDynamicVariableCompletionProvider";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultSet";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpVariableCompletionProvider$HttpDynamicVariableCompletionProvider";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addParensIfNeeded";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addDynamicSign";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fillVariables";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addParensIfNeeded";
                    break;
                }
                case 4: 
                case 5: 
                case 9: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "fillDynamicVariables";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addDynamicSign";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 9 -> new IllegalStateException(string);
            };
        }
    }
}

