/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/ReplacePlaceholderFix;", "Lcom/intellij/codeInspection/IntentionAndQuickFixAction;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "getFamilyName", "", "getName", "runTemplate", "psiElement", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "startInWriteAction", "", "Companion", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestPlaceholderInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestPlaceholderInspection.kt\ncom/intellij/httpClient/http/request/codeInsight/ReplacePlaceholderFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n61#2:132\n61#2:133\n288#3,2:134\n*S KotlinDebug\n*F\n+ 1 HttpRequestPlaceholderInspection.kt\ncom/intellij/httpClient/http/request/codeInsight/ReplacePlaceholderFix\n*L\n79#1:132\n85#1:133\n88#1:134,2\n*E\n"})
final class ReplacePlaceholderFix
extends IntentionAndQuickFixAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXAMPLE_NEW_VALUE = "non-placeholder-value";

    @NotNull
    public String getName() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        String string = RestClientBundle.message("http.request.placeholder.inspection.message.fix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @Nullable PsiFile file, @Nullable Editor editor2) {
        Object v3;
        HttpMessageBody messageBody;
        block7: {
            void $this$firstOrNull$iv;
            void $this$parentOfType$iv;
            void $this$parentOfType$iv2;
            PsiElement element;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (editor2 == null) {
                return;
            }
            if (file == null) {
                return;
            }
            int offset = editor2.getCaretModel().getOffset();
            PsiElement psiElement = file.findElementAt(offset);
            if (psiElement == null) {
                return;
            }
            PsiElement psiElement2 = element = psiElement;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType22 = false;
            HttpDynamicVariable dynamicVariable = (HttpDynamicVariable)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv2, HttpDynamicVariable.class, (boolean)false);
            if (dynamicVariable != null) {
                this.runTemplate((PsiElement)dynamicVariable, new TextRange(0, dynamicVariable.getTextRange().getLength()), editor2);
                return;
            }
            PsiElement $i$f$parentOfType22 = element;
            boolean withSelf$iv22 = true;
            boolean $i$f$parentOfType = false;
            HttpMessageBody httpMessageBody = (HttpMessageBody)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, HttpMessageBody.class, (boolean)false);
            if (httpMessageBody == null) {
                return;
            }
            messageBody = httpMessageBody;
            List<TextRange> list2 = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageBody.getText());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"collectVariablesRangesInMessageBody(...)");
            Iterable withSelf$iv22 = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TextRange it = (TextRange)element$iv;
                boolean bl = false;
                if (!it.contains(offset - messageBody.getTextOffset())) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        TextRange textRange = v3;
        if (textRange == null) {
            return;
        }
        TextRange currentTextRange = textRange;
        this.runTemplate((PsiElement)messageBody, currentTextRange, editor2);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HttpDynamicVariable httpDynamicVariable = (HttpDynamicVariable)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor2.getCaretModel().getOffset(), HttpDynamicVariable.class, (boolean)false);
        if (httpDynamicVariable == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.FALLBACK_DIFF;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"FALLBACK_DIFF");
            return intentionPreviewInfo;
        }
        HttpDynamicVariable dynamicVariable = httpDynamicVariable;
        String string = dynamicVariable.getTextRange().replace(file.getText(), EXAMPLE_NEW_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
        String text2 = string;
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff((FileType)HttpRequestFileType.INSTANCE, "", text2);
    }

    private final void runTemplate(PsiElement psiElement, TextRange textRange, Editor editor2) {
        TemplateBuilderImpl template = new TemplateBuilderImpl(psiElement);
        template.replaceElement(psiElement, textRange, "VAR", (Expression)new ConstantNode(textRange.substring(psiElement.getText())), true);
        WriteCommandAction.writeCommandAction((Project)psiElement.getProject()).withName(RestClientBundle.message("http.request.placeholder.inspection.message.fix", new Object[0])).run(() -> ReplacePlaceholderFix.runTemplate$lambda$1(template, editor2));
    }

    private static final void runTemplate$lambda$1(TemplateBuilderImpl $template, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)$template, (String)"$template");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        $template.run($editor, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/ReplacePlaceholderFix$Companion;", "", "()V", "EXAMPLE_NEW_VALUE", "", "intellij.restClient"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

